/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import org.eclipse.jgit.util.StringUtils;

class ConfigLine {
    String prefix;
    String section;
    String subsection;
    String name;
    String value;
    String suffix;
    String includedFrom;

    ConfigLine() {
    }

    ConfigLine forValue(String string) {
        ConfigLine configLine = new ConfigLine();
        configLine.prefix = this.prefix;
        configLine.section = this.section;
        configLine.subsection = this.subsection;
        configLine.name = this.name;
        configLine.value = string;
        configLine.suffix = this.suffix;
        configLine.includedFrom = this.includedFrom;
        return configLine;
    }

    boolean match(String string, String string2, String string3) {
        return ConfigLine.eqIgnoreCase(this.section, string) && ConfigLine.eqSameCase(this.subsection, string2) && ConfigLine.eqIgnoreCase(this.name, string3);
    }

    boolean match(String string, String string2) {
        return ConfigLine.eqIgnoreCase(this.section, string) && ConfigLine.eqSameCase(this.subsection, string2);
    }

    private static boolean eqIgnoreCase(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return StringUtils.equalsIgnoreCase(string, string2);
    }

    private static boolean eqSameCase(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    public String toString() {
        if (this.section == null) {
            return "<empty>";
        }
        StringBuilder stringBuilder = new StringBuilder(this.section);
        if (this.subsection != null) {
            stringBuilder.append(".").append(this.subsection);
        }
        if (this.name != null) {
            stringBuilder.append(".").append(this.name);
        }
        if (this.value != null) {
            stringBuilder.append("=").append(this.value);
        }
        return stringBuilder.toString();
    }
}

