/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.events.ConfigChangedEvent;
import org.eclipse.jgit.events.ConfigChangedListener;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.ListenerList;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Config$ConfigEnum;
import org.eclipse.jgit.lib.Config$NamesInSection;
import org.eclipse.jgit.lib.Config$SectionNames;
import org.eclipse.jgit.lib.Config$SectionParser;
import org.eclipse.jgit.lib.Config$StringReader;
import org.eclipse.jgit.lib.Config$SubsectionNames;
import org.eclipse.jgit.lib.ConfigLine;
import org.eclipse.jgit.lib.ConfigSnapshot;
import org.eclipse.jgit.lib.DefaultTypedConfigGetter;
import org.eclipse.jgit.lib.TypedConfigGetter;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.RawParseUtils;

public class Config {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    static final long KiB = 1024L;
    static final long MiB = 0x100000L;
    static final long GiB = 0x40000000L;
    private static final int MAX_DEPTH = 10;
    private static final TypedConfigGetter DEFAULT_GETTER;
    private static TypedConfigGetter typedGetter;
    private final ListenerList listeners = new ListenerList();
    private final AtomicReference state;
    private final Config baseConfig;
    private static final String MISSING_ENTRY;

    public Config() {
        this(null);
    }

    public Config(Config config) {
        this.baseConfig = config;
        this.state = new AtomicReference<ConfigSnapshot>(this.newState());
    }

    public Config getBaseConfig() {
        return this.baseConfig;
    }

    public static boolean isMissing(String string) {
        return string == MISSING_ENTRY;
    }

    public static void setTypedConfigGetter(TypedConfigGetter typedConfigGetter) {
        typedGetter = typedConfigGetter == null ? DEFAULT_GETTER : typedConfigGetter;
    }

    static String escapeValue(String string) {
        if (string.isEmpty()) {
            return "";
        }
        boolean bl2 = string.charAt(0) == ' ' || string.charAt(string.length() - 1) == ' ';
        StringBuilder stringBuilder = new StringBuilder(string.length());
        block9: for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\u0000': {
                    throw new IllegalArgumentException(JGitText.get().configValueContainsNullByte);
                }
                case '\n': {
                    stringBuilder.append('\\').append('n');
                    continue block9;
                }
                case '\t': {
                    stringBuilder.append('\\').append('t');
                    continue block9;
                }
                case '\b': {
                    stringBuilder.append('\\').append('b');
                    continue block9;
                }
                case '\\': {
                    stringBuilder.append('\\').append('\\');
                    continue block9;
                }
                case '\"': {
                    stringBuilder.append('\\').append('\"');
                    continue block9;
                }
                case '#': 
                case ';': {
                    bl2 = true;
                    stringBuilder.append(c2);
                    continue block9;
                }
                default: {
                    stringBuilder.append(c2);
                }
            }
        }
        return bl2 ? '\"' + stringBuilder.toString() + '\"' : stringBuilder.toString();
    }

    static String escapeSubsection(String string) {
        if (string.isEmpty()) {
            return "\"\"";
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 2).append('\"');
        block5: for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\u0000': {
                    throw new IllegalArgumentException(JGitText.get().configSubsectionContainsNullByte);
                }
                case '\n': {
                    throw new IllegalArgumentException(JGitText.get().configSubsectionContainsNewline);
                }
                case '\"': 
                case '\\': {
                    stringBuilder.append('\\').append(c2);
                    continue block5;
                }
                default: {
                    stringBuilder.append(c2);
                }
            }
        }
        return stringBuilder.append('\"').toString();
    }

    public int getInt(String string, String string2, int n2) {
        return typedGetter.getInt(this, string, null, string2, n2);
    }

    public int getInt(String string, String string2, String string3, int n2) {
        return typedGetter.getInt(this, string, string2, string3, n2);
    }

    public long getLong(String string, String string2, long l2) {
        return typedGetter.getLong(this, string, null, string2, l2);
    }

    public long getLong(String string, String string2, String string3, long l2) {
        return typedGetter.getLong(this, string, string2, string3, l2);
    }

    public boolean getBoolean(String string, String string2, boolean bl2) {
        return typedGetter.getBoolean(this, string, null, string2, bl2);
    }

    public boolean getBoolean(String string, String string2, String string3, boolean bl2) {
        return typedGetter.getBoolean(this, string, string2, string3, bl2);
    }

    public Enum getEnum(String string, String string2, String string3, Enum enum_) {
        Enum[] enumArray = (Enum[])Config.allValuesOf(enum_);
        return typedGetter.getEnum(this, enumArray, string, string2, string3, enum_);
    }

    private static Object[] allValuesOf(Object object) {
        try {
            return (Object[])object.getClass().getMethod("values", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            String string = object.getClass().getName();
            String string2 = MessageFormat.format(JGitText.get().enumValuesNotAvailable, string);
            throw new IllegalArgumentException(string2, exception);
        }
    }

    public Enum getEnum(Enum[] enumArray, String string, String string2, String string3, Enum enum_) {
        return typedGetter.getEnum(this, enumArray, string, string2, string3, enum_);
    }

    public String getString(String string, String string2, String string3) {
        return this.getRawString(string, string2, string3);
    }

    public String[] getStringList(String string, String string2, String string3) {
        String[] stringArray = this.baseConfig != null ? this.baseConfig.getStringList(string, string2, string3) : EMPTY_STRING_ARRAY;
        List list = this.getRawStringList(string, string2, string3);
        if (list != null) {
            String[] stringArray2 = new String[stringArray.length + list.size()];
            int n2 = stringArray.length;
            System.arraycopy(stringArray, 0, stringArray2, 0, n2);
            for (String string4 : list) {
                stringArray2[n2++] = string4;
            }
            return stringArray2;
        }
        return stringArray;
    }

    public long getTimeUnit(String string, String string2, String string3, long l2, TimeUnit timeUnit) {
        return typedGetter.getTimeUnit(this, string, string2, string3, l2, timeUnit);
    }

    public Path getPath(String string, String string2, String string3, @NonNull FS fS, File file, Path path) {
        return typedGetter.getPath(this, string, string2, string3, fS, file, path);
    }

    public List getRefSpecs(String string, String string2, String string3) {
        return typedGetter.getRefSpecs(this, string, string2, string3);
    }

    public Set getSubsections(String string) {
        return (Set)this.get(new Config$SubsectionNames(string));
    }

    public Set getSections() {
        return (Set)this.get(new Config$SectionNames(null));
    }

    public Set getNames(String string) {
        return this.getNames(string, null);
    }

    public Set getNames(String string, String string2) {
        return (Set)this.get(new Config$NamesInSection(string, string2));
    }

    public Object get(Config$SectionParser config$SectionParser) {
        ConfigSnapshot configSnapshot = this.getState();
        Object object = configSnapshot.cache.get(config$SectionParser);
        if (object == null) {
            object = config$SectionParser.parse(this);
            configSnapshot.cache.put(config$SectionParser, object);
        }
        return object;
    }

    public void uncache(Config$SectionParser config$SectionParser) {
        ((ConfigSnapshot)this.state.get()).cache.remove(config$SectionParser);
    }

    public ListenerHandle addChangeListener(ConfigChangedListener configChangedListener) {
        return this.listeners.addConfigChangedListener(configChangedListener);
    }

    protected boolean notifyUponTransientChanges() {
        return true;
    }

    protected void fireConfigChangedEvent() {
        this.listeners.dispatch(new ConfigChangedEvent());
    }

    String getRawString(String string, String string2, String string3) {
        List list = this.getRawStringList(string, string2, string3);
        if (list != null) {
            return (String)list.get(0);
        }
        if (this.baseConfig != null) {
            return this.baseConfig.getRawString(string, string2, string3);
        }
        return null;
    }

    private List getRawStringList(String string, String string2, String string3) {
        List list = null;
        for (ConfigLine configLine : ((ConfigSnapshot)this.state.get()).entryList) {
            if (!configLine.match(string, string2, string3)) continue;
            list = Config.add(list, configLine.value);
        }
        return list;
    }

    private static List add(List list, String string) {
        if (list == null) {
            return Collections.singletonList(string);
        }
        if (list.size() == 1) {
            ArrayList arrayList = new ArrayList(2);
            arrayList.add(list.get(0));
            arrayList.add(string);
            return arrayList;
        }
        list.add(string);
        return list;
    }

    private ConfigSnapshot getState() {
        ConfigSnapshot configSnapshot;
        ConfigSnapshot configSnapshot2;
        ConfigSnapshot configSnapshot3;
        do {
            configSnapshot3 = (ConfigSnapshot)this.state.get();
            configSnapshot = this.getBaseState();
            if (configSnapshot3.baseState != configSnapshot) continue;
            return configSnapshot3;
        } while (!this.state.compareAndSet(configSnapshot3, configSnapshot2 = new ConfigSnapshot(configSnapshot3.entryList, configSnapshot)));
        return configSnapshot2;
    }

    private ConfigSnapshot getBaseState() {
        return this.baseConfig != null ? this.baseConfig.getState() : null;
    }

    public void setInt(String string, String string2, String string3, int n2) {
        this.setLong(string, string2, string3, n2);
    }

    public void setLong(String string, String string2, String string3, long l2) {
        String string4 = l2 >= 0x40000000L && l2 % 0x40000000L == 0L ? String.valueOf(l2 / 0x40000000L) + "g" : (l2 >= 0x100000L && l2 % 0x100000L == 0L ? String.valueOf(l2 / 0x100000L) + "m" : (l2 >= 1024L && l2 % 1024L == 0L ? String.valueOf(l2 / 1024L) + "k" : String.valueOf(l2)));
        this.setString(string, string2, string3, string4);
    }

    public void setBoolean(String string, String string2, String string3, boolean bl2) {
        this.setString(string, string2, string3, bl2 ? "true" : "false");
    }

    public void setEnum(String string, String string2, String string3, Enum enum_) {
        String string4 = enum_ instanceof Config$ConfigEnum ? ((Config$ConfigEnum)((Object)enum_)).toConfigValue() : enum_.name().toLowerCase(Locale.ROOT).replace('_', ' ');
        this.setString(string, string2, string3, string4);
    }

    public void setString(String string, String string2, String string3, String string4) {
        this.setStringList(string, string2, string3, Collections.singletonList(string4));
    }

    public void unset(String string, String string2, String string3) {
        this.setStringList(string, string2, string3, Collections.emptyList());
    }

    public void unsetSection(String string, String string2) {
        ConfigSnapshot configSnapshot;
        ConfigSnapshot configSnapshot2;
        while (!this.state.compareAndSet(configSnapshot2 = (ConfigSnapshot)this.state.get(), configSnapshot = this.unsetSection(configSnapshot2, string, string2))) {
        }
    }

    private ConfigSnapshot unsetSection(ConfigSnapshot configSnapshot, String string, String string2) {
        int n2 = configSnapshot.entryList.size();
        ArrayList<ConfigLine> arrayList = new ArrayList<ConfigLine>(n2);
        boolean bl2 = false;
        for (ConfigLine configLine : configSnapshot.entryList) {
            if (configLine.includedFrom == null && configLine.match(string, string2)) {
                bl2 = true;
                continue;
            }
            if (bl2 && configLine.section == null && configLine.subsection == null) continue;
            arrayList.add(configLine);
        }
        return this.newState(arrayList);
    }

    public void setStringList(String string, String string2, String string3, List list) {
        ConfigSnapshot configSnapshot;
        ConfigSnapshot configSnapshot2;
        while (!this.state.compareAndSet(configSnapshot2 = (ConfigSnapshot)this.state.get(), configSnapshot = this.replaceStringList(configSnapshot2, string, string2, string3, list))) {
        }
        if (this.notifyUponTransientChanges()) {
            this.fireConfigChangedEvent();
        }
    }

    private ConfigSnapshot replaceStringList(ConfigSnapshot configSnapshot, String string, String string2, String string3, List list) {
        ConfigLine configLine;
        int n2;
        List list2 = Config.copy(configSnapshot, list);
        int n3 = 0;
        int n4 = -1;
        for (n2 = 0; n2 < list2.size() && n3 < list.size(); ++n2) {
            configLine = (ConfigLine)list2.get(n2);
            if (configLine.includedFrom != null || !configLine.match(string, string2, string3)) continue;
            list2.set(n2, configLine.forValue((String)list.get(n3++)));
            n4 = n2 + 1;
        }
        if (n3 == list.size() && n2 < list2.size()) {
            while (n2 < list2.size()) {
                configLine = (ConfigLine)list2.get(n2++);
                if (configLine.includedFrom != null || !configLine.match(string, string2, string3)) continue;
                list2.remove(--n2);
            }
        }
        if (n3 < list.size() && n2 == list2.size()) {
            if (n4 < 0) {
                n4 = Config.findSectionEnd(list2, string, string2, true);
            }
            if (n4 < 0) {
                configLine = new ConfigLine();
                configLine.section = string;
                configLine.subsection = string2;
                list2.add(configLine);
                n4 = list2.size();
            }
            while (n3 < list.size()) {
                configLine = new ConfigLine();
                configLine.section = string;
                configLine.subsection = string2;
                configLine.name = string3;
                configLine.value = (String)list.get(n3++);
                list2.add(n4++, configLine);
            }
        }
        return this.newState(list2);
    }

    private static List copy(ConfigSnapshot configSnapshot, List list) {
        int n2 = configSnapshot.entryList.size() + list.size() + 1;
        ArrayList arrayList = new ArrayList(n2);
        arrayList.addAll(configSnapshot.entryList);
        return arrayList;
    }

    private static int findSectionEnd(List list, String string, String string2, boolean bl2) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ConfigLine configLine = (ConfigLine)list.get(i2);
            if (configLine.includedFrom != null && bl2 || !configLine.match(string, string2, null)) continue;
            ++i2;
            while (i2 < list.size() && (configLine = (ConfigLine)list.get(i2)).match(string, string2, configLine.name)) {
                ++i2;
            }
            return i2;
        }
        return -1;
    }

    public String toText() {
        StringBuilder stringBuilder = new StringBuilder();
        for (ConfigLine configLine : ((ConfigSnapshot)this.state.get()).entryList) {
            if (configLine.includedFrom != null) continue;
            if (configLine.prefix != null) {
                stringBuilder.append(configLine.prefix);
            }
            if (configLine.section != null && configLine.name == null) {
                stringBuilder.append('[');
                stringBuilder.append(configLine.section);
                if (configLine.subsection != null) {
                    boolean bl2;
                    stringBuilder.append(' ');
                    String string = Config.escapeValue(configLine.subsection);
                    boolean bl3 = bl2 = string.startsWith("\"") && string.endsWith("\"");
                    if (!bl2) {
                        stringBuilder.append('\"');
                    }
                    stringBuilder.append(string);
                    if (!bl2) {
                        stringBuilder.append('\"');
                    }
                }
                stringBuilder.append(']');
            } else if (configLine.section != null && configLine.name != null) {
                if (configLine.prefix == null || "".equals(configLine.prefix)) {
                    stringBuilder.append('\t');
                }
                stringBuilder.append(configLine.name);
                if (!Config.isMissing(configLine.value)) {
                    stringBuilder.append(" =");
                    if (configLine.value != null) {
                        stringBuilder.append(' ');
                        stringBuilder.append(Config.escapeValue(configLine.value));
                    }
                }
                if (configLine.suffix != null) {
                    stringBuilder.append(' ');
                }
            }
            if (configLine.suffix != null) {
                stringBuilder.append(configLine.suffix);
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public void fromText(String string) {
        this.state.set(this.newState(this.fromTextRecurse(string, 1, null)));
    }

    private List fromTextRecurse(String string, int n2, String string2) {
        ArrayList<ConfigLine> arrayList;
        block15: {
            if (n2 > 10) {
                throw new ConfigInvalidException(JGitText.get().tooManyIncludeRecursions);
            }
            arrayList = new ArrayList<ConfigLine>();
            Config$StringReader config$StringReader = new Config$StringReader(string);
            ConfigLine configLine = null;
            ConfigLine configLine2 = new ConfigLine();
            configLine2.includedFrom = string2;
            while (true) {
                int n3;
                if (-1 == (n3 = config$StringReader.read())) {
                    if (configLine2.section != null) {
                        arrayList.add(configLine2);
                    }
                    break block15;
                }
                char c2 = (char)n3;
                if ('\n' == c2) {
                    arrayList.add(configLine2);
                    if (configLine2.section != null) {
                        configLine = configLine2;
                    }
                    configLine2 = new ConfigLine();
                    configLine2.includedFrom = string2;
                    continue;
                }
                if (configLine2.suffix != null) {
                    configLine2.suffix = configLine2.suffix + c2;
                    continue;
                }
                if (';' == c2 || '#' == c2) {
                    configLine2.suffix = String.valueOf(c2);
                    continue;
                }
                if (configLine2.section == null && Character.isWhitespace(c2)) {
                    if (configLine2.prefix == null) {
                        configLine2.prefix = "";
                    }
                    configLine2.prefix = configLine2.prefix + c2;
                    continue;
                }
                if ('[' == c2) {
                    configLine2.section = Config.readSectionName(config$StringReader);
                    n3 = config$StringReader.read();
                    if (34 == n3) {
                        configLine2.subsection = Config.readSubsectionName(config$StringReader);
                        n3 = config$StringReader.read();
                    }
                    if (93 != n3) {
                        throw new ConfigInvalidException(JGitText.get().badGroupHeader);
                    }
                    configLine2.suffix = "";
                    continue;
                }
                if (configLine == null) break;
                configLine2.section = configLine.section;
                configLine2.subsection = configLine.subsection;
                config$StringReader.reset();
                configLine2.name = Config.readKeyName(config$StringReader);
                if (configLine2.name.endsWith("\n")) {
                    configLine2.name = configLine2.name.substring(0, configLine2.name.length() - 1);
                    configLine2.value = MISSING_ENTRY;
                } else {
                    configLine2.value = Config.readValue(config$StringReader);
                }
                if (!configLine2.section.equalsIgnoreCase("include")) continue;
                this.addIncludedConfig(arrayList, configLine2, n2);
            }
            throw new ConfigInvalidException(JGitText.get().invalidLineInConfigFile);
        }
        return arrayList;
    }

    protected byte[] readIncludedConfig(String string) {
        return null;
    }

    private void addIncludedConfig(List list, ConfigLine configLine, int n2) {
        if (!configLine.name.equalsIgnoreCase("path") || configLine.value == null || configLine.value.equals(MISSING_ENTRY)) {
            throw new ConfigInvalidException(MessageFormat.format(JGitText.get().invalidLineInConfigFileWithParam, configLine));
        }
        byte[] byArray = this.readIncludedConfig(configLine.value);
        if (byArray == null) {
            return;
        }
        String string = this.isUtf8(byArray) ? RawParseUtils.decode(StandardCharsets.UTF_8, byArray, 3, byArray.length) : RawParseUtils.decode(byArray);
        try {
            list.addAll(this.fromTextRecurse(string, n2 + 1, configLine.value));
        }
        catch (ConfigInvalidException configInvalidException) {
            throw new ConfigInvalidException(MessageFormat.format(JGitText.get().cannotReadFile, configLine.value), configInvalidException);
        }
    }

    private ConfigSnapshot newState() {
        return new ConfigSnapshot(Collections.emptyList(), this.getBaseState());
    }

    private ConfigSnapshot newState(List list) {
        return new ConfigSnapshot(Collections.unmodifiableList(list), this.getBaseState());
    }

    protected void clear() {
        this.state.set(this.newState());
    }

    protected boolean isUtf8(byte[] byArray) {
        return byArray.length >= 3 && byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65;
    }

    private static String readSectionName(Config$StringReader config$StringReader) {
        StringBuilder stringBuilder;
        block6: {
            stringBuilder = new StringBuilder();
            while (true) {
                int n2;
                if ((n2 = config$StringReader.read()) < 0) {
                    throw new ConfigInvalidException(JGitText.get().unexpectedEndOfConfigFile);
                }
                if (93 == n2) {
                    config$StringReader.reset();
                    break block6;
                }
                if (32 == n2 || 9 == n2) {
                    do {
                        if ((n2 = config$StringReader.read()) < 0) {
                            throw new ConfigInvalidException(JGitText.get().unexpectedEndOfConfigFile);
                        }
                        if (34 != n2) continue;
                        config$StringReader.reset();
                        break block6;
                    } while (32 == n2 || 9 == n2);
                    throw new ConfigInvalidException(MessageFormat.format(JGitText.get().badSectionEntry, stringBuilder));
                }
                if (!Character.isLetterOrDigit((char)n2) && 46 != n2 && 45 != n2) break;
                stringBuilder.append((char)n2);
            }
            throw new ConfigInvalidException(MessageFormat.format(JGitText.get().badSectionEntry, stringBuilder));
        }
        return stringBuilder.toString();
    }

    private static String readKeyName(Config$StringReader config$StringReader) {
        StringBuilder stringBuilder;
        block7: {
            int n2;
            stringBuilder = new StringBuilder();
            while (true) {
                if ((n2 = config$StringReader.read()) < 0) {
                    throw new ConfigInvalidException(JGitText.get().unexpectedEndOfConfigFile);
                }
                if (61 == n2) break block7;
                if (32 == n2 || 9 == n2) {
                    do {
                        if ((n2 = config$StringReader.read()) < 0) {
                            throw new ConfigInvalidException(JGitText.get().unexpectedEndOfConfigFile);
                        }
                        if (61 == n2) break block7;
                        if (59 != n2 && 35 != n2 && 10 != n2) continue;
                        config$StringReader.reset();
                        break block7;
                    } while (32 == n2 || 9 == n2);
                    throw new ConfigInvalidException(JGitText.get().badEntryDelimiter);
                }
                if (!Character.isLetterOrDigit((char)n2) && n2 != 45) break;
                stringBuilder.append((char)n2);
            }
            if (10 == n2) {
                config$StringReader.reset();
                stringBuilder.append((char)n2);
            } else {
                throw new ConfigInvalidException(MessageFormat.format(JGitText.get().badEntryName, stringBuilder));
            }
        }
        return stringBuilder.toString();
    }

    private static String readSubsectionName(Config$StringReader config$StringReader) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        block4: while ((n2 = config$StringReader.read()) >= 0) {
            if (10 == n2) {
                throw new ConfigInvalidException(JGitText.get().newlineInQuotesNotAllowed);
            }
            if (92 == n2) {
                n2 = config$StringReader.read();
                switch (n2) {
                    case -1: {
                        throw new ConfigInvalidException(JGitText.get().endOfFileInEscape);
                    }
                    case 34: 
                    case 92: {
                        stringBuilder.append((char)n2);
                        continue block4;
                    }
                }
                stringBuilder.append((char)n2);
                continue;
            }
            if (34 == n2) break;
            stringBuilder.append((char)n2);
        }
        return stringBuilder.toString();
    }

    private static String readValue(Config$StringReader config$StringReader) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = null;
        boolean bl2 = false;
        boolean bl3 = true;
        block10: while ((n2 = config$StringReader.read()) >= 0) {
            if (10 == n2) {
                if (bl2) {
                    throw new ConfigInvalidException(JGitText.get().newlineInQuotesNotAllowed);
                }
                config$StringReader.reset();
                break;
            }
            if (!(bl2 || 59 != n2 && 35 != n2)) {
                if (stringBuilder2 != null) {
                    stringBuilder2.setLength(0);
                }
                config$StringReader.reset();
                break;
            }
            char c2 = (char)n2;
            if (Character.isWhitespace(c2)) {
                if (bl3) continue;
                if (stringBuilder2 == null) {
                    stringBuilder2 = new StringBuilder();
                }
                stringBuilder2.append(c2);
                continue;
            }
            bl3 = false;
            if (stringBuilder2 != null) {
                stringBuilder.append((CharSequence)stringBuilder2);
                stringBuilder2.setLength(0);
            }
            if (92 == n2) {
                n2 = config$StringReader.read();
                switch (n2) {
                    case -1: {
                        throw new ConfigInvalidException(JGitText.get().endOfFileInEscape);
                    }
                    case 10: {
                        continue block10;
                    }
                    case 116: {
                        stringBuilder.append('\t');
                        continue block10;
                    }
                    case 98: {
                        stringBuilder.append('\b');
                        continue block10;
                    }
                    case 110: {
                        stringBuilder.append('\n');
                        continue block10;
                    }
                    case 92: {
                        stringBuilder.append('\\');
                        continue block10;
                    }
                    case 34: {
                        stringBuilder.append('\"');
                        continue block10;
                    }
                    case 13: {
                        int n3 = config$StringReader.read();
                        if (n3 == 10) continue block10;
                        if (n3 < 0) break;
                        config$StringReader.reset();
                        break;
                    }
                }
                throw new ConfigInvalidException(MessageFormat.format(JGitText.get().badEscape, Character.isAlphabetic(n2) ? Character.valueOf((char)n2) : Config.toUnicodeLiteral(n2)));
            }
            if (34 == n2) {
                bl2 = !bl2;
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.length() > 0 ? stringBuilder.toString() : null;
    }

    private static String toUnicodeLiteral(int n2) {
        return String.format("\\u%04x", n2);
    }

    static /* synthetic */ AtomicReference access$100(Config config) {
        return config.state;
    }

    static /* synthetic */ Config access$200(Config config) {
        return config.baseConfig;
    }

    static {
        typedGetter = DEFAULT_GETTER = new DefaultTypedConfigGetter();
        MISSING_ENTRY = new String();
    }
}

