/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.text.MessageFormat;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Config$SectionParser;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;

public class CommitConfig {
    public static final Config$SectionParser KEY = CommitConfig::new;
    private static final Charset DEFAULT_COMMIT_MESSAGE_ENCODING = StandardCharsets.UTF_8;
    private String i18nCommitEncoding;
    private String commitTemplatePath;

    private CommitConfig(Config config) {
        this.commitTemplatePath = config.getString("commit", null, "template");
        this.i18nCommitEncoding = config.getString("i18n", null, "commitEncoding");
    }

    @Nullable
    public String getCommitTemplatePath() {
        return this.commitTemplatePath;
    }

    @Nullable
    public String getCommitEncoding() {
        return this.i18nCommitEncoding;
    }

    @Nullable
    public String getCommitTemplateContent() {
        if (this.commitTemplatePath == null) {
            return null;
        }
        File file = this.commitTemplatePath.startsWith("~/") ? FS.DETECTED.resolve(FS.DETECTED.userHome(), this.commitTemplatePath.substring(2)) : FS.DETECTED.resolve(null, this.commitTemplatePath);
        Charset charset = this.getEncoding();
        return RawParseUtils.decode(charset, IO.readFully(file));
    }

    private Charset getEncoding() {
        Charset charset = DEFAULT_COMMIT_MESSAGE_ENCODING;
        if (this.i18nCommitEncoding == null) {
            return null;
        }
        try {
            charset = Charset.forName(this.i18nCommitEncoding);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
            throw new ConfigInvalidException(MessageFormat.format(JGitText.get().invalidEncoding, this.i18nCommitEncoding), illegalArgumentException);
        }
        return charset;
    }
}

