/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.GpgSignature;
import org.eclipse.jgit.lib.ObjectBuilder;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.util.References;

public class CommitBuilder
extends ObjectBuilder {
    private static final ObjectId[] EMPTY_OBJECTID_LIST = new ObjectId[0];
    private static final byte[] htree = Constants.encodeASCII("tree");
    private static final byte[] hparent = Constants.encodeASCII("parent");
    private static final byte[] hauthor = Constants.encodeASCII("author");
    private static final byte[] hcommitter = Constants.encodeASCII("committer");
    private static final byte[] hgpgsig = Constants.encodeASCII("gpgsig");
    private ObjectId treeId;
    private ObjectId[] parentIds = EMPTY_OBJECTID_LIST;
    private PersonIdent committer;

    public ObjectId getTreeId() {
        return this.treeId;
    }

    public void setTreeId(AnyObjectId anyObjectId) {
        this.treeId = anyObjectId.copy();
    }

    @Override
    public PersonIdent getAuthor() {
        return super.getAuthor();
    }

    @Override
    public void setAuthor(PersonIdent personIdent) {
        super.setAuthor(personIdent);
    }

    public PersonIdent getCommitter() {
        return this.committer;
    }

    public void setCommitter(PersonIdent personIdent) {
        this.committer = personIdent;
    }

    public ObjectId[] getParentIds() {
        return this.parentIds;
    }

    public void setParentId(AnyObjectId anyObjectId) {
        this.parentIds = new ObjectId[]{anyObjectId.copy()};
    }

    public void setParentIds(AnyObjectId anyObjectId, AnyObjectId anyObjectId2) {
        this.parentIds = new ObjectId[]{anyObjectId.copy(), anyObjectId2.copy()};
    }

    public void setParentIds(ObjectId ... objectIdArray) {
        this.parentIds = new ObjectId[objectIdArray.length];
        for (int i2 = 0; i2 < objectIdArray.length; ++i2) {
            this.parentIds[i2] = objectIdArray[i2].copy();
        }
    }

    public void setParentIds(List list) {
        this.parentIds = new ObjectId[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            this.parentIds[i2] = ((AnyObjectId)list.get(i2)).copy();
        }
    }

    public void addParentId(AnyObjectId anyObjectId) {
        if (this.parentIds.length == 0) {
            this.setParentId(anyObjectId);
        } else {
            ObjectId[] objectIdArray = new ObjectId[this.parentIds.length + 1];
            System.arraycopy(this.parentIds, 0, objectIdArray, 0, this.parentIds.length);
            objectIdArray[this.parentIds.length] = anyObjectId.copy();
            this.parentIds = objectIdArray;
        }
    }

    @Deprecated
    public void setEncoding(String string) {
        this.setEncoding(Charset.forName(string));
    }

    @Override
    public byte[] build() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, this.getEncoding());
        try {
            byteArrayOutputStream.write(htree);
            byteArrayOutputStream.write(32);
            this.getTreeId().copyTo(byteArrayOutputStream);
            byteArrayOutputStream.write(10);
            for (ObjectId objectId : this.getParentIds()) {
                byteArrayOutputStream.write(hparent);
                byteArrayOutputStream.write(32);
                objectId.copyTo(byteArrayOutputStream);
                byteArrayOutputStream.write(10);
            }
            byteArrayOutputStream.write(hauthor);
            byteArrayOutputStream.write(32);
            outputStreamWriter.write(this.getAuthor().toExternalString());
            outputStreamWriter.flush();
            byteArrayOutputStream.write(10);
            byteArrayOutputStream.write(hcommitter);
            byteArrayOutputStream.write(32);
            outputStreamWriter.write(this.getCommitter().toExternalString());
            outputStreamWriter.flush();
            byteArrayOutputStream.write(10);
            GpgSignature gpgSignature = this.getGpgSignature();
            if (gpgSignature != null) {
                byteArrayOutputStream.write(hgpgsig);
                byteArrayOutputStream.write(32);
                CommitBuilder.writeMultiLineHeader(gpgSignature.toExternalString(), byteArrayOutputStream, true);
                byteArrayOutputStream.write(10);
            }
            CommitBuilder.writeEncoding(this.getEncoding(), byteArrayOutputStream);
            byteArrayOutputStream.write(10);
            if (this.getMessage() != null) {
                outputStreamWriter.write(this.getMessage());
                outputStreamWriter.flush();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] toByteArray() {
        return this.build();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Commit");
        stringBuilder.append("={\n");
        stringBuilder.append("tree ");
        stringBuilder.append(this.treeId != null ? this.treeId.name() : "NOT_SET");
        stringBuilder.append("\n");
        for (ObjectId objectId : this.parentIds) {
            stringBuilder.append("parent ");
            stringBuilder.append(objectId.name());
            stringBuilder.append("\n");
        }
        stringBuilder.append("author ");
        stringBuilder.append(this.getAuthor() != null ? this.getAuthor().toString() : "NOT_SET");
        stringBuilder.append("\n");
        stringBuilder.append("committer ");
        stringBuilder.append(this.committer != null ? this.committer.toString() : "NOT_SET");
        stringBuilder.append("\n");
        stringBuilder.append("gpgSignature ");
        GpgSignature gpgSignature = this.getGpgSignature();
        stringBuilder.append(gpgSignature != null ? gpgSignature.toString() : "NOT_SET");
        stringBuilder.append("\n");
        Charset charset = this.getEncoding();
        if (!References.isSameObject(charset, StandardCharsets.UTF_8)) {
            stringBuilder.append("encoding ");
            stringBuilder.append(charset.name());
            stringBuilder.append("\n");
        }
        stringBuilder.append("\n");
        stringBuilder.append(this.getMessage() != null ? this.getMessage() : "");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

