/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.RevWalkUtils;
import org.eclipse.jgit.revwalk.filter.RevFilter;

public class BranchTrackingStatus {
    private final String remoteTrackingBranch;
    private final int aheadCount;
    private final int behindCount;

    public static BranchTrackingStatus of(Repository repository, String string) {
        String string2 = Repository.shortenRefName(string);
        String string3 = "refs/heads/" + string2;
        BranchConfig branchConfig = new BranchConfig(repository.getConfig(), string2);
        String string4 = branchConfig.getTrackingBranch();
        if (string4 == null) {
            return null;
        }
        Ref ref = repository.exactRef(string4);
        if (ref == null) {
            return null;
        }
        Ref ref2 = repository.exactRef(string3);
        if (ref2 == null) {
            return null;
        }
        try (RevWalk revWalk = new RevWalk(repository);){
            RevCommit revCommit = revWalk.parseCommit(ref2.getObjectId());
            RevCommit revCommit2 = revWalk.parseCommit(ref.getObjectId());
            revWalk.setRevFilter(RevFilter.MERGE_BASE);
            revWalk.markStart(revCommit);
            revWalk.markStart(revCommit2);
            RevCommit revCommit3 = revWalk.next();
            revWalk.reset();
            revWalk.setRevFilter(RevFilter.ALL);
            int n2 = RevWalkUtils.count(revWalk, revCommit, revCommit3);
            int n3 = RevWalkUtils.count(revWalk, revCommit2, revCommit3);
            BranchTrackingStatus branchTrackingStatus = new BranchTrackingStatus(string4, n2, n3);
            return branchTrackingStatus;
        }
    }

    private BranchTrackingStatus(String string, int n2, int n3) {
        this.remoteTrackingBranch = string;
        this.aheadCount = n2;
        this.behindCount = n3;
    }

    public String getRemoteTrackingBranch() {
        return this.remoteTrackingBranch;
    }

    public int getAheadCount() {
        return this.aheadCount;
    }

    public int getBehindCount() {
        return this.behindCount;
    }
}

