/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.net.URISyntaxException;
import org.eclipse.jgit.lib.BranchConfig$BranchRebaseMode;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;

public class BranchConfig {
    public static final String LOCAL_REPOSITORY = ".";
    private final Config config;
    private final String branchName;

    public BranchConfig(Config config, String string) {
        this.config = config;
        this.branchName = string;
    }

    public String getTrackingBranch() {
        String string = this.getRemoteOrDefault();
        String string2 = this.getMerge();
        if (string == null || string2 == null) {
            return null;
        }
        if (this.isRemoteLocal()) {
            return string2;
        }
        return this.findRemoteTrackingBranch(string, string2);
    }

    public String getRemoteTrackingBranch() {
        String string = this.getRemoteOrDefault();
        String string2 = this.getMerge();
        if (string == null || string2 == null) {
            return null;
        }
        return this.findRemoteTrackingBranch(string, string2);
    }

    public boolean isRemoteLocal() {
        return LOCAL_REPOSITORY.equals(this.getRemote());
    }

    public String getRemote() {
        return this.config.getString("branch", this.branchName, "remote");
    }

    public String getMerge() {
        return this.config.getString("branch", this.branchName, "merge");
    }

    public boolean isRebase() {
        return this.getRebaseMode() != BranchConfig$BranchRebaseMode.NONE;
    }

    public BranchConfig$BranchRebaseMode getRebaseMode() {
        return (BranchConfig$BranchRebaseMode)this.config.getEnum(BranchConfig$BranchRebaseMode.values(), "branch", this.branchName, "rebase", BranchConfig$BranchRebaseMode.NONE);
    }

    private String findRemoteTrackingBranch(String string, String string2) {
        RemoteConfig remoteConfig;
        try {
            remoteConfig = new RemoteConfig(this.config, string);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
        for (RefSpec refSpec : remoteConfig.getFetchRefSpecs()) {
            if (!refSpec.matchSource(string2)) continue;
            RefSpec refSpec2 = refSpec.expandFromSource(string2);
            return refSpec2.getDestination();
        }
        return null;
    }

    private String getRemoteOrDefault() {
        String string = this.getRemote();
        if (string == null) {
            return "origin";
        }
        return string;
    }
}

