/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.FileNotFoundException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.RawParseUtils;

public class BlobBasedConfig
extends Config {
    public BlobBasedConfig(Config config, byte[] byArray) {
        super(config);
        String string = this.isUtf8(byArray) ? RawParseUtils.decode(StandardCharsets.UTF_8, byArray, 3, byArray.length) : RawParseUtils.decode(byArray);
        this.fromText(string);
    }

    public BlobBasedConfig(Config config, Repository repository, AnyObjectId anyObjectId) {
        this(config, BlobBasedConfig.read(repository, anyObjectId));
    }

    private static byte[] read(Repository repository, AnyObjectId anyObjectId) {
        try (ObjectReader objectReader = repository.newObjectReader();){
            byte[] byArray = BlobBasedConfig.read(objectReader, anyObjectId);
            return byArray;
        }
    }

    private static byte[] read(ObjectReader objectReader, AnyObjectId anyObjectId) {
        ObjectLoader objectLoader = objectReader.open(anyObjectId, 3);
        return objectLoader.getCachedBytes(Integer.MAX_VALUE);
    }

    public BlobBasedConfig(Config config, Repository repository, AnyObjectId anyObjectId, String string) {
        this(config, BlobBasedConfig.read(repository, anyObjectId, string));
    }

    private static byte[] read(Repository repository, AnyObjectId anyObjectId, String string) {
        try (ObjectReader objectReader = repository.newObjectReader();){
            TreeWalk treeWalk = TreeWalk.forPath(objectReader, string, BlobBasedConfig.asTree(objectReader, anyObjectId));
            if (treeWalk == null) {
                throw new FileNotFoundException(MessageFormat.format(JGitText.get().entryNotFoundByPath, string));
            }
            byte[] byArray = BlobBasedConfig.read(objectReader, (AnyObjectId)treeWalk.getObjectId(0));
            return byArray;
        }
    }

    private static AnyObjectId asTree(ObjectReader objectReader, AnyObjectId anyObjectId) {
        if (anyObjectId instanceof RevTree) {
            return anyObjectId;
        }
        if (anyObjectId instanceof RevCommit && ((RevCommit)anyObjectId).getTree() != null) {
            return ((RevCommit)anyObjectId).getTree();
        }
        try (RevWalk revWalk = new RevWalk(objectReader);){
            ObjectId objectId = revWalk.parseTree(anyObjectId).getId();
            return objectId;
        }
    }
}

