/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.lib.BatchingProgressMonitor;
import org.eclipse.jgit.lib.internal.WorkQueue;

class BatchingProgressMonitor$Task
implements Runnable {
    private final String taskName;
    private final int totalWork;
    private volatile boolean display;
    private Future timerFuture;
    private boolean output;
    private int lastWork;
    private int lastPercent;

    BatchingProgressMonitor$Task(String string, int n2) {
        this.taskName = string;
        this.totalWork = n2;
        this.display = true;
    }

    void delay(long l2, TimeUnit timeUnit) {
        this.display = false;
        this.timerFuture = WorkQueue.getExecutor().schedule(this, l2, timeUnit);
    }

    @Override
    public void run() {
        this.display = true;
    }

    void update(BatchingProgressMonitor batchingProgressMonitor, int n2) {
        this.lastWork += n2;
        if (this.totalWork == 0) {
            if (this.display) {
                batchingProgressMonitor.onUpdate(this.taskName, this.lastWork);
                this.output = true;
                this.restartTimer();
            }
        } else {
            int n3 = Math.round((float)this.lastWork * 100.0f / (float)this.totalWork);
            if (this.display) {
                batchingProgressMonitor.onUpdate(this.taskName, this.lastWork, this.totalWork, n3);
                this.output = true;
                this.restartTimer();
                this.lastPercent = n3;
            } else if (n3 != this.lastPercent) {
                batchingProgressMonitor.onUpdate(this.taskName, this.lastWork, this.totalWork, n3);
                this.output = true;
                this.lastPercent = n3;
            }
        }
    }

    private void restartTimer() {
        this.display = false;
        this.timerFuture = WorkQueue.getExecutor().schedule(this, 1L, TimeUnit.SECONDS);
    }

    void end(BatchingProgressMonitor batchingProgressMonitor) {
        if (this.output) {
            if (this.totalWork == 0) {
                batchingProgressMonitor.onEndTask(this.taskName, this.lastWork);
            } else {
                int n2 = Math.round((float)this.lastWork * 100.0f / (float)this.totalWork);
                batchingProgressMonitor.onEndTask(this.taskName, this.lastWork, this.totalWork, n2);
            }
        }
        if (this.timerFuture != null) {
            this.timerFuture.cancel(false);
        }
    }
}

