/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.BatchRefUpdate$1;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.PushCertificate;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.ReceiveCommand$Result;
import org.eclipse.jgit.util.time.ProposedTimestamp;

public class BatchRefUpdate {
    protected static final Duration MAX_WAIT = Duration.ofSeconds(5L);
    private final RefDatabase refdb;
    private final List commands;
    private boolean allowNonFastForwards;
    private PersonIdent refLogIdent;
    private String refLogMessage;
    private boolean refLogIncludeResult;
    private boolean forceRefLog;
    private PushCertificate pushCert;
    private boolean atomic;
    private List pushOptions;
    private List timestamps;

    protected BatchRefUpdate(RefDatabase refDatabase) {
        this.refdb = refDatabase;
        this.commands = new ArrayList();
        this.atomic = refDatabase.performsAtomicTransactions();
    }

    public boolean isAllowNonFastForwards() {
        return this.allowNonFastForwards;
    }

    public BatchRefUpdate setAllowNonFastForwards(boolean bl2) {
        this.allowNonFastForwards = bl2;
        return this;
    }

    public PersonIdent getRefLogIdent() {
        return this.refLogIdent;
    }

    public BatchRefUpdate setRefLogIdent(PersonIdent personIdent) {
        this.refLogIdent = personIdent;
        return this;
    }

    @Nullable
    public String getRefLogMessage() {
        return this.refLogMessage;
    }

    public boolean isRefLogIncludingResult() {
        return this.refLogIncludeResult;
    }

    public BatchRefUpdate setRefLogMessage(String string, boolean bl2) {
        if (string == null && !bl2) {
            this.disableRefLog();
        } else if (string == null && bl2) {
            this.refLogMessage = "";
            this.refLogIncludeResult = true;
        } else {
            this.refLogMessage = string;
            this.refLogIncludeResult = bl2;
        }
        return this;
    }

    public BatchRefUpdate disableRefLog() {
        this.refLogMessage = null;
        this.refLogIncludeResult = false;
        return this;
    }

    public BatchRefUpdate setForceRefLog(boolean bl2) {
        this.forceRefLog = bl2;
        return this;
    }

    public boolean isRefLogDisabled() {
        return this.refLogMessage == null;
    }

    protected boolean isForceRefLog() {
        return this.forceRefLog;
    }

    public BatchRefUpdate setAtomic(boolean bl2) {
        this.atomic = bl2;
        return this;
    }

    public boolean isAtomic() {
        return this.atomic;
    }

    public void setPushCertificate(PushCertificate pushCertificate) {
        this.pushCert = pushCertificate;
    }

    protected PushCertificate getPushCertificate() {
        return this.pushCert;
    }

    public List getCommands() {
        return Collections.unmodifiableList(this.commands);
    }

    public BatchRefUpdate addCommand(ReceiveCommand receiveCommand) {
        this.commands.add(receiveCommand);
        return this;
    }

    public BatchRefUpdate addCommand(ReceiveCommand ... receiveCommandArray) {
        return this.addCommand(Arrays.asList(receiveCommandArray));
    }

    public BatchRefUpdate addCommand(Collection collection) {
        this.commands.addAll(collection);
        return this;
    }

    @Nullable
    public List getPushOptions() {
        return this.pushOptions;
    }

    protected void setPushOptions(List list) {
        this.pushOptions = list;
    }

    public List getProposedTimestamps() {
        if (this.timestamps != null) {
            return Collections.unmodifiableList(this.timestamps);
        }
        return Collections.emptyList();
    }

    public BatchRefUpdate addProposedTimestamp(ProposedTimestamp proposedTimestamp) {
        if (this.timestamps == null) {
            this.timestamps = new ArrayList(4);
        }
        this.timestamps.add(proposedTimestamp);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void execute(RevWalk var1_1, ProgressMonitor var2_2, List var3_3) {
        if (this.atomic && !this.refdb.performsAtomicTransactions()) {
            for (ReceiveCommand var5_6 : this.commands) {
                if (var5_6.getResult() != ReceiveCommand$Result.NOT_ATTEMPTED) continue;
                var5_6.setResult(ReceiveCommand$Result.REJECTED_OTHER_REASON, JGitText.get().atomicRefUpdatesNotSupported);
            }
            return;
        }
        if (!this.blockUntilTimestamps(BatchRefUpdate.MAX_WAIT)) {
            return;
        }
        if (var3_3 != null) {
            this.setPushOptions(var3_3);
        }
        var2_2.beginTask(JGitText.get().updatingReferences, this.commands.size());
        var4_5 = new ArrayList<ReceiveCommand>(this.commands.size());
        for (ReceiveCommand var6_8 : this.commands) {
            try {
                if (var6_8.getResult() != ReceiveCommand$Result.NOT_ATTEMPTED) continue;
                if (BatchRefUpdate.isMissing(var1_1, var6_8.getOldId()) || BatchRefUpdate.isMissing(var1_1, var6_8.getNewId())) {
                    var6_8.setResult(ReceiveCommand$Result.REJECTED_MISSING_OBJECT);
                    continue;
                }
                var6_8.updateType(var1_1);
                switch (BatchRefUpdate$1.$SwitchMap$org$eclipse$jgit$transport$ReceiveCommand$Type[var6_8.getType().ordinal()]) {
                    case 1: {
                        var4_5.add(var6_8);
                        break;
                    }
                    case 2: 
                    case 3: {
                        var4_5.add(var6_8);
                        break;
                    }
                    case 4: {
                        var7_9 = this.newUpdate(var6_8);
                        var2_2.update(1);
                        var6_8.setResult(var7_9.delete(var1_1));
                    }
                }
            }
            catch (IOException var7_10) {
                var6_8.setResult(ReceiveCommand$Result.REJECTED_OTHER_REASON, MessageFormat.format(JGitText.get().lockError, new Object[]{var7_10.getMessage()}));
            }
        }
        if (!var4_5.isEmpty()) lbl-1000:
        // 8 sources

        {
            block19: for (ReceiveCommand var6_8 : var4_5) {
                try {
                    if (var6_8.getResult() != ReceiveCommand$Result.NOT_ATTEMPTED) continue;
                    var6_8.updateType(var1_1);
                    var7_9 = this.newUpdate(var6_8);
                    switch (BatchRefUpdate$1.$SwitchMap$org$eclipse$jgit$transport$ReceiveCommand$Type[var6_8.getType().ordinal()]) {
                        case 4: {
                            ** break;
                        }
                        case 2: 
                        case 3: {
                            var8_12 = this.newUpdate(var6_8);
                            var6_8.setResult(var8_12.update(var1_1));
                            ** break;
                        }
                        case 1: {
                            var6_8.setResult(var7_9.update(var1_1));
                            continue block19;
                        }
                        ** default:
lbl54:
                        // 1 sources

                        continue block19;
                    }
                }
                catch (IOException var7_11) {
                    var6_8.setResult(ReceiveCommand$Result.REJECTED_OTHER_REASON, MessageFormat.format(JGitText.get().lockError, new Object[]{var7_11.getMessage()}));
                }
                finally {
                    var2_2.update(1);
                }
            }
        }
        var2_2.endTask();
    }

    private static boolean isMissing(RevWalk revWalk, ObjectId objectId) {
        if (objectId.equals(ObjectId.zeroId())) {
            return false;
        }
        try {
            revWalk.parseAny(objectId);
            return false;
        }
        catch (MissingObjectException missingObjectException) {
            return true;
        }
    }

    protected boolean blockUntilTimestamps(Duration duration) {
        if (this.timestamps == null) {
            return true;
        }
        try {
            ProposedTimestamp.blockUntil(this.timestamps, duration);
            return true;
        }
        catch (InterruptedException | TimeoutException exception) {
            String string = JGitText.get().timeIsUncertain;
            for (ReceiveCommand receiveCommand : this.commands) {
                if (receiveCommand.getResult() != ReceiveCommand$Result.NOT_ATTEMPTED) continue;
                receiveCommand.setResult(ReceiveCommand$Result.REJECTED_OTHER_REASON, string);
            }
            return false;
        }
    }

    public void execute(RevWalk revWalk, ProgressMonitor progressMonitor) {
        this.execute(revWalk, progressMonitor, null);
    }

    protected static Collection getPrefixes(String string) {
        HashSet hashSet = new HashSet();
        BatchRefUpdate.addPrefixesTo(string, hashSet);
        return hashSet;
    }

    protected static void addPrefixesTo(String string, Collection collection) {
        int n2 = string.indexOf(47);
        while (n2 > 0) {
            collection.add(string.substring(0, n2));
            n2 = string.indexOf(47, n2 + 1);
        }
    }

    protected RefUpdate newUpdate(ReceiveCommand receiveCommand) {
        RefUpdate refUpdate = this.refdb.newUpdate(receiveCommand.getRefName(), false);
        if (this.isRefLogDisabled(receiveCommand)) {
            refUpdate.disableRefLog();
        } else {
            refUpdate.setRefLogIdent(this.refLogIdent);
            refUpdate.setRefLogMessage(this.getRefLogMessage(receiveCommand), this.isRefLogIncludingResult(receiveCommand));
            refUpdate.setForceRefLog(this.isForceRefLog(receiveCommand));
        }
        refUpdate.setPushCertificate(this.pushCert);
        switch (receiveCommand.getType()) {
            case DELETE: {
                if (!ObjectId.zeroId().equals(receiveCommand.getOldId())) {
                    refUpdate.setExpectedOldObjectId(receiveCommand.getOldId());
                }
                refUpdate.setForceUpdate(true);
                return refUpdate;
            }
        }
        refUpdate.setForceUpdate(this.isAllowNonFastForwards());
        refUpdate.setExpectedOldObjectId(receiveCommand.getOldId());
        refUpdate.setNewObjectId(receiveCommand.getNewId());
        return refUpdate;
    }

    protected boolean isRefLogDisabled(ReceiveCommand receiveCommand) {
        return receiveCommand.hasCustomRefLog() ? receiveCommand.isRefLogDisabled() : this.isRefLogDisabled();
    }

    protected String getRefLogMessage(ReceiveCommand receiveCommand) {
        return receiveCommand.hasCustomRefLog() ? receiveCommand.getRefLogMessage() : this.getRefLogMessage();
    }

    protected boolean isRefLogIncludingResult(ReceiveCommand receiveCommand) {
        return receiveCommand.hasCustomRefLog() ? receiveCommand.isRefLogIncludingResult() : this.isRefLogIncludingResult();
    }

    protected boolean isForceRefLog(ReceiveCommand receiveCommand) {
        Boolean bl2 = receiveCommand.isForceRefLog();
        return bl2 != null ? bl2.booleanValue() : this.isForceRefLog();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName()).append('[');
        if (this.commands.isEmpty()) {
            return stringBuilder.append(']').toString();
        }
        stringBuilder.append('\n');
        for (ReceiveCommand receiveCommand : this.commands) {
            stringBuilder.append("  ");
            stringBuilder.append(receiveCommand);
            stringBuilder.append("  (").append((Object)receiveCommand.getResult());
            if (receiveCommand.getMessage() != null) {
                stringBuilder.append(": ").append(receiveCommand.getMessage());
            }
            stringBuilder.append(")\n");
        }
        return stringBuilder.append(']').toString();
    }
}

