/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache$FileKey;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;

public class BaseRepositoryBuilder {
    private FS fs;
    private File gitDir;
    private File gitCommonDir;
    private File objectDirectory;
    private List alternateObjectDirectories;
    private File indexFile;
    private File workTree;
    private String initialBranch = "master";
    private List ceilingDirectories;
    private boolean bare;
    private boolean mustExist;
    private Config config;

    public BaseRepositoryBuilder setFS(FS fS) {
        this.fs = fS;
        return this.self();
    }

    public FS getFS() {
        return this.fs;
    }

    public BaseRepositoryBuilder setGitDir(File file) {
        this.gitDir = file;
        this.config = null;
        return this.self();
    }

    public File getGitDir() {
        return this.gitDir;
    }

    public BaseRepositoryBuilder setGitCommonDir(File file) {
        this.gitCommonDir = file;
        this.config = null;
        return this.self();
    }

    public File getGitCommonDir() {
        return this.gitCommonDir;
    }

    public BaseRepositoryBuilder setObjectDirectory(File file) {
        this.objectDirectory = file;
        return this.self();
    }

    public File getObjectDirectory() {
        return this.objectDirectory;
    }

    public BaseRepositoryBuilder addAlternateObjectDirectory(File file) {
        if (file != null) {
            if (this.alternateObjectDirectories == null) {
                this.alternateObjectDirectories = new LinkedList();
            }
            this.alternateObjectDirectories.add(file);
        }
        return this.self();
    }

    public BaseRepositoryBuilder addAlternateObjectDirectories(Collection collection) {
        if (collection != null) {
            for (File file : collection) {
                this.addAlternateObjectDirectory(file);
            }
        }
        return this.self();
    }

    public BaseRepositoryBuilder addAlternateObjectDirectories(File[] fileArray) {
        if (fileArray != null) {
            for (File file : fileArray) {
                this.addAlternateObjectDirectory(file);
            }
        }
        return this.self();
    }

    public File[] getAlternateObjectDirectories() {
        List list = this.alternateObjectDirectories;
        if (list == null) {
            return null;
        }
        return list.toArray(new File[0]);
    }

    public BaseRepositoryBuilder setBare() {
        this.setIndexFile(null);
        this.setWorkTree(null);
        this.bare = true;
        return this.self();
    }

    public boolean isBare() {
        return this.bare;
    }

    public BaseRepositoryBuilder setMustExist(boolean bl2) {
        this.mustExist = bl2;
        return this.self();
    }

    public boolean isMustExist() {
        return this.mustExist;
    }

    public BaseRepositoryBuilder setWorkTree(File file) {
        this.workTree = file;
        return this.self();
    }

    public File getWorkTree() {
        return this.workTree;
    }

    public BaseRepositoryBuilder setIndexFile(File file) {
        this.indexFile = file;
        return this.self();
    }

    public File getIndexFile() {
        return this.indexFile;
    }

    public BaseRepositoryBuilder setInitialBranch(String string) {
        if (StringUtils.isEmptyOrNull(string)) {
            this.initialBranch = "master";
        } else {
            if (!Repository.isValidRefName("refs/heads/" + string)) {
                throw new InvalidRefNameException(MessageFormat.format(JGitText.get().branchNameInvalid, string));
            }
            this.initialBranch = string;
        }
        return this.self();
    }

    @NonNull
    public String getInitialBranch() {
        return this.initialBranch;
    }

    public BaseRepositoryBuilder readEnvironment() {
        return this.readEnvironment(SystemReader.getInstance());
    }

    public BaseRepositoryBuilder readEnvironment(SystemReader systemReader) {
        String string;
        if (this.getGitDir() == null && (string = systemReader.getenv("GIT_DIR")) != null) {
            this.setGitDir(new File(string));
        }
        if (this.getGitCommonDir() == null && (string = systemReader.getenv("GIT_COMMON_DIR")) != null) {
            this.setGitCommonDir(new File(string));
        }
        if (this.getObjectDirectory() == null && (string = systemReader.getenv("GIT_OBJECT_DIRECTORY")) != null) {
            this.setObjectDirectory(new File(string));
        }
        if (this.getAlternateObjectDirectories() == null && (string = systemReader.getenv("GIT_ALTERNATE_OBJECT_DIRECTORIES")) != null) {
            for (String string2 : string.split(File.pathSeparator)) {
                this.addAlternateObjectDirectory(new File(string2));
            }
        }
        if (this.getWorkTree() == null && (string = systemReader.getenv("GIT_WORK_TREE")) != null) {
            this.setWorkTree(new File(string));
        }
        if (this.getIndexFile() == null && (string = systemReader.getenv("GIT_INDEX_FILE")) != null) {
            this.setIndexFile(new File(string));
        }
        if (this.ceilingDirectories == null && (string = systemReader.getenv("GIT_CEILING_DIRECTORIES")) != null) {
            for (String string2 : string.split(File.pathSeparator)) {
                this.addCeilingDirectory(new File(string2));
            }
        }
        return this.self();
    }

    public BaseRepositoryBuilder addCeilingDirectory(File file) {
        if (file != null) {
            if (this.ceilingDirectories == null) {
                this.ceilingDirectories = new LinkedList();
            }
            this.ceilingDirectories.add(file);
        }
        return this.self();
    }

    public BaseRepositoryBuilder addCeilingDirectories(Collection collection) {
        if (collection != null) {
            for (File file : collection) {
                this.addCeilingDirectory(file);
            }
        }
        return this.self();
    }

    public BaseRepositoryBuilder addCeilingDirectories(File[] fileArray) {
        if (fileArray != null) {
            for (File file : fileArray) {
                this.addCeilingDirectory(file);
            }
        }
        return this.self();
    }

    public BaseRepositoryBuilder findGitDir() {
        if (this.getGitDir() == null) {
            this.findGitDir(new File("").getAbsoluteFile());
        }
        return this.self();
    }

    public BaseRepositoryBuilder findGitDir(File file) {
        if (this.getGitDir() == null) {
            FS fS = this.safeFS();
            while (file != null) {
                File file2 = new File(file, ".git");
                if (RepositoryCache$FileKey.isGitRepository(file2, fS)) {
                    this.setGitDir(file2);
                    break;
                }
                if (file2.isFile()) {
                    try {
                        this.setGitDir(fS.getSymRef(file, file2));
                        break;
                    }
                    catch (IOException iOException) {
                    }
                } else if (RepositoryCache$FileKey.isGitRepository(file, fS)) {
                    this.setGitDir(file);
                    break;
                }
                if ((file = file.getParentFile()) == null || this.ceilingDirectories == null || !this.ceilingDirectories.contains(file)) continue;
                break;
            }
        }
        return this.self();
    }

    public BaseRepositoryBuilder setup() {
        this.requireGitDirOrWorkTree();
        this.setupGitDir();
        this.setupWorkTree();
        this.setupInternals();
        return this.self();
    }

    public Repository build() {
        FileRepository fileRepository = new FileRepository(this.setup());
        if (this.isMustExist() && !((Repository)fileRepository).getObjectDatabase().exists()) {
            throw new RepositoryNotFoundException(this.getGitDir());
        }
        return fileRepository;
    }

    protected void requireGitDirOrWorkTree() {
        if (this.getGitDir() == null && this.getWorkTree() == null) {
            throw new IllegalArgumentException(JGitText.get().eitherGitDirOrWorkTreeRequired);
        }
    }

    protected void setupGitDir() {
        if (this.getGitDir() == null && this.getWorkTree() != null) {
            File file = new File(this.getWorkTree(), ".git");
            if (!file.isFile()) {
                this.setGitDir(file);
            } else {
                this.setGitDir(this.safeFS().getSymRef(this.getWorkTree(), file));
            }
        }
        if (this.getGitCommonDir() == null) {
            this.setGitCommonDir(this.safeFS().getCommonDir(this.getGitDir()));
        }
    }

    protected void setupWorkTree() {
        if (this.getFS() == null) {
            this.setFS(FS.DETECTED);
        }
        if (!this.isBare() && this.getWorkTree() == null) {
            this.setWorkTree(this.guessWorkTreeOrFail());
        }
        if (!this.isBare()) {
            if (this.getGitDir() == null) {
                this.setGitDir(this.getWorkTree().getParentFile());
            }
            if (this.getIndexFile() == null) {
                this.setIndexFile(new File(this.getGitDir(), "index"));
            }
        }
    }

    protected void setupInternals() {
        File file;
        if (this.getObjectDirectory() == null && (file = this.getGitCommonDirFallback()) != null) {
            this.setObjectDirectory(this.safeFS().resolve(file, "objects"));
        }
    }

    protected Config getConfig() {
        if (this.config == null) {
            this.config = this.loadConfig();
        }
        return this.config;
    }

    protected Config loadConfig() {
        File file = this.getGitCommonDirFallback();
        if (file != null) {
            File file2 = this.safeFS().resolve(file, "config");
            FileBasedConfig fileBasedConfig = new FileBasedConfig(file2, this.safeFS());
            try {
                fileBasedConfig.load();
            }
            catch (ConfigInvalidException configInvalidException) {
                throw new IOException(MessageFormat.format(JGitText.get().repositoryConfigFileInvalid, file2.getAbsolutePath(), configInvalidException.getMessage()));
            }
            return fileBasedConfig;
        }
        return new Config();
    }

    protected File getGitCommonDirFallback() {
        return this.gitCommonDir != null ? this.gitCommonDir : this.gitDir;
    }

    private File guessWorkTreeOrFail() {
        Config config = this.getConfig();
        String string = config.getString("core", null, "worktree");
        if (string != null) {
            return this.safeFS().resolve(this.getGitDir(), string).getCanonicalFile();
        }
        File file = new File(this.getGitDir(), "gitdir");
        if (file.isFile()) {
            String string2 = new String(IO.readFully(file)).trim();
            File file2 = new File(string2);
            if (!file2.isAbsolute()) {
                file2 = new File(this.getGitDir(), string2).getCanonicalFile();
            }
            if (file2 != null) {
                return file2.getParentFile();
            }
        }
        if (config.getString("core", null, "bare") != null) {
            if (config.getBoolean("core", "bare", true)) {
                this.setBare();
                return null;
            }
            return this.getGitDir().getParentFile();
        }
        if (this.getGitDir().getName().equals(".git")) {
            return this.getGitDir().getParentFile();
        }
        this.setBare();
        return null;
    }

    protected FS safeFS() {
        return this.getFS() != null ? this.getFS() : FS.DETECTED;
    }

    protected final BaseRepositoryBuilder self() {
        return this;
    }
}

