/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.NB;
import org.eclipse.jgit.util.References;

public abstract class AnyObjectId
implements Comparable {
    int w1;
    int w2;
    int w3;
    int w4;
    int w5;
    private static final byte[] hexbyte = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static final char[] hexchar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    @Deprecated
    public static boolean equals(AnyObjectId anyObjectId, AnyObjectId anyObjectId2) {
        return AnyObjectId.isEqual(anyObjectId, anyObjectId2);
    }

    public static boolean isEqual(AnyObjectId anyObjectId, AnyObjectId anyObjectId2) {
        if (References.isSameObject(anyObjectId, anyObjectId2)) {
            return true;
        }
        return anyObjectId.w3 == anyObjectId2.w3 && anyObjectId.w4 == anyObjectId2.w4 && anyObjectId.w5 == anyObjectId2.w5 && anyObjectId.w1 == anyObjectId2.w1 && anyObjectId.w2 == anyObjectId2.w2;
    }

    public final int getFirstByte() {
        return this.w1 >>> 24;
    }

    public final int getByte(int n2) {
        int n3;
        switch (n2 >> 2) {
            case 0: {
                n3 = this.w1;
                break;
            }
            case 1: {
                n3 = this.w2;
                break;
            }
            case 2: {
                n3 = this.w3;
                break;
            }
            case 3: {
                n3 = this.w4;
                break;
            }
            case 4: {
                n3 = this.w5;
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(n2);
            }
        }
        return n3 >>> 8 * (3 - (n2 & 3)) & 0xFF;
    }

    public final int compareTo(AnyObjectId anyObjectId) {
        if (this == anyObjectId) {
            return 0;
        }
        int n2 = NB.compareUInt32(this.w1, anyObjectId.w1);
        if (n2 != 0) {
            return n2;
        }
        n2 = NB.compareUInt32(this.w2, anyObjectId.w2);
        if (n2 != 0) {
            return n2;
        }
        n2 = NB.compareUInt32(this.w3, anyObjectId.w3);
        if (n2 != 0) {
            return n2;
        }
        n2 = NB.compareUInt32(this.w4, anyObjectId.w4);
        if (n2 != 0) {
            return n2;
        }
        return NB.compareUInt32(this.w5, anyObjectId.w5);
    }

    public final int compareTo(byte[] byArray, int n2) {
        int n3 = NB.compareUInt32(this.w1, NB.decodeInt32(byArray, n2));
        if (n3 != 0) {
            return n3;
        }
        n3 = NB.compareUInt32(this.w2, NB.decodeInt32(byArray, n2 + 4));
        if (n3 != 0) {
            return n3;
        }
        n3 = NB.compareUInt32(this.w3, NB.decodeInt32(byArray, n2 + 8));
        if (n3 != 0) {
            return n3;
        }
        n3 = NB.compareUInt32(this.w4, NB.decodeInt32(byArray, n2 + 12));
        if (n3 != 0) {
            return n3;
        }
        return NB.compareUInt32(this.w5, NB.decodeInt32(byArray, n2 + 16));
    }

    public final int compareTo(int[] nArray, int n2) {
        int n3 = NB.compareUInt32(this.w1, nArray[n2]);
        if (n3 != 0) {
            return n3;
        }
        n3 = NB.compareUInt32(this.w2, nArray[n2 + 1]);
        if (n3 != 0) {
            return n3;
        }
        n3 = NB.compareUInt32(this.w3, nArray[n2 + 2]);
        if (n3 != 0) {
            return n3;
        }
        n3 = NB.compareUInt32(this.w4, nArray[n2 + 3]);
        if (n3 != 0) {
            return n3;
        }
        return NB.compareUInt32(this.w5, nArray[n2 + 4]);
    }

    public boolean startsWith(AbbreviatedObjectId abbreviatedObjectId) {
        return abbreviatedObjectId.prefixCompare(this) == 0;
    }

    public final int hashCode() {
        return this.w2;
    }

    public final boolean equals(AnyObjectId anyObjectId) {
        return anyObjectId != null ? AnyObjectId.isEqual(this, anyObjectId) : false;
    }

    public final boolean equals(Object object) {
        if (object instanceof AnyObjectId) {
            return this.equals((AnyObjectId)object);
        }
        return false;
    }

    public void copyRawTo(ByteBuffer byteBuffer) {
        byteBuffer.putInt(this.w1);
        byteBuffer.putInt(this.w2);
        byteBuffer.putInt(this.w3);
        byteBuffer.putInt(this.w4);
        byteBuffer.putInt(this.w5);
    }

    public void copyRawTo(byte[] byArray, int n2) {
        NB.encodeInt32(byArray, n2, this.w1);
        NB.encodeInt32(byArray, n2 + 4, this.w2);
        NB.encodeInt32(byArray, n2 + 8, this.w3);
        NB.encodeInt32(byArray, n2 + 12, this.w4);
        NB.encodeInt32(byArray, n2 + 16, this.w5);
    }

    public void copyRawTo(int[] nArray, int n2) {
        nArray[n2] = this.w1;
        nArray[n2 + 1] = this.w2;
        nArray[n2 + 2] = this.w3;
        nArray[n2 + 3] = this.w4;
        nArray[n2 + 4] = this.w5;
    }

    public void copyRawTo(OutputStream outputStream) {
        AnyObjectId.writeRawInt(outputStream, this.w1);
        AnyObjectId.writeRawInt(outputStream, this.w2);
        AnyObjectId.writeRawInt(outputStream, this.w3);
        AnyObjectId.writeRawInt(outputStream, this.w4);
        AnyObjectId.writeRawInt(outputStream, this.w5);
    }

    private static void writeRawInt(OutputStream outputStream, int n2) {
        outputStream.write(n2 >>> 24);
        outputStream.write(n2 >>> 16);
        outputStream.write(n2 >>> 8);
        outputStream.write(n2);
    }

    public void copyTo(OutputStream outputStream) {
        outputStream.write(this.toHexByteArray());
    }

    public void copyTo(byte[] byArray, int n2) {
        AnyObjectId.formatHexByte(byArray, n2 + 0, this.w1);
        AnyObjectId.formatHexByte(byArray, n2 + 8, this.w2);
        AnyObjectId.formatHexByte(byArray, n2 + 16, this.w3);
        AnyObjectId.formatHexByte(byArray, n2 + 24, this.w4);
        AnyObjectId.formatHexByte(byArray, n2 + 32, this.w5);
    }

    public void copyTo(ByteBuffer byteBuffer) {
        byteBuffer.put(this.toHexByteArray());
    }

    private byte[] toHexByteArray() {
        byte[] byArray = new byte[40];
        AnyObjectId.formatHexByte(byArray, 0, this.w1);
        AnyObjectId.formatHexByte(byArray, 8, this.w2);
        AnyObjectId.formatHexByte(byArray, 16, this.w3);
        AnyObjectId.formatHexByte(byArray, 24, this.w4);
        AnyObjectId.formatHexByte(byArray, 32, this.w5);
        return byArray;
    }

    private static void formatHexByte(byte[] byArray, int n2, int n3) {
        int n4 = n2 + 7;
        while (n4 >= n2 && n3 != 0) {
            byArray[n4--] = hexbyte[n3 & 0xF];
            n3 >>>= 4;
        }
        while (n4 >= n2) {
            byArray[n4--] = 48;
        }
    }

    public void copyTo(Writer writer) {
        writer.write(this.toHexCharArray());
    }

    public void copyTo(char[] cArray, Writer writer) {
        this.toHexCharArray(cArray);
        writer.write(cArray, 0, 40);
    }

    public void copyTo(char[] cArray, StringBuilder stringBuilder) {
        this.toHexCharArray(cArray);
        stringBuilder.append(cArray, 0, 40);
    }

    private char[] toHexCharArray() {
        char[] cArray = new char[40];
        this.toHexCharArray(cArray);
        return cArray;
    }

    private void toHexCharArray(char[] cArray) {
        AnyObjectId.formatHexChar(cArray, 0, this.w1);
        AnyObjectId.formatHexChar(cArray, 8, this.w2);
        AnyObjectId.formatHexChar(cArray, 16, this.w3);
        AnyObjectId.formatHexChar(cArray, 24, this.w4);
        AnyObjectId.formatHexChar(cArray, 32, this.w5);
    }

    static void formatHexChar(char[] cArray, int n2, int n3) {
        int n4 = n2 + 7;
        while (n4 >= n2 && n3 != 0) {
            cArray[n4--] = hexchar[n3 & 0xF];
            n3 >>>= 4;
        }
        while (n4 >= n2) {
            cArray[n4--] = 48;
        }
    }

    public String toString() {
        return "AnyObjectId[" + this.name() + "]";
    }

    public final String name() {
        return new String(this.toHexCharArray());
    }

    public final String getName() {
        return this.name();
    }

    public AbbreviatedObjectId abbreviate(int n2) {
        int n3 = AbbreviatedObjectId.mask(n2, 1, this.w1);
        int n4 = AbbreviatedObjectId.mask(n2, 2, this.w2);
        int n5 = AbbreviatedObjectId.mask(n2, 3, this.w3);
        int n6 = AbbreviatedObjectId.mask(n2, 4, this.w4);
        int n7 = AbbreviatedObjectId.mask(n2, 5, this.w5);
        return new AbbreviatedObjectId(n2, n3, n4, n5, n6, n7);
    }

    public final ObjectId copy() {
        if (this.getClass() == ObjectId.class) {
            return (ObjectId)this;
        }
        return new ObjectId(this);
    }

    public abstract ObjectId toObjectId();
}

