/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.Serializable;
import java.text.MessageFormat;
import org.eclipse.jgit.errors.InvalidObjectIdException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.NB;
import org.eclipse.jgit.util.RawParseUtils;

public final class AbbreviatedObjectId
implements Serializable {
    private static final long serialVersionUID = 1L;
    final int nibbles;
    final int w1;
    final int w2;
    final int w3;
    final int w4;
    final int w5;

    public static final boolean isId(String string) {
        if (string.length() < 2 || 40 < string.length()) {
            return false;
        }
        try {
            for (int i2 = 0; i2 < string.length(); ++i2) {
                RawParseUtils.parseHexInt4((byte)string.charAt(i2));
            }
            return true;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    public static final AbbreviatedObjectId fromString(byte[] byArray, int n2, int n3) {
        if (n3 - n2 > 40) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidIdLength, n3 - n2, 40));
        }
        return AbbreviatedObjectId.fromHexString(byArray, n2, n3);
    }

    public static final AbbreviatedObjectId fromObjectId(AnyObjectId anyObjectId) {
        return new AbbreviatedObjectId(40, anyObjectId.w1, anyObjectId.w2, anyObjectId.w3, anyObjectId.w4, anyObjectId.w5);
    }

    public static final AbbreviatedObjectId fromString(String string) {
        if (string.length() > 40) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidId, string));
        }
        byte[] byArray = Constants.encodeASCII(string);
        return AbbreviatedObjectId.fromHexString(byArray, 0, byArray.length);
    }

    private static final AbbreviatedObjectId fromHexString(byte[] byArray, int n2, int n3) {
        try {
            int n4 = AbbreviatedObjectId.hexUInt32(byArray, n2, n3);
            int n5 = AbbreviatedObjectId.hexUInt32(byArray, n2 + 8, n3);
            int n6 = AbbreviatedObjectId.hexUInt32(byArray, n2 + 16, n3);
            int n7 = AbbreviatedObjectId.hexUInt32(byArray, n2 + 24, n3);
            int n8 = AbbreviatedObjectId.hexUInt32(byArray, n2 + 32, n3);
            return new AbbreviatedObjectId(n3 - n2, n4, n5, n6, n7, n8);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            InvalidObjectIdException invalidObjectIdException = new InvalidObjectIdException(byArray, n2, n3 - n2);
            invalidObjectIdException.initCause(arrayIndexOutOfBoundsException);
            throw invalidObjectIdException;
        }
    }

    private static final int hexUInt32(byte[] byArray, int n2, int n3) {
        int n4;
        if (8 <= n3 - n2) {
            return RawParseUtils.parseHexInt32(byArray, n2);
        }
        int n5 = 0;
        for (n4 = 0; n4 < 8 && n2 < n3; ++n4) {
            n5 <<= 4;
            n5 |= RawParseUtils.parseHexInt4(byArray[n2++]);
        }
        return n5 << (8 - n4) * 4;
    }

    static int mask(int n2, int n3, int n4) {
        int n5 = (n3 - 1) * 8;
        if (n5 + 8 <= n2) {
            return n4;
        }
        if (n2 <= n5) {
            return 0;
        }
        int n6 = 32 - (n2 - n5) * 4;
        return n4 >>> n6 << n6;
    }

    AbbreviatedObjectId(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.nibbles = n2;
        this.w1 = n3;
        this.w2 = n4;
        this.w3 = n5;
        this.w4 = n6;
        this.w5 = n7;
    }

    public int length() {
        return this.nibbles;
    }

    public boolean isComplete() {
        return this.length() == 40;
    }

    public ObjectId toObjectId() {
        return this.isComplete() ? new ObjectId(this.w1, this.w2, this.w3, this.w4, this.w5) : null;
    }

    public final int prefixCompare(AnyObjectId anyObjectId) {
        int n2 = NB.compareUInt32(this.w1, this.mask(1, anyObjectId.w1));
        if (n2 != 0) {
            return n2;
        }
        n2 = NB.compareUInt32(this.w2, this.mask(2, anyObjectId.w2));
        if (n2 != 0) {
            return n2;
        }
        n2 = NB.compareUInt32(this.w3, this.mask(3, anyObjectId.w3));
        if (n2 != 0) {
            return n2;
        }
        n2 = NB.compareUInt32(this.w4, this.mask(4, anyObjectId.w4));
        if (n2 != 0) {
            return n2;
        }
        return NB.compareUInt32(this.w5, this.mask(5, anyObjectId.w5));
    }

    public final int prefixCompare(byte[] byArray, int n2) {
        int n3 = NB.compareUInt32(this.w1, this.mask(1, NB.decodeInt32(byArray, n2)));
        if (n3 != 0) {
            return n3;
        }
        n3 = NB.compareUInt32(this.w2, this.mask(2, NB.decodeInt32(byArray, n2 + 4)));
        if (n3 != 0) {
            return n3;
        }
        n3 = NB.compareUInt32(this.w3, this.mask(3, NB.decodeInt32(byArray, n2 + 8)));
        if (n3 != 0) {
            return n3;
        }
        n3 = NB.compareUInt32(this.w4, this.mask(4, NB.decodeInt32(byArray, n2 + 12)));
        if (n3 != 0) {
            return n3;
        }
        return NB.compareUInt32(this.w5, this.mask(5, NB.decodeInt32(byArray, n2 + 16)));
    }

    public final int prefixCompare(int[] nArray, int n2) {
        int n3 = NB.compareUInt32(this.w1, this.mask(1, nArray[n2]));
        if (n3 != 0) {
            return n3;
        }
        n3 = NB.compareUInt32(this.w2, this.mask(2, nArray[n2 + 1]));
        if (n3 != 0) {
            return n3;
        }
        n3 = NB.compareUInt32(this.w3, this.mask(3, nArray[n2 + 2]));
        if (n3 != 0) {
            return n3;
        }
        n3 = NB.compareUInt32(this.w4, this.mask(4, nArray[n2 + 3]));
        if (n3 != 0) {
            return n3;
        }
        return NB.compareUInt32(this.w5, this.mask(5, nArray[n2 + 4]));
    }

    public final int getFirstByte() {
        return this.w1 >>> 24;
    }

    private int mask(int n2, int n3) {
        return AbbreviatedObjectId.mask(this.nibbles, n2, n3);
    }

    public int hashCode() {
        return this.w1;
    }

    public boolean equals(Object object) {
        if (object instanceof AbbreviatedObjectId) {
            AbbreviatedObjectId abbreviatedObjectId = (AbbreviatedObjectId)object;
            return this.nibbles == abbreviatedObjectId.nibbles && this.w1 == abbreviatedObjectId.w1 && this.w2 == abbreviatedObjectId.w2 && this.w3 == abbreviatedObjectId.w3 && this.w4 == abbreviatedObjectId.w4 && this.w5 == abbreviatedObjectId.w5;
        }
        return false;
    }

    public final String name() {
        char[] cArray = new char[40];
        AnyObjectId.formatHexChar(cArray, 0, this.w1);
        if (this.nibbles <= 8) {
            return new String(cArray, 0, this.nibbles);
        }
        AnyObjectId.formatHexChar(cArray, 8, this.w2);
        if (this.nibbles <= 16) {
            return new String(cArray, 0, this.nibbles);
        }
        AnyObjectId.formatHexChar(cArray, 16, this.w3);
        if (this.nibbles <= 24) {
            return new String(cArray, 0, this.nibbles);
        }
        AnyObjectId.formatHexChar(cArray, 24, this.w4);
        if (this.nibbles <= 32) {
            return new String(cArray, 0, this.nibbles);
        }
        AnyObjectId.formatHexChar(cArray, 32, this.w5);
        return new String(cArray, 0, this.nibbles);
    }

    public String toString() {
        return "AbbreviatedObjectId[" + this.name() + "]";
    }
}

