/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.ssh;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.fnmatch.FileNameMatcher;
import org.eclipse.jgit.internal.transport.ssh.OpenSshConfigFile$HostEntry;
import org.eclipse.jgit.internal.transport.ssh.OpenSshConfigFile$State;
import org.eclipse.jgit.transport.SshConfigStore;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.StringUtils;

public class OpenSshConfigFile
implements SshConfigStore {
    private final File home;
    private final File configFile;
    private final String localUserName;
    private Instant lastModified;
    private OpenSshConfigFile$State state;

    public OpenSshConfigFile(@NonNull File file, @NonNull File file2, @NonNull String string) {
        this.home = file;
        this.configFile = file2;
        this.localUserName = string;
        this.state = new OpenSshConfigFile$State();
    }

    @Override
    @NonNull
    public OpenSshConfigFile$HostEntry lookup(@NonNull String string, int n2, String string2) {
        OpenSshConfigFile$State openSshConfigFile$State = this.refresh();
        String string3 = this.toCacheKey(string, n2, string2);
        OpenSshConfigFile$HostEntry openSshConfigFile$HostEntry = (OpenSshConfigFile$HostEntry)openSshConfigFile$State.hosts.get(string3);
        if (openSshConfigFile$HostEntry != null) {
            return openSshConfigFile$HostEntry;
        }
        OpenSshConfigFile$HostEntry openSshConfigFile$HostEntry3 = new OpenSshConfigFile$HostEntry();
        Iterator<OpenSshConfigFile$HostEntry> iterator = openSshConfigFile$State.entries.iterator();
        if (iterator.hasNext()) {
            openSshConfigFile$HostEntry3.merge((OpenSshConfigFile$HostEntry)iterator.next());
            iterator.forEachRemaining(openSshConfigFile$HostEntry2 -> {
                if (openSshConfigFile$HostEntry2.matches(string)) {
                    openSshConfigFile$HostEntry3.merge((OpenSshConfigFile$HostEntry)openSshConfigFile$HostEntry2);
                }
            });
        }
        openSshConfigFile$HostEntry3.substitute(string, n2, string2, this.localUserName, this.home);
        openSshConfigFile$State.hosts.put(string3, openSshConfigFile$HostEntry3);
        return openSshConfigFile$HostEntry3;
    }

    @NonNull
    private String toCacheKey(@NonNull String string, int n2, String string2) {
        String string3 = string;
        if (n2 > 0) {
            string3 = string3 + ':' + Integer.toString(n2);
        }
        if (string2 != null && !string2.isEmpty()) {
            string3 = string2 + '@' + string3;
        }
        return string3;
    }

    private synchronized OpenSshConfigFile$State refresh() {
        Instant instant = FS.DETECTED.lastModifiedInstant(this.configFile);
        if (!instant.equals(this.lastModified)) {
            OpenSshConfigFile$State openSshConfigFile$State = new OpenSshConfigFile$State();
            try (BufferedReader bufferedReader = Files.newBufferedReader(this.configFile.toPath(), StandardCharsets.UTF_8);){
                openSshConfigFile$State.entries = this.parse(bufferedReader);
            }
            catch (IOException | RuntimeException exception) {
                // empty catch block
            }
            this.lastModified = instant;
            this.state = openSshConfigFile$State;
        }
        return this.state;
    }

    private List parse(BufferedReader bufferedReader) {
        String string;
        OpenSshConfigFile$HostEntry openSshConfigFile$HostEntry;
        LinkedList<OpenSshConfigFile$HostEntry> linkedList = new LinkedList<OpenSshConfigFile$HostEntry>();
        OpenSshConfigFile$HostEntry openSshConfigFile$HostEntry2 = openSshConfigFile$HostEntry = new OpenSshConfigFile$HostEntry();
        linkedList.add(openSshConfigFile$HostEntry);
        while ((string = bufferedReader.readLine()) != null) {
            String string2;
            int n2 = string.indexOf(35);
            if (n2 >= 0) {
                string = string.substring(0, n2);
            }
            if ((string = string.trim()).isEmpty()) continue;
            String[] stringArray = string.split("[ \t]*[= \t]", 2);
            String string3 = OpenSshConfigFile.dequote(stringArray[0].trim());
            String string4 = string2 = stringArray.length > 1 ? stringArray[1].trim() : "";
            if (StringUtils.equalsIgnoreCase("Host", string3)) {
                openSshConfigFile$HostEntry2 = new OpenSshConfigFile$HostEntry(this.parseList(string2));
                linkedList.add(openSshConfigFile$HostEntry2);
                continue;
            }
            if (OpenSshConfigFile$HostEntry.isListKey(string3)) {
                List list = this.validate(string3, this.parseList(string2));
                openSshConfigFile$HostEntry2.setValue(string3, list);
                continue;
            }
            if (string2.isEmpty()) continue;
            string2 = this.validate(string3, OpenSshConfigFile.dequote(string2));
            openSshConfigFile$HostEntry2.setValue(string3, string2);
        }
        return linkedList;
    }

    private List parseList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(4);
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            int n4;
            if (Character.isWhitespace(string.charAt(n2))) {
                ++n2;
                continue;
            }
            if (string.charAt(n2) == '\"') {
                if ((n4 = string.indexOf(34, ++n2)) < n2) break;
                arrayList.add(string.substring(n2, n4));
                n2 = n4 + 1;
                continue;
            }
            for (n4 = n2 + 1; n4 < n3 && !Character.isWhitespace(string.charAt(n4)); ++n4) {
            }
            arrayList.add(string.substring(n2, n4));
            n2 = n4 + 1;
        }
        return arrayList;
    }

    protected String validate(String string, String string2) {
        if (String.CASE_INSENSITIVE_ORDER.compare(string, "PreferredAuthentications") == 0) {
            return OpenSshConfigFile.stripWhitespace(string2);
        }
        return string2;
    }

    protected List validate(String string, List list) {
        return list;
    }

    private static boolean patternMatchesHost(String string, String string2) {
        if (string.indexOf(42) >= 0 || string.indexOf(63) >= 0) {
            FileNameMatcher fileNameMatcher;
            try {
                fileNameMatcher = new FileNameMatcher(string, null);
            }
            catch (InvalidPatternException invalidPatternException) {
                return false;
            }
            fileNameMatcher.append(string2);
            return fileNameMatcher.isMatch();
        }
        return string.equals(string2);
    }

    private static String dequote(String string) {
        if (string.startsWith("\"") && string.endsWith("\"") && string.length() > 1) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    private static String stripWhitespace(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (Character.isWhitespace(c2)) continue;
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    private static File toFile(String string, File file) {
        if (string.startsWith("~/") || string.startsWith("~" + File.separator)) {
            return new File(file, string.substring(2));
        }
        File file2 = new File(string);
        if (file2.isAbsolute()) {
            return file2;
        }
        return new File(file, string);
    }

    public static int positive(String string) {
        if (string != null) {
            try {
                return Integer.parseUnsignedInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static boolean flag(String string) {
        if (string == null) {
            return false;
        }
        return "yes".equals(string) || "on".equals(string) || "true".equals(string);
    }

    public String getLocalUserName() {
        return this.localUserName;
    }

    public String toString() {
        return "OpenSshConfig [home=" + this.home + ", configFile=" + this.configFile + ", lastModified=" + this.lastModified + ", state=" + this.state + "]";
    }

    static /* synthetic */ boolean access$100(String string, String string2) {
        return OpenSshConfigFile.patternMatchesHost(string, string2);
    }

    static /* synthetic */ File access$200(String string, File file) {
        return OpenSshConfigFile.toFile(string, file);
    }
}

