/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.ssh;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.internal.transport.ssh.OpenSshConfigFile;
import org.eclipse.jgit.internal.transport.ssh.OpenSshConfigFile$Replacer;
import org.eclipse.jgit.transport.SshConfigStore$HostConfig;

public class OpenSshConfigFile$HostEntry
implements SshConfigStore$HostConfig {
    private static final Set MULTI_KEYS = new TreeSet(String.CASE_INSENSITIVE_ORDER);
    private static final Set LIST_KEYS;
    private static final Map ALIASES;
    private Map options;
    private Map multiOptions;
    private Map listOptions;
    private final List patterns;

    public OpenSshConfigFile$HostEntry() {
        this.patterns = Collections.emptyList();
    }

    public OpenSshConfigFile$HostEntry(List list) {
        this.patterns = list;
    }

    boolean matches(String string) {
        boolean bl2 = false;
        for (String string2 : this.patterns) {
            if (string2.startsWith("!")) {
                if (!OpenSshConfigFile.access$100(string2.substring(1), string)) continue;
                return false;
            }
            if (bl2 || !OpenSshConfigFile.access$100(string2, string)) continue;
            bl2 = true;
        }
        return bl2;
    }

    private static String toKey(String string) {
        String string2 = (String)ALIASES.get(string);
        return string2 != null ? string2 : string;
    }

    @Override
    public String getValue(String string) {
        String string2;
        String string3 = OpenSshConfigFile$HostEntry.toKey(string);
        String string4 = string2 = this.options != null ? (String)this.options.get(string3) : null;
        if (string2 == null) {
            List list;
            List list2 = list = this.listOptions != null ? (List)this.listOptions.get(string3) : null;
            if (list == null) {
                List list3 = list = this.multiOptions != null ? (List)this.multiOptions.get(string3) : null;
            }
            if (list != null && !list.isEmpty()) {
                string2 = (String)list.get(0);
            }
        }
        return string2;
    }

    @Override
    public List getValues(String string) {
        List list;
        String string2 = OpenSshConfigFile$HostEntry.toKey(string);
        List list2 = list = this.listOptions != null ? (List)this.listOptions.get(string2) : null;
        if (list == null) {
            List list3 = list = this.multiOptions != null ? (List)this.multiOptions.get(string2) : null;
        }
        if (list == null || list.isEmpty()) {
            return new ArrayList();
        }
        return new ArrayList(list);
    }

    public void setValue(String string, String string2) {
        String string3 = OpenSshConfigFile$HostEntry.toKey(string);
        if (string2 == null) {
            if (this.multiOptions != null) {
                this.multiOptions.remove(string3);
            }
            if (this.listOptions != null) {
                this.listOptions.remove(string3);
            }
            if (this.options != null) {
                this.options.remove(string3);
            }
            return;
        }
        if (MULTI_KEYS.contains(string3)) {
            ArrayList<String> arrayList;
            if (this.multiOptions == null) {
                this.multiOptions = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            }
            if ((arrayList = (ArrayList<String>)this.multiOptions.get(string3)) == null) {
                arrayList = new ArrayList<String>(4);
                this.multiOptions.put(string3, arrayList);
            }
            arrayList.add(string2);
        } else {
            if (this.options == null) {
                this.options = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            }
            if (!this.options.containsKey(string3)) {
                this.options.put(string3, string2);
            }
        }
    }

    public void setValue(String string, List list) {
        if (list.isEmpty()) {
            return;
        }
        String string2 = OpenSshConfigFile$HostEntry.toKey(string);
        if (MULTI_KEYS.contains(string2)) {
            ArrayList arrayList;
            if (this.multiOptions == null) {
                this.multiOptions = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            }
            if ((arrayList = (ArrayList)this.multiOptions.get(string2)) == null) {
                arrayList = new ArrayList(list);
                this.multiOptions.put(string2, arrayList);
            } else {
                arrayList.addAll(list);
            }
        } else {
            if (this.listOptions == null) {
                this.listOptions = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            }
            if (!this.listOptions.containsKey(string2)) {
                this.listOptions.put(string2, list);
            }
        }
    }

    public static boolean isListKey(String string) {
        return LIST_KEYS.contains(OpenSshConfigFile$HostEntry.toKey(string));
    }

    void merge(OpenSshConfigFile$HostEntry openSshConfigFile$HostEntry) {
        if (openSshConfigFile$HostEntry == null) {
            return;
        }
        if (openSshConfigFile$HostEntry.options != null) {
            if (this.options == null) {
                this.options = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            }
            for (Map.Entry entry : openSshConfigFile$HostEntry.options.entrySet()) {
                if (this.options.containsKey(entry.getKey())) continue;
                this.options.put(entry.getKey(), entry.getValue());
            }
        }
        if (openSshConfigFile$HostEntry.listOptions != null) {
            if (this.listOptions == null) {
                this.listOptions = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            }
            for (Map.Entry entry : openSshConfigFile$HostEntry.listOptions.entrySet()) {
                if (this.listOptions.containsKey(entry.getKey())) continue;
                this.listOptions.put(entry.getKey(), entry.getValue());
            }
        }
        if (openSshConfigFile$HostEntry.multiOptions != null) {
            if (this.multiOptions == null) {
                this.multiOptions = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            }
            for (Map.Entry entry : openSshConfigFile$HostEntry.multiOptions.entrySet()) {
                ArrayList arrayList = (ArrayList)this.multiOptions.get(entry.getKey());
                if (arrayList == null) {
                    arrayList = new ArrayList((Collection)entry.getValue());
                    this.multiOptions.put(entry.getKey(), arrayList);
                    continue;
                }
                arrayList.addAll((Collection)entry.getValue());
            }
        }
    }

    private List substitute(List list, String string, OpenSshConfigFile$Replacer openSshConfigFile$Replacer, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (String string2 : list) {
            arrayList.add(openSshConfigFile$Replacer.substitute(string2, string, bl2));
        }
        return arrayList;
    }

    private List replaceTilde(List list, File file) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (String string : list) {
            arrayList.add(OpenSshConfigFile.access$200(string, file).getPath());
        }
        return arrayList;
    }

    void substitute(String string, int n2, String string2, String string3, File file) {
        Object object;
        String string4;
        int n3;
        int n4 = n3 = n2 >= 0 ? n2 : OpenSshConfigFile.positive(this.getValue("Port"));
        if (n3 < 0) {
            n3 = 22;
        }
        String string5 = string4 = string2 != null && !string2.isEmpty() ? string2 : this.getValue("User");
        if (string4 == null || string4.isEmpty()) {
            string4 = string3;
        }
        OpenSshConfigFile$Replacer openSshConfigFile$Replacer = new OpenSshConfigFile$Replacer(string, n3, string4, string3, file);
        if (this.options != null) {
            object = (String)this.options.get("HostName");
            if (object == null || ((String)object).isEmpty()) {
                this.options.put("HostName", string);
            } else {
                object = openSshConfigFile$Replacer.substitute((String)object, "h", false);
                this.options.put("HostName", object);
                openSshConfigFile$Replacer.update('h', (String)object);
            }
        }
        if (this.multiOptions != null) {
            object = (List)this.multiOptions.get("IdentityFile");
            if (object != null) {
                object = this.substitute((List)object, "dhlru", openSshConfigFile$Replacer, true);
                object = this.replaceTilde((List)object, file);
                this.multiOptions.put("IdentityFile", object);
            }
            if ((object = (List)this.multiOptions.get("CertificateFile")) != null) {
                object = this.substitute((List)object, "dhlru", openSshConfigFile$Replacer, true);
                object = this.replaceTilde((List)object, file);
                this.multiOptions.put("CertificateFile", object);
            }
        }
        if (this.listOptions != null && (object = (List)this.listOptions.get("UserKnownHostsFile")) != null) {
            object = this.replaceTilde((List)object, file);
            this.listOptions.put("UserKnownHostsFile", object);
        }
        if (this.options != null) {
            object = (String)this.options.get("IdentityAgent");
            if (object != null) {
                object = openSshConfigFile$Replacer.substitute((String)object, "dhlru", true);
                object = OpenSshConfigFile.access$200((String)object, file).getPath();
                this.options.put("IdentityAgent", object);
            }
            if ((object = (String)this.options.get("ControlPath")) != null) {
                object = openSshConfigFile$Replacer.substitute((String)object, "ChLlnpru", true);
                object = OpenSshConfigFile.access$200((String)object, file).getPath();
                this.options.put("ControlPath", object);
            }
            if ((object = (String)this.options.get("LocalCommand")) != null) {
                object = openSshConfigFile$Replacer.substitute((String)object, "CdhlnprTu", false);
                this.options.put("LocalCommand", object);
            }
            if ((object = (String)this.options.get("RemoteCommand")) != null) {
                object = openSshConfigFile$Replacer.substitute((String)object, "Cdhlnpru", false);
                this.options.put("RemoteCommand", object);
            }
            if ((object = (String)this.options.get("ProxyCommand")) != null) {
                object = openSshConfigFile$Replacer.substitute((String)object, "hpr", false);
                this.options.put("ProxyCommand", object);
            }
        }
    }

    @Override
    @NonNull
    public Map getOptions() {
        if (this.options == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.options);
    }

    @Override
    @NonNull
    public Map getMultiValuedOptions() {
        if (this.listOptions == null && this.multiOptions == null) {
            return Collections.emptyMap();
        }
        TreeMap treeMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        if (this.multiOptions != null) {
            treeMap.putAll(this.multiOptions);
        }
        if (this.listOptions != null) {
            treeMap.putAll(this.listOptions);
        }
        return Collections.unmodifiableMap(treeMap);
    }

    public String toString() {
        return "HostEntry [options=" + this.options + ", multiOptions=" + this.multiOptions + ", listOptions=" + this.listOptions + "]";
    }

    static {
        MULTI_KEYS.add("CertificateFile");
        MULTI_KEYS.add("IdentityFile");
        MULTI_KEYS.add("LocalForward");
        MULTI_KEYS.add("RemoteForward");
        MULTI_KEYS.add("SendEnv");
        LIST_KEYS = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        LIST_KEYS.add("CanonicalDomains");
        LIST_KEYS.add("GlobalKnownHostsFile");
        LIST_KEYS.add("SendEnv");
        LIST_KEYS.add("UserKnownHostsFile");
        ALIASES = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        ALIASES.put("PubkeyAcceptedKeyTypes", "PubkeyAcceptedAlgorithms");
    }
}

