/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.http;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.net.HttpCookie;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.FileSnapshot;
import org.eclipse.jgit.internal.storage.file.LockFile;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetscapeCookieFile {
    private static final String HTTP_ONLY_PREAMBLE = "#HttpOnly_";
    private static final String COLUMN_SEPARATOR = "\t";
    private static final String LINE_SEPARATOR = "\n";
    private static final int LOCK_ACQUIRE_MAX_RETRY_COUNT = 4;
    private static final int LOCK_ACQUIRE_RETRY_SLEEP = 500;
    private final Path path;
    private FileSnapshot snapshot;
    private byte[] hash;
    private final Instant createdAt;
    private Set cookies = null;
    private static final Logger LOG = LoggerFactory.getLogger(NetscapeCookieFile.class);

    public NetscapeCookieFile(Path path) {
        this(path, Instant.now());
    }

    NetscapeCookieFile(Path path, Instant instant) {
        this.path = path;
        this.snapshot = FileSnapshot.DIRTY;
        this.createdAt = instant;
    }

    public Path getPath() {
        return this.path;
    }

    public Set getCookies(boolean bl2) {
        block3: {
            if (this.cookies == null || bl2) {
                try {
                    byte[] byArray = this.getFileContentIfModified();
                    Set set = NetscapeCookieFile.parseCookieFile(byArray, this.createdAt);
                    this.cookies = this.cookies != null ? NetscapeCookieFile.mergeCookies(set, this.cookies) : set;
                    return this.cookies;
                }
                catch (IOException | IllegalArgumentException exception) {
                    LOG.warn(MessageFormat.format(JGitText.get().couldNotReadCookieFile, this.path), (Throwable)exception);
                    if (this.cookies != null) break block3;
                    this.cookies = new LinkedHashSet();
                }
            }
        }
        return this.cookies;
    }

    private static Set parseCookieFile(@NonNull byte[] byArray, @NonNull Instant instant) {
        String string = RawParseUtils.decode(StandardCharsets.US_ASCII, byArray);
        LinkedHashSet<HttpCookie> linkedHashSet = new LinkedHashSet<HttpCookie>();
        try (BufferedReader bufferedReader = new BufferedReader(new StringReader(string));){
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                HttpCookie httpCookie = NetscapeCookieFile.parseLine(string2, instant);
                if (httpCookie == null) continue;
                linkedHashSet.add(httpCookie);
            }
        }
        return linkedHashSet;
    }

    private static HttpCookie parseLine(@NonNull String string, @NonNull Instant instant) {
        long l2;
        if (string.isEmpty() || string.startsWith("#") && !string.startsWith(HTTP_ONLY_PREAMBLE)) {
            return null;
        }
        String[] stringArray = string.split(COLUMN_SEPARATOR, 7);
        if (stringArray == null) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().couldNotFindTabInLine, string));
        }
        if (stringArray.length < 7) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().couldNotFindSixTabsInLine, stringArray.length, string));
        }
        String string2 = stringArray[5];
        String string3 = stringArray[6];
        HttpCookie httpCookie = new HttpCookie(string2, string3);
        String string4 = stringArray[0];
        if (string4.startsWith(HTTP_ONLY_PREAMBLE)) {
            httpCookie.setHttpOnly(true);
            string4 = string4.substring(HTTP_ONLY_PREAMBLE.length());
        }
        if (string4.startsWith(".")) {
            string4 = string4.substring(1);
        }
        httpCookie.setDomain(string4);
        httpCookie.setPath(stringArray[2]);
        httpCookie.setSecure(Boolean.parseBoolean(stringArray[3]));
        long l3 = Long.parseLong(stringArray[4]);
        if (stringArray[4].length() == 13) {
            l3 = TimeUnit.MILLISECONDS.toSeconds(l3);
        }
        if ((l2 = l3 - instant.getEpochSecond()) <= 0L) {
            return null;
        }
        httpCookie.setMaxAge(l2);
        return httpCookie;
    }

    private byte[] getFileContentIfModified() {
        int n2 = 5;
        int n3 = 0;
        File file = this.getPath().toFile();
        if (!file.exists()) {
            LOG.warn(MessageFormat.format(JGitText.get().missingCookieFile, file.getAbsolutePath()));
            return new byte[0];
        }
        while (true) {
            FileSnapshot fileSnapshot = this.snapshot;
            FileSnapshot fileSnapshot2 = FileSnapshot.save(file, FS.DETECTED);
            try {
                byte[] byArray = IO.readFully(file);
                byte[] byArray2 = NetscapeCookieFile.hash(byArray);
                if (Arrays.equals(this.hash, byArray2)) {
                    if (fileSnapshot.equals(fileSnapshot2)) {
                        fileSnapshot.setClean(fileSnapshot2);
                    } else {
                        this.snapshot = fileSnapshot2;
                    }
                } else {
                    this.snapshot = fileSnapshot2;
                    this.hash = byArray2;
                }
                return byArray;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw fileNotFoundException;
            }
            catch (IOException iOException) {
                if (FileUtils.isStaleFileHandle(iOException) && n3 < 5) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(MessageFormat.format(JGitText.get().configHandleIsStale, n3), (Throwable)iOException);
                    }
                    ++n3;
                    continue;
                }
                throw new IOException(MessageFormat.format(JGitText.get().cannotReadFile, this.getPath()), iOException);
            }
            break;
        }
    }

    private static byte[] hash(byte[] byArray) {
        return Constants.newMessageDigest().digest(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(URL uRL) {
        Object object;
        Object object2;
        try {
            object2 = this.getFileContentIfModified();
            if (object2 != null) {
                LOG.debug("Reading the underlying cookie file '{}' as it has been modified since the last access", (Object)this.path);
                object = NetscapeCookieFile.parseCookieFile((byte[])object2, this.createdAt);
                this.cookies = NetscapeCookieFile.mergeCookies((Set)object, this.cookies);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        object2 = new ByteArrayOutputStream();
        object = new OutputStreamWriter((OutputStream)object2, StandardCharsets.US_ASCII);
        Throwable throwable = null;
        try {
            NetscapeCookieFile.write((Writer)object, this.cookies, uRL, this.createdAt);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (object != null) {
                if (throwable != null) {
                    try {
                        ((Writer)object).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    ((Writer)object).close();
                }
            }
        }
        object = new LockFile(this.path.toFile());
        for (int i2 = 0; i2 < 4; ++i2) {
            if (((LockFile)object).lock()) {
                try {
                    ((LockFile)object).setNeedSnapshot(true);
                    ((LockFile)object).write(((ByteArrayOutputStream)object2).toByteArray());
                    if (!((LockFile)object).commit()) {
                        throw new IOException(MessageFormat.format(JGitText.get().cannotCommitWriteTo, this.path));
                    }
                }
                finally {
                    ((LockFile)object).unlock();
                }
                return;
            }
            Thread.sleep(500L);
        }
        throw new IOException(MessageFormat.format(JGitText.get().cannotLock, object));
    }

    static void write(@NonNull Writer writer, @NonNull Collection collection, @NonNull URL uRL, @NonNull Instant instant) {
        for (HttpCookie httpCookie : collection) {
            NetscapeCookieFile.writeCookie(writer, httpCookie, uRL, instant);
        }
    }

    private static void writeCookie(@NonNull Writer writer, @NonNull HttpCookie httpCookie, @NonNull URL uRL, @NonNull Instant instant) {
        if (httpCookie.getMaxAge() <= 0L) {
            return;
        }
        String string = "";
        if (httpCookie.isHttpOnly()) {
            string = HTTP_ONLY_PREAMBLE;
        }
        string = httpCookie.getDomain() != null ? string + httpCookie.getDomain() : string + uRL.getHost();
        writer.write(string);
        writer.write(COLUMN_SEPARATOR);
        writer.write("TRUE");
        writer.write(COLUMN_SEPARATOR);
        String string2 = httpCookie.getPath();
        if (string2 == null) {
            string2 = uRL.getPath();
        }
        writer.write(string2);
        writer.write(COLUMN_SEPARATOR);
        writer.write(Boolean.toString(httpCookie.getSecure()).toUpperCase());
        writer.write(COLUMN_SEPARATOR);
        String string3 = String.valueOf(instant.getEpochSecond() + httpCookie.getMaxAge());
        writer.write(string3);
        writer.write(COLUMN_SEPARATOR);
        writer.write(httpCookie.getName());
        writer.write(COLUMN_SEPARATOR);
        writer.write(httpCookie.getValue());
        writer.write(LINE_SEPARATOR);
    }

    static Set mergeCookies(Set set, @Nullable Set set2) {
        LinkedHashSet linkedHashSet = new LinkedHashSet(set);
        if (set2 != null) {
            linkedHashSet.addAll(set2);
        }
        return linkedHashSet;
    }
}

