/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.connectivity;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ConnectivityChecker;
import org.eclipse.jgit.transport.ConnectivityChecker$ConnectivityCheckInfo;
import org.eclipse.jgit.transport.ReceiveCommand$Type;

public class IterativeConnectivityChecker
implements ConnectivityChecker {
    private static final int MAXIMUM_PARENTS_TO_CHECK = 128;
    private final ConnectivityChecker delegate;
    private Set forcedHaves = Collections.emptySet();

    public IterativeConnectivityChecker(ConnectivityChecker connectivityChecker) {
        this.delegate = connectivityChecker;
    }

    @Override
    public void checkConnectivity(ConnectivityChecker$ConnectivityCheckInfo connectivityChecker$ConnectivityCheckInfo, Set set, ProgressMonitor progressMonitor) {
        try {
            HashSet hashSet = new HashSet();
            HashSet hashSet2 = new HashSet();
            IterativeConnectivityChecker.getAllObjectIds(connectivityChecker$ConnectivityCheckInfo.getCommands()).forEach(objectId -> {
                if (set.contains(objectId)) {
                    hashSet2.add(objectId);
                } else {
                    hashSet.add(objectId);
                }
            });
            if (!hashSet.isEmpty()) {
                hashSet2.addAll(IterativeConnectivityChecker.extractAdvertisedParentCommits(hashSet, set, connectivityChecker$ConnectivityCheckInfo.getWalk()));
            }
            hashSet2.addAll(this.forcedHaves);
            if (!hashSet2.isEmpty()) {
                this.delegate.checkConnectivity(connectivityChecker$ConnectivityCheckInfo, hashSet2, progressMonitor);
                return;
            }
        }
        catch (MissingObjectException missingObjectException) {
            // empty catch block
        }
        this.delegate.checkConnectivity(connectivityChecker$ConnectivityCheckInfo, set, progressMonitor);
    }

    private static Stream getAllObjectIds(List list) {
        return list.stream().flatMap(receiveCommand -> {
            if (receiveCommand.getType() == ReceiveCommand$Type.UPDATE || receiveCommand.getType() == ReceiveCommand$Type.UPDATE_NONFASTFORWARD) {
                return Stream.of(receiveCommand.getOldId(), receiveCommand.getNewId());
            }
            if (receiveCommand.getType() == ReceiveCommand$Type.CREATE) {
                return Stream.of(receiveCommand.getNewId());
            }
            return Stream.of(new ObjectId[0]);
        });
    }

    public void setForcedHaves(Set set) {
        this.forcedHaves = Collections.unmodifiableSet(set);
    }

    private static Set extractAdvertisedParentCommits(Set set, Set set2, RevWalk revWalk) {
        HashSet<ObjectId> hashSet = new HashSet<ObjectId>();
        for (ObjectId objectId : set) {
            RevObject revObject = revWalk.parseAny(objectId);
            if (!(revObject instanceof RevCommit)) continue;
            int n2 = 0;
            ArrayDeque arrayDeque = new ArrayDeque(128);
            arrayDeque.addAll(IterativeConnectivityChecker.parseParents(((RevCommit)revObject).getParents(), revWalk));
            while (!arrayDeque.isEmpty()) {
                RevCommit revCommit = (RevCommit)arrayDeque.poll();
                if (set2.contains(revCommit.getId())) {
                    hashSet.add(revCommit.getId());
                    continue;
                }
                if (n2 >= 128) continue;
                RevCommit[] revCommitArray = revCommit.getParents();
                n2 += revCommitArray.length;
                arrayDeque.addAll(IterativeConnectivityChecker.parseParents(revCommitArray, revWalk));
            }
        }
        return hashSet;
    }

    private static List parseParents(RevCommit[] revCommitArray, RevWalk revWalk) {
        return Arrays.stream(revCommitArray).map(revCommit -> {
            try {
                return revWalk.parseCommit((AnyObjectId)revCommit);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }).collect(Collectors.toList());
    }
}

