/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.connectivity;

import java.util.Set;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdSubclassMap;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevBlob;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.transport.ConnectivityChecker;
import org.eclipse.jgit.transport.ConnectivityChecker$ConnectivityCheckInfo;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.ReceiveCommand$Result;
import org.eclipse.jgit.transport.ReceiveCommand$Type;

public final class FullConnectivityChecker
implements ConnectivityChecker {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkConnectivity(ConnectivityChecker$ConnectivityCheckInfo connectivityChecker$ConnectivityCheckInfo, Set set, ProgressMonitor progressMonitor) {
        progressMonitor.beginTask(JGitText.get().countingObjects, 0);
        try (ObjectWalk objectWalk = new ObjectWalk(connectivityChecker$ConnectivityCheckInfo.getRepository());){
            if (!this.markStartAndKnownNodes(connectivityChecker$ConnectivityCheckInfo, objectWalk, set, progressMonitor)) {
                return;
            }
            this.checkCommitTree(connectivityChecker$ConnectivityCheckInfo, objectWalk, progressMonitor);
            this.checkObjects(connectivityChecker$ConnectivityCheckInfo, objectWalk, progressMonitor);
        }
        finally {
            progressMonitor.endTask();
        }
    }

    private boolean markStartAndKnownNodes(ConnectivityChecker$ConnectivityCheckInfo connectivityChecker$ConnectivityCheckInfo, ObjectWalk objectWalk, Set set, ProgressMonitor progressMonitor) {
        boolean bl2;
        boolean bl3 = bl2 = connectivityChecker$ConnectivityCheckInfo.isCheckObjects() && !connectivityChecker$ConnectivityCheckInfo.getParser().getBaseObjectIds().isEmpty();
        if (connectivityChecker$ConnectivityCheckInfo.isCheckObjects()) {
            objectWalk.sort(RevSort.TOPO);
            if (!connectivityChecker$ConnectivityCheckInfo.getParser().getBaseObjectIds().isEmpty()) {
                objectWalk.sort(RevSort.BOUNDARY, true);
            }
        }
        boolean bl4 = false;
        for (Object object : connectivityChecker$ConnectivityCheckInfo.getCommands()) {
            if (((ReceiveCommand)object).getResult() != ReceiveCommand$Result.NOT_ATTEMPTED || ((ReceiveCommand)object).getType() == ReceiveCommand$Type.DELETE || set.contains(((ReceiveCommand)object).getNewId())) continue;
            objectWalk.markStart(objectWalk.parseAny(((ReceiveCommand)object).getNewId()));
            progressMonitor.update(1);
            bl4 = true;
        }
        if (!bl4) {
            return false;
        }
        for (Object object : set) {
            RevObject revObject = objectWalk.parseAny((AnyObjectId)object);
            objectWalk.markUninteresting(revObject);
            progressMonitor.update(1);
            if (!bl2) continue;
            if ((revObject = objectWalk.peel(revObject)) instanceof RevCommit) {
                revObject = ((RevCommit)revObject).getTree();
            }
            if (!(revObject instanceof RevTree)) continue;
            objectWalk.markUninteresting(revObject);
        }
        return true;
    }

    private void checkCommitTree(ConnectivityChecker$ConnectivityCheckInfo connectivityChecker$ConnectivityCheckInfo, ObjectWalk objectWalk, ProgressMonitor progressMonitor) {
        RevCommit revCommit;
        ObjectIdSubclassMap objectIdSubclassMap = connectivityChecker$ConnectivityCheckInfo.getParser().getNewObjectIds();
        while ((revCommit = objectWalk.next()) != null) {
            progressMonitor.update(1);
            if (!connectivityChecker$ConnectivityCheckInfo.isCheckObjects() || revCommit.has(RevFlag.UNINTERESTING) || objectIdSubclassMap.contains(revCommit)) continue;
            throw new MissingObjectException((ObjectId)revCommit, "commit");
        }
    }

    private void checkObjects(ConnectivityChecker$ConnectivityCheckInfo connectivityChecker$ConnectivityCheckInfo, ObjectWalk objectWalk, ProgressMonitor progressMonitor) {
        RevObject revObject;
        ObjectIdSubclassMap objectIdSubclassMap = connectivityChecker$ConnectivityCheckInfo.getParser().getNewObjectIds();
        while ((revObject = objectWalk.nextObject()) != null) {
            progressMonitor.update(1);
            if (revObject.has(RevFlag.UNINTERESTING)) continue;
            if (connectivityChecker$ConnectivityCheckInfo.isCheckObjects()) {
                if (objectIdSubclassMap.contains(revObject)) continue;
                throw new MissingObjectException((ObjectId)revObject, revObject.getType());
            }
            if (!(revObject instanceof RevBlob) || connectivityChecker$ConnectivityCheckInfo.getRepository().getObjectDatabase().has(revObject)) continue;
            throw new MissingObjectException((ObjectId)revObject, "blob");
        }
        if (connectivityChecker$ConnectivityCheckInfo.isCheckObjects()) {
            for (ObjectId objectId : connectivityChecker$ConnectivityCheckInfo.getParser().getBaseObjectIds()) {
                revObject = objectWalk.parseAny(objectId);
                if (revObject.has(RevFlag.UNINTERESTING)) continue;
                throw new MissingObjectException((ObjectId)revObject, revObject.getType());
            }
        }
    }
}

