/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.submodule;

import java.text.MessageFormat;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.submodule.SubmoduleValidator$SubmoduleValidationException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectChecker$ErrorType;

public class SubmoduleValidator {
    public static void assertValidSubmoduleName(String string) {
        if (string.contains("/../") || string.contains("\\..\\") || string.startsWith("../") || string.startsWith("..\\") || string.endsWith("/..") || string.endsWith("\\..")) {
            throw new SubmoduleValidator$SubmoduleValidationException(MessageFormat.format(JGitText.get().invalidNameContainsDotDot, string), ObjectChecker$ErrorType.GITMODULES_NAME);
        }
        if (string.startsWith("-")) {
            throw new SubmoduleValidator$SubmoduleValidationException(MessageFormat.format(JGitText.get().submoduleNameInvalid, string), ObjectChecker$ErrorType.GITMODULES_NAME);
        }
    }

    public static void assertValidSubmoduleUri(String string) {
        if (string.startsWith("-")) {
            throw new SubmoduleValidator$SubmoduleValidationException(MessageFormat.format(JGitText.get().submoduleUrlInvalid, string), ObjectChecker$ErrorType.GITMODULES_URL);
        }
    }

    public static void assertValidSubmodulePath(String string) {
        if (string.startsWith("-")) {
            throw new SubmoduleValidator$SubmoduleValidationException(MessageFormat.format(JGitText.get().submodulePathInvalid, string), ObjectChecker$ErrorType.GITMODULES_PATH);
        }
    }

    public static void assertValidGitModulesFile(String string) {
        Config config = new Config();
        try {
            config.fromText(string);
            for (String string2 : config.getSubsections("submodule")) {
                String string3;
                SubmoduleValidator.assertValidSubmoduleName(string2);
                String string4 = config.getString("submodule", string2, "url");
                if (string4 != null) {
                    SubmoduleValidator.assertValidSubmoduleUri(string4);
                }
                if ((string3 = config.getString("submodule", string2, "path")) == null) continue;
                SubmoduleValidator.assertValidSubmodulePath(string3);
            }
        }
        catch (ConfigInvalidException configInvalidException) {
            SubmoduleValidator$SubmoduleValidationException submoduleValidator$SubmoduleValidationException = new SubmoduleValidator$SubmoduleValidationException(JGitText.get().invalidGitModules, ObjectChecker$ErrorType.GITMODULES_PARSE);
            submoduleValidator$SubmoduleValidationException.initCause(configInvalidException);
            throw submoduleValidator$SubmoduleValidationException;
        }
    }
}

