/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.reftable;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.reftable.BlockWriter;
import org.eclipse.jgit.internal.storage.reftable.BlockWriter$DeleteLogEntry;
import org.eclipse.jgit.internal.storage.reftable.BlockWriter$Entry;
import org.eclipse.jgit.internal.storage.reftable.BlockWriter$LogEntry;
import org.eclipse.jgit.internal.storage.reftable.BlockWriter$ObjEntry;
import org.eclipse.jgit.internal.storage.reftable.BlockWriter$RefEntry;
import org.eclipse.jgit.internal.storage.reftable.ReftableConfig;
import org.eclipse.jgit.internal.storage.reftable.ReftableConstants;
import org.eclipse.jgit.internal.storage.reftable.ReftableOutputStream;
import org.eclipse.jgit.internal.storage.reftable.ReftableWriter$IndexBuilder;
import org.eclipse.jgit.internal.storage.reftable.ReftableWriter$RefList;
import org.eclipse.jgit.internal.storage.reftable.ReftableWriter$Section;
import org.eclipse.jgit.internal.storage.reftable.ReftableWriter$Stats;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdSubclassMap;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.util.NB;

public class ReftableWriter {
    private ReftableConfig config;
    private int refBlockSize;
    private int logBlockSize;
    private int restartInterval;
    private int maxIndexLevels;
    private boolean alignBlocks;
    private boolean indexObjects;
    private long minUpdateIndex;
    private long maxUpdateIndex;
    private OutputStream outputStream;
    private ReftableOutputStream out;
    private ObjectIdSubclassMap obj2ref;
    private BlockWriter$Entry lastRef;
    private BlockWriter$Entry lastLog;
    private BlockWriter cur;
    private ReftableWriter$Section refs;
    private ReftableWriter$Section objs;
    private ReftableWriter$Section logs;
    private int objIdLen;
    private ReftableWriter$Stats stats;

    public ReftableWriter(OutputStream outputStream) {
        this(new ReftableConfig(), outputStream);
        this.lastRef = null;
        this.lastLog = null;
    }

    public ReftableWriter(ReftableConfig reftableConfig, OutputStream outputStream) {
        this.config = reftableConfig;
        this.outputStream = outputStream;
    }

    public ReftableWriter setConfig(ReftableConfig reftableConfig) {
        this.config = reftableConfig != null ? reftableConfig : new ReftableConfig();
        return this;
    }

    public ReftableWriter setMinUpdateIndex(long l2) {
        this.minUpdateIndex = l2;
        return this;
    }

    public ReftableWriter setMaxUpdateIndex(long l2) {
        this.maxUpdateIndex = l2;
        return this;
    }

    public ReftableWriter begin() {
        if (this.out != null) {
            throw new IllegalStateException("begin() called twice.");
        }
        this.refBlockSize = this.config.getRefBlockSize();
        this.logBlockSize = this.config.getLogBlockSize();
        this.restartInterval = this.config.getRestartInterval();
        this.maxIndexLevels = this.config.getMaxIndexLevels();
        this.alignBlocks = this.config.isAlignBlocks();
        this.indexObjects = this.config.isIndexObjects();
        if (this.refBlockSize <= 0) {
            this.refBlockSize = 4096;
        } else if (this.refBlockSize > 0xFFFFFF) {
            throw new IllegalArgumentException();
        }
        if (this.logBlockSize <= 0) {
            this.logBlockSize = 2 * this.refBlockSize;
        }
        if (this.restartInterval <= 0) {
            this.restartInterval = this.refBlockSize < 61440 ? 16 : 64;
        }
        this.out = new ReftableOutputStream(this.outputStream, this.refBlockSize, this.alignBlocks);
        this.refs = new ReftableWriter$Section(this, 114);
        if (this.indexObjects) {
            this.obj2ref = new ObjectIdSubclassMap();
        }
        this.writeFileHeader();
        return this;
    }

    public ReftableWriter sortAndWriteRefs(Collection collection) {
        Iterator iterator = collection.stream().map(ref -> new BlockWriter$RefEntry((Ref)ref, this.maxUpdateIndex - this.minUpdateIndex)).sorted(BlockWriter$Entry::compare).iterator();
        BlockWriter$RefEntry blockWriter$RefEntry = null;
        while (iterator.hasNext()) {
            BlockWriter$RefEntry blockWriter$RefEntry2 = (BlockWriter$RefEntry)iterator.next();
            if (blockWriter$RefEntry != null && BlockWriter$Entry.compare(blockWriter$RefEntry, blockWriter$RefEntry2) == 0) {
                this.throwIllegalEntry(blockWriter$RefEntry, blockWriter$RefEntry2);
            }
            long l2 = this.refs.write(blockWriter$RefEntry2);
            this.indexRef(blockWriter$RefEntry2.ref, l2);
            blockWriter$RefEntry = blockWriter$RefEntry2;
        }
        return this;
    }

    public void writeRef(Ref ref) {
        this.writeRef(ref, this.maxUpdateIndex);
    }

    public void writeRef(Ref ref, long l2) {
        if (l2 < this.minUpdateIndex) {
            throw new IllegalArgumentException();
        }
        long l3 = l2 - this.minUpdateIndex;
        BlockWriter$RefEntry blockWriter$RefEntry = new BlockWriter$RefEntry(ref, l3);
        if (this.lastRef != null && BlockWriter$Entry.compare(this.lastRef, blockWriter$RefEntry) >= 0) {
            this.throwIllegalEntry(this.lastRef, blockWriter$RefEntry);
        }
        this.lastRef = blockWriter$RefEntry;
        long l4 = this.refs.write(blockWriter$RefEntry);
        this.indexRef(ref, l4);
    }

    private void throwIllegalEntry(BlockWriter$Entry blockWriter$Entry, BlockWriter$Entry blockWriter$Entry2) {
        throw new IllegalArgumentException(MessageFormat.format(JGitText.get().reftableRecordsMustIncrease, new String(blockWriter$Entry.key, StandardCharsets.UTF_8), new String(blockWriter$Entry2.key, StandardCharsets.UTF_8)));
    }

    private void indexRef(Ref ref, long l2) {
        if (this.indexObjects && !ref.isSymbolic()) {
            this.indexId(ref.getObjectId(), l2);
            this.indexId(ref.getPeeledObjectId(), l2);
        }
    }

    private void indexId(ObjectId objectId, long l2) {
        if (objectId != null) {
            ReftableWriter$RefList reftableWriter$RefList = (ReftableWriter$RefList)this.obj2ref.get(objectId);
            if (reftableWriter$RefList == null) {
                reftableWriter$RefList = new ReftableWriter$RefList(objectId);
                this.obj2ref.add(reftableWriter$RefList);
            }
            reftableWriter$RefList.addBlock(l2);
        }
    }

    public void writeLog(String string, long l2, PersonIdent personIdent, ObjectId objectId, ObjectId objectId2, @Nullable String string2) {
        String string3 = string2 != null ? string2 : "";
        this.beginLog();
        BlockWriter$LogEntry blockWriter$LogEntry = new BlockWriter$LogEntry(string, l2, personIdent, objectId, objectId2, string3);
        if (this.lastLog != null && BlockWriter$Entry.compare(this.lastLog, blockWriter$LogEntry) >= 0) {
            this.throwIllegalEntry(this.lastLog, blockWriter$LogEntry);
        }
        this.lastLog = blockWriter$LogEntry;
        this.logs.write(blockWriter$LogEntry);
    }

    public void deleteLog(String string, long l2) {
        this.beginLog();
        this.logs.write(new BlockWriter$DeleteLogEntry(string, l2));
    }

    private void beginLog() {
        if (this.logs == null) {
            this.finishRefAndObjSections();
            this.out.flushFileHeader();
            this.out.setBlockSize(this.logBlockSize);
            this.logs = new ReftableWriter$Section(this, 103);
        }
    }

    public long estimateTotalBytes() {
        long l2 = this.out.size();
        if (l2 == 0L) {
            l2 += 24L;
        }
        if (this.cur != null) {
            long l3 = this.out.size();
            int n2 = this.cur.currentSize();
            l2 += (long)n2;
            ReftableWriter$IndexBuilder reftableWriter$IndexBuilder = null;
            if (this.cur.blockType() == 114) {
                reftableWriter$IndexBuilder = this.refs.idx;
            } else if (this.cur.blockType() == 103) {
                reftableWriter$IndexBuilder = this.logs.idx;
            }
            if (reftableWriter$IndexBuilder != null && this.shouldHaveIndex(reftableWriter$IndexBuilder)) {
                if (reftableWriter$IndexBuilder == this.refs.idx) {
                    l2 += (long)this.out.estimatePadBetweenBlocks(n2);
                }
                l2 += (long)reftableWriter$IndexBuilder.estimateBytes(l3);
            }
        }
        return l2 += 68L;
    }

    public ReftableWriter finish() {
        this.finishRefAndObjSections();
        this.finishLogSection();
        this.writeFileFooter();
        this.out.finishFile();
        this.stats = new ReftableWriter$Stats(this, this.out);
        this.out = null;
        this.obj2ref = null;
        this.cur = null;
        this.refs = null;
        this.objs = null;
        this.logs = null;
        return this;
    }

    private void finishRefAndObjSections() {
        if (this.cur != null && this.cur.blockType() == 114) {
            this.refs.finishSectionMaybeWriteIndex();
            if (this.indexObjects && !this.obj2ref.isEmpty() && this.refs.idx.bytes > 0) {
                this.writeObjBlocks();
            }
            this.obj2ref = null;
        }
    }

    private void writeObjBlocks() {
        List list = ReftableWriter.sortById(this.obj2ref);
        this.obj2ref = null;
        this.objIdLen = ReftableWriter.shortestUniqueAbbreviation(list);
        this.out.padBetweenBlocksToNextBlock();
        this.objs = new ReftableWriter$Section(this, 111);
        this.objs.entryCnt = list.size();
        for (ReftableWriter$RefList reftableWriter$RefList : list) {
            this.objs.write(new BlockWriter$ObjEntry(this.objIdLen, reftableWriter$RefList, reftableWriter$RefList.blockPos));
        }
        this.objs.finishSectionMaybeWriteIndex();
    }

    private void finishLogSection() {
        if (this.cur != null && this.cur.blockType() == 103) {
            this.logs.finishSectionMaybeWriteIndex();
        }
    }

    private boolean shouldHaveIndex(ReftableWriter$IndexBuilder reftableWriter$IndexBuilder) {
        int n2 = reftableWriter$IndexBuilder == this.refs.idx && this.alignBlocks ? 4 : 1;
        return reftableWriter$IndexBuilder.entries.size() + (this.cur != null ? 1 : 0) > n2;
    }

    private void writeFileHeader() {
        byte[] byArray = new byte[24];
        this.encodeHeader(byArray);
        this.out.write(byArray, 0, 24);
    }

    private void encodeHeader(byte[] byArray) {
        System.arraycopy(ReftableConstants.FILE_HEADER_MAGIC, 0, byArray, 0, 4);
        int n2 = this.alignBlocks ? this.refBlockSize : 0;
        NB.encodeInt32(byArray, 4, 0x1000000 | n2);
        NB.encodeInt64(byArray, 8, this.minUpdateIndex);
        NB.encodeInt64(byArray, 16, this.maxUpdateIndex);
    }

    private void writeFileFooter() {
        int n2 = 68;
        byte[] byArray = new byte[n2];
        this.encodeHeader(byArray);
        NB.encodeInt64(byArray, 24, ReftableWriter.indexPosition(this.refs));
        NB.encodeInt64(byArray, 32, ReftableWriter.firstBlockPosition(this.objs) << 5 | (long)this.objIdLen);
        NB.encodeInt64(byArray, 40, ReftableWriter.indexPosition(this.objs));
        NB.encodeInt64(byArray, 48, ReftableWriter.firstBlockPosition(this.logs));
        NB.encodeInt64(byArray, 56, ReftableWriter.indexPosition(this.logs));
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray, 0, n2 - 4);
        NB.encodeInt32(byArray, n2 - 4, (int)cRC32.getValue());
        this.out.write(byArray, 0, n2);
    }

    private static long firstBlockPosition(@Nullable ReftableWriter$Section reftableWriter$Section) {
        return reftableWriter$Section != null ? reftableWriter$Section.firstBlockPosition : 0L;
    }

    private static long indexPosition(@Nullable ReftableWriter$Section reftableWriter$Section) {
        return reftableWriter$Section != null && reftableWriter$Section.idx != null ? reftableWriter$Section.idx.rootPosition : 0L;
    }

    public ReftableWriter$Stats getStats() {
        return this.stats;
    }

    private static List sortById(ObjectIdSubclassMap objectIdSubclassMap) {
        ArrayList<ReftableWriter$RefList> arrayList = new ArrayList<ReftableWriter$RefList>(objectIdSubclassMap.size());
        for (ReftableWriter$RefList reftableWriter$RefList : objectIdSubclassMap) {
            arrayList.add(reftableWriter$RefList);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private static int shortestUniqueAbbreviation(List list) {
        int n2 = Math.max(2, (int)(Math.log(list.size()) / Math.log(8.0)));
        HashSet<AbbreviatedObjectId> hashSet = new HashSet<AbbreviatedObjectId>((int)((float)list.size() * 0.75f));
        block0: while (true) {
            int n3 = n2 * 2;
            for (ObjectId objectId : list) {
                AbbreviatedObjectId abbreviatedObjectId = objectId.abbreviate(n3);
                if (hashSet.add(abbreviatedObjectId)) continue;
                if (++n2 >= 20) {
                    return 20;
                }
                hashSet.clear();
                continue block0;
            }
            break;
        }
        return n2;
    }

    static /* synthetic */ int access$000(ReftableWriter reftableWriter) {
        return reftableWriter.refBlockSize;
    }

    static /* synthetic */ int access$100(ReftableWriter reftableWriter) {
        return reftableWriter.logBlockSize;
    }

    static /* synthetic */ int access$200(ReftableWriter reftableWriter) {
        return reftableWriter.restartInterval;
    }

    static /* synthetic */ long access$300(ReftableWriter reftableWriter) {
        return reftableWriter.minUpdateIndex;
    }

    static /* synthetic */ long access$400(ReftableWriter reftableWriter) {
        return reftableWriter.maxUpdateIndex;
    }

    static /* synthetic */ ReftableWriter$Section access$500(ReftableWriter reftableWriter) {
        return reftableWriter.refs;
    }

    static /* synthetic */ ReftableWriter$Section access$600(ReftableWriter reftableWriter) {
        return reftableWriter.objs;
    }

    static /* synthetic */ int access$700(ReftableWriter reftableWriter) {
        return reftableWriter.objIdLen;
    }

    static /* synthetic */ ReftableWriter$Section access$800(ReftableWriter reftableWriter) {
        return reftableWriter.logs;
    }

    static /* synthetic */ ReftableOutputStream access$900(ReftableWriter reftableWriter) {
        return reftableWriter.out;
    }

    static /* synthetic */ BlockWriter access$1000(ReftableWriter reftableWriter) {
        return reftableWriter.cur;
    }

    static /* synthetic */ BlockWriter access$1002(ReftableWriter reftableWriter, BlockWriter blockWriter) {
        reftableWriter.cur = blockWriter;
        return reftableWriter.cur;
    }

    static /* synthetic */ boolean access$1100(ReftableWriter reftableWriter, ReftableWriter$IndexBuilder indexBuilder) {
        return reftableWriter.shouldHaveIndex(indexBuilder);
    }

    static /* synthetic */ int access$1200(ReftableWriter reftableWriter) {
        return reftableWriter.maxIndexLevels;
    }
}

