/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.reftable;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.eclipse.jgit.internal.storage.reftable.LogCursor;
import org.eclipse.jgit.internal.storage.reftable.Reftable;
import org.eclipse.jgit.lib.ReflogEntry;
import org.eclipse.jgit.lib.ReflogReader;

public class ReftableReflogReader
implements ReflogReader {
    private final Lock lock;
    private final Reftable reftable;
    private final String refname;

    ReftableReflogReader(Lock lock, Reftable reftable, String string) {
        this.lock = lock;
        this.reftable = reftable;
        this.refname = string;
    }

    @Override
    public ReflogEntry getLastEntry() {
        this.lock.lock();
        try {
            LogCursor logCursor = this.reftable.seekLog(this.refname);
            ReflogEntry reflogEntry = logCursor.next() ? logCursor.getReflogEntry() : null;
            return reflogEntry;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List getReverseEntries() {
        return this.getReverseEntries(Integer.MAX_VALUE);
    }

    @Override
    public ReflogEntry getReverseEntry(int n2) {
        this.lock.lock();
        try {
            LogCursor logCursor = this.reftable.seekLog(this.refname);
            while (true) {
                if (!logCursor.next() || n2 < 0) {
                    ReflogEntry reflogEntry = null;
                    return reflogEntry;
                }
                if (n2 == 0) {
                    ReflogEntry reflogEntry = logCursor.getReflogEntry();
                    return reflogEntry;
                }
                --n2;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getReverseEntries(int n2) {
        this.lock.lock();
        try {
            LogCursor logCursor = this.reftable.seekLog(this.refname);
            ArrayList<ReflogEntry> arrayList = new ArrayList<ReflogEntry>();
            while (logCursor.next() && arrayList.size() < n2) {
                arrayList.add(logCursor.getReflogEntry());
            }
            ArrayList<ReflogEntry> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            this.lock.unlock();
        }
    }
}

