/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.reftable;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.zip.CRC32;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.io.BlockSource;
import org.eclipse.jgit.internal.storage.reftable.BlockReader;
import org.eclipse.jgit.internal.storage.reftable.BlockWriter$LogEntry;
import org.eclipse.jgit.internal.storage.reftable.EmptyLogCursor;
import org.eclipse.jgit.internal.storage.reftable.LogCursor;
import org.eclipse.jgit.internal.storage.reftable.RefCursor;
import org.eclipse.jgit.internal.storage.reftable.Reftable;
import org.eclipse.jgit.internal.storage.reftable.ReftableConstants;
import org.eclipse.jgit.internal.storage.reftable.ReftableReader$LogCursorImpl;
import org.eclipse.jgit.internal.storage.reftable.ReftableReader$ObjCursorImpl;
import org.eclipse.jgit.internal.storage.reftable.ReftableReader$RefCursorImpl;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.util.LongList;
import org.eclipse.jgit.util.LongMap;
import org.eclipse.jgit.util.NB;

public class ReftableReader
extends Reftable
implements AutoCloseable {
    private final BlockSource src;
    private int blockSize = -1;
    private long minUpdateIndex;
    private long maxUpdateIndex;
    private long refEnd;
    private long objPosition;
    private long objEnd;
    private long logPosition;
    private long logEnd;
    private int objIdLen;
    private long refIndexPosition = -1L;
    private long objIndexPosition = -1L;
    private long logIndexPosition = -1L;
    private BlockReader refIndex;
    private BlockReader objIndex;
    private BlockReader logIndex;
    private LongMap indexCache;
    static final LongList EMPTY_LONG_LIST = new LongList(0);

    public ReftableReader(BlockSource blockSource) {
        this.src = blockSource;
    }

    public int blockSize() {
        if (this.blockSize == -1) {
            this.readFileHeader();
        }
        return this.blockSize;
    }

    @Override
    public boolean hasObjectMap() {
        if (this.objIndexPosition == -1L) {
            this.readFileFooter();
        }
        return this.objPosition > 0L || this.refEnd == 24L || this.refIndexPosition == 0L;
    }

    @Override
    public long minUpdateIndex() {
        if (this.blockSize == -1) {
            this.readFileHeader();
        }
        return this.minUpdateIndex;
    }

    @Override
    public long maxUpdateIndex() {
        if (this.blockSize == -1) {
            this.readFileHeader();
        }
        return this.maxUpdateIndex;
    }

    @Override
    public RefCursor allRefs() {
        if (this.blockSize == -1) {
            this.readFileHeader();
        }
        if (this.refEnd == 0L) {
            this.readFileFooter();
        }
        this.src.adviseSequentialRead(0L, this.refEnd);
        ReftableReader$RefCursorImpl reftableReader$RefCursorImpl = new ReftableReader$RefCursorImpl(this, this.refEnd, null, false);
        reftableReader$RefCursorImpl.block = this.readBlock(0L, this.refEnd);
        return reftableReader$RefCursorImpl;
    }

    @Override
    public RefCursor seekRef(String string) {
        this.initRefIndex();
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        ReftableReader$RefCursorImpl reftableReader$RefCursorImpl = new ReftableReader$RefCursorImpl(this, this.refEnd, byArray, false);
        reftableReader$RefCursorImpl.block = this.seek((byte)114, byArray, this.refIndex, 0L, this.refEnd);
        return reftableReader$RefCursorImpl;
    }

    @Override
    public RefCursor seekRefsWithPrefix(String string) {
        this.initRefIndex();
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        ReftableReader$RefCursorImpl reftableReader$RefCursorImpl = new ReftableReader$RefCursorImpl(this, this.refEnd, byArray, true);
        reftableReader$RefCursorImpl.block = this.seek((byte)114, byArray, this.refIndex, 0L, this.refEnd);
        return reftableReader$RefCursorImpl;
    }

    @Override
    public RefCursor byObjectId(AnyObjectId anyObjectId) {
        this.initObjIndex();
        ReftableReader$ObjCursorImpl reftableReader$ObjCursorImpl = new ReftableReader$ObjCursorImpl(this, this.refEnd, anyObjectId);
        if (this.objIndex != null) {
            reftableReader$ObjCursorImpl.initSeek();
        } else {
            reftableReader$ObjCursorImpl.initScan();
        }
        return reftableReader$ObjCursorImpl;
    }

    @Override
    public LogCursor allLogs() {
        this.initLogIndex();
        if (this.logPosition > 0L) {
            this.src.adviseSequentialRead(this.logPosition, this.logEnd);
            ReftableReader$LogCursorImpl reftableReader$LogCursorImpl = new ReftableReader$LogCursorImpl(this, this.logEnd, null);
            reftableReader$LogCursorImpl.block = this.readBlock(this.logPosition, this.logEnd);
            return reftableReader$LogCursorImpl;
        }
        return new EmptyLogCursor();
    }

    @Override
    public LogCursor seekLog(String string, long l2) {
        this.initLogIndex();
        if (this.logPosition > 0L) {
            byte[] byArray = BlockWriter$LogEntry.key(string, l2);
            byte[] byArray2 = string.getBytes(StandardCharsets.UTF_8);
            ReftableReader$LogCursorImpl reftableReader$LogCursorImpl = new ReftableReader$LogCursorImpl(this, this.logEnd, byArray2);
            reftableReader$LogCursorImpl.block = this.seek((byte)103, byArray, this.logIndex, this.logPosition, this.logEnd);
            return reftableReader$LogCursorImpl;
        }
        return new EmptyLogCursor();
    }

    private BlockReader seek(byte by, byte[] byArray, BlockReader blockReader, long l2, long l3) {
        if (blockReader != null) {
            long l4;
            BlockReader blockReader2 = blockReader;
            do {
                if (blockReader2.seekKey(byArray) <= 0) continue;
                return null;
            } while ((blockReader2 = this.readBlock(l4 = blockReader2.readPositionFromIndex(), l3)).type() == 105);
            blockReader2.seekKey(byArray);
            return blockReader2;
        }
        if (by == 103) {
            BlockReader blockReader3 = this.readBlock(l2, l3);
            while (true) {
                if (blockReader3 == null || blockReader3.type() != 103) {
                    return null;
                }
                int n2 = blockReader3.seekKey(byArray);
                if (n2 <= 0) {
                    return blockReader3;
                }
                long l5 = blockReader3.endPosition();
                if (l5 >= l3) {
                    return null;
                }
                blockReader3 = this.readBlock(l5, l3);
            }
        }
        return this.binarySearch(by, byArray, l2, l3);
    }

    private BlockReader binarySearch(byte by, byte[] byArray, long l2, long l3) {
        if (this.blockSize == 0) {
            BlockReader blockReader = this.readBlock(l2, l3);
            if (by != blockReader.type()) {
                return null;
            }
            blockReader.seekKey(byArray);
            return blockReader;
        }
        int n2 = (int)(l2 / (long)this.blockSize);
        int n3 = this.blocksIn(l2, l3);
        BlockReader blockReader = null;
        do {
            int n4;
            if (by != (blockReader = this.readBlock((long)(n4 = n2 + n3 >>> 1) * (long)this.blockSize, l3)).type()) {
                return null;
            }
            int n5 = blockReader.seekKey(byArray);
            if (n5 < 0) {
                n3 = n4;
                continue;
            }
            if (n5 == 0) break;
            n2 = n4 + 1;
        } while (n2 < n3);
        return blockReader;
    }

    private void readFileHeader() {
        this.readHeaderOrFooter(0L, 24);
    }

    private void readFileFooter() {
        int n2 = 68;
        byte[] byArray = this.readHeaderOrFooter(this.src.size() - (long)n2, n2);
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray, 0, n2 - 4);
        if (cRC32.getValue() != NB.decodeUInt32(byArray, n2 - 4)) {
            throw new IOException(JGitText.get().invalidReftableCRC);
        }
        this.refIndexPosition = NB.decodeInt64(byArray, 24);
        long l2 = NB.decodeInt64(byArray, 32);
        this.objPosition = l2 >>> 5;
        this.objIdLen = (int)(l2 & 0x1FL);
        this.objIndexPosition = NB.decodeInt64(byArray, 40);
        this.logPosition = NB.decodeInt64(byArray, 48);
        this.logIndexPosition = NB.decodeInt64(byArray, 56);
        this.refEnd = this.refIndexPosition > 0L ? this.refIndexPosition : (this.objPosition > 0L ? this.objPosition : (this.logPosition > 0L ? this.logPosition : this.src.size() - (long)n2));
        if (this.objPosition > 0L) {
            this.objEnd = this.objIndexPosition > 0L ? this.objIndexPosition : (this.logPosition > 0L ? this.logPosition : this.src.size() - (long)n2);
        }
        if (this.logPosition > 0L) {
            this.logEnd = this.logIndexPosition > 0L ? this.logIndexPosition : this.src.size() - (long)n2;
        }
    }

    private byte[] readHeaderOrFooter(long l2, int n2) {
        ByteBuffer byteBuffer = this.src.read(l2, n2);
        if (byteBuffer.position() != n2) {
            throw new IOException(JGitText.get().shortReadOfBlock);
        }
        byte[] byArray = new byte[n2];
        byteBuffer.flip();
        byteBuffer.get(byArray);
        if (!ReftableConstants.isFileHeaderMagic(byArray, 0, n2)) {
            throw new IOException(JGitText.get().invalidReftableFile);
        }
        int n3 = NB.decodeInt32(byArray, 4);
        int n4 = n3 >>> 24;
        if (1 != n4) {
            throw new IOException(MessageFormat.format(JGitText.get().unsupportedReftableVersion, n4));
        }
        if (this.blockSize == -1) {
            this.blockSize = n3 & 0xFFFFFF;
        }
        this.minUpdateIndex = NB.decodeInt64(byArray, 8);
        this.maxUpdateIndex = NB.decodeInt64(byArray, 16);
        return byArray;
    }

    private void initRefIndex() {
        if (this.refIndexPosition < 0L) {
            this.readFileFooter();
        }
        if (this.refIndex == null && this.refIndexPosition > 0L) {
            this.refIndex = this.readIndex(this.refIndexPosition);
        }
    }

    private void initObjIndex() {
        if (this.objIndexPosition < 0L) {
            this.readFileFooter();
        }
        if (this.objIndex == null && this.objIndexPosition > 0L) {
            this.objIndex = this.readIndex(this.objIndexPosition);
        }
    }

    private void initLogIndex() {
        if (this.logIndexPosition < 0L) {
            this.readFileFooter();
        }
        if (this.logIndex == null && this.logIndexPosition > 0L) {
            this.logIndex = this.readIndex(this.logIndexPosition);
        }
    }

    private BlockReader readIndex(long l2) {
        int n2 = this.readBlockLen(l2);
        BlockReader blockReader = new BlockReader();
        blockReader.readBlock(this.src, l2, n2);
        blockReader.verifyIndex();
        return blockReader;
    }

    private int readBlockLen(long l2) {
        byte[] byArray;
        int n2 = l2 == 0L ? 28 : 4;
        ByteBuffer byteBuffer = this.src.read(l2, n2);
        if (byteBuffer.position() < n2) {
            throw new IOException(JGitText.get().invalidReftableFile);
        }
        if (byteBuffer.hasArray() && byteBuffer.arrayOffset() == 0) {
            byArray = byteBuffer.array();
        } else {
            byArray = new byte[n2];
            byteBuffer.flip();
            byteBuffer.get(byArray);
        }
        if (l2 == 0L && byArray[24] == 82) {
            return 24;
        }
        int n3 = l2 == 0L ? 24 : 0;
        return BlockReader.decodeBlockLen(NB.decodeInt32(byArray, n3));
    }

    private BlockReader readBlock(long l2, long l3) {
        BlockReader blockReader;
        if (this.indexCache != null && (blockReader = (BlockReader)this.indexCache.get(l2)) != null) {
            return blockReader;
        }
        int n2 = this.blockSize;
        if (n2 == 0) {
            n2 = this.readBlockLen(l2);
        } else if (l2 + (long)n2 > l3) {
            n2 = (int)(l3 - l2);
        }
        BlockReader blockReader2 = new BlockReader();
        blockReader2.readBlock(this.src, l2, n2);
        if (blockReader2.type() == 105) {
            if (this.indexCache == null) {
                this.indexCache = new LongMap();
            }
            this.indexCache.put(l2, blockReader2);
        }
        return blockReader2;
    }

    private int blocksIn(long l2, long l3) {
        int n2 = (int)((l3 - l2) / (long)this.blockSize);
        return l3 % (long)this.blockSize == 0L ? n2 : n2 + 1;
    }

    public long size() {
        return this.src.size();
    }

    @Override
    public void close() {
        this.src.close();
    }

    static /* synthetic */ BlockReader access$000(ReftableReader reftableReader, long l2, long l3) {
        return reftableReader.readBlock(l2, l3);
    }

    static /* synthetic */ long access$100(ReftableReader reftableReader) {
        return reftableReader.minUpdateIndex;
    }

    static /* synthetic */ void access$200(ReftableReader reftableReader) {
        reftableReader.initRefIndex();
    }

    static /* synthetic */ BlockReader access$300(ReftableReader reftableReader) {
        return reftableReader.refIndex;
    }

    static /* synthetic */ long access$400(ReftableReader reftableReader) {
        return reftableReader.refEnd;
    }

    static /* synthetic */ BlockReader access$500(ReftableReader reftableReader, byte by, byte[] byArray, BlockReader blockReader, long l2, long l3) {
        return reftableReader.seek(by, byArray, blockReader, l2, l3);
    }

    static /* synthetic */ int access$600(ReftableReader reftableReader) {
        return reftableReader.objIdLen;
    }

    static /* synthetic */ BlockReader access$700(ReftableReader reftableReader) {
        return reftableReader.objIndex;
    }

    static /* synthetic */ long access$800(ReftableReader reftableReader) {
        return reftableReader.objEnd;
    }
}

