/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.reftable;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.NB;
import org.eclipse.jgit.util.io.CountingOutputStream;

class ReftableOutputStream
extends OutputStream {
    private final byte[] tmp = new byte[10];
    private final CountingOutputStream out;
    private final boolean alignBlocks;
    private Deflater deflater;
    private DeflaterOutputStream compressor;
    private int blockType;
    private int blockSize;
    private int blockStart;
    private byte[] blockBuf;
    private int cur;
    private long paddingUsed;

    ReftableOutputStream(OutputStream outputStream, int n2, boolean bl2) {
        this.blockSize = n2;
        this.blockBuf = new byte[n2];
        this.alignBlocks = bl2;
        this.out = new CountingOutputStream(outputStream);
    }

    void setBlockSize(int n2) {
        this.blockSize = n2;
    }

    @Override
    public void write(int n2) {
        this.ensureBytesAvailableInBlockBuf(1);
        this.blockBuf[this.cur++] = (byte)n2;
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        this.ensureBytesAvailableInBlockBuf(n3);
        System.arraycopy(byArray, n2, this.blockBuf, this.cur, n3);
        this.cur += n3;
    }

    int bytesWrittenInBlock() {
        return this.cur;
    }

    int bytesAvailableInBlock() {
        return this.blockSize - this.cur;
    }

    long paddingUsed() {
        return this.paddingUsed;
    }

    long size() {
        return this.out.getCount();
    }

    static int computeVarintSize(long l2) {
        int n2 = 1;
        while ((l2 >>>= 7) != 0L) {
            --l2;
            ++n2;
        }
        return n2;
    }

    void writeVarint(long l2) {
        int n2 = this.tmp.length;
        this.tmp[--n2] = (byte)(l2 & 0x7FL);
        while ((l2 >>>= 7) != 0L) {
            this.tmp[--n2] = (byte)(0x80L | --l2 & 0x7FL);
        }
        this.write(this.tmp, n2, this.tmp.length - n2);
    }

    void writeInt16(int n2) {
        this.ensureBytesAvailableInBlockBuf(2);
        NB.encodeInt16(this.blockBuf, this.cur, n2);
        this.cur += 2;
    }

    void writeInt24(int n2) {
        this.ensureBytesAvailableInBlockBuf(3);
        NB.encodeInt24(this.blockBuf, this.cur, n2);
        this.cur += 3;
    }

    void writeId(ObjectId objectId) {
        this.ensureBytesAvailableInBlockBuf(20);
        objectId.copyRawTo(this.blockBuf, this.cur);
        this.cur += 20;
    }

    void writeVarintString(String string) {
        this.writeVarintString(string.getBytes(StandardCharsets.UTF_8));
    }

    void writeVarintString(byte[] byArray) {
        this.writeVarint(byArray.length);
        this.write(byArray, 0, byArray.length);
    }

    private void ensureBytesAvailableInBlockBuf(int n2) {
        if (this.cur + n2 > this.blockBuf.length) {
            int n3 = Math.max(this.cur + n2, this.blockBuf.length * 2);
            this.blockBuf = Arrays.copyOf(this.blockBuf, n3);
        }
    }

    void flushFileHeader() {
        if (this.cur == 24 && this.out.getCount() == 0L) {
            this.out.write(this.blockBuf, 0, this.cur);
            this.cur = 0;
        }
    }

    void beginBlock(byte by) {
        this.blockType = by;
        this.blockStart = this.cur;
        this.cur += 4;
    }

    void flushBlock() {
        if (this.cur > this.blockSize && this.blockType != 105) {
            throw new IOException(JGitText.get().overflowedReftableBlock);
        }
        NB.encodeInt32(this.blockBuf, this.blockStart, this.blockType << 24 | this.cur);
        if (this.blockType == 103) {
            this.out.write(this.blockBuf, 0, 4);
            if (this.deflater != null) {
                this.deflater.reset();
            } else {
                this.deflater = new Deflater(9);
                this.compressor = new DeflaterOutputStream((OutputStream)this.out, this.deflater);
            }
            this.compressor.write(this.blockBuf, 4, this.cur - 4);
            this.compressor.finish();
        } else {
            this.out.write(this.blockBuf, 0, this.cur);
        }
        this.cur = 0;
        this.blockType = 0;
        this.blockStart = 0;
    }

    void padBetweenBlocksToNextBlock() {
        long l2;
        if (this.alignBlocks && (l2 = this.size() % (long)this.blockSize) > 0L) {
            int n2 = this.blockSize - (int)l2;
            this.ensureBytesAvailableInBlockBuf(n2);
            Arrays.fill(this.blockBuf, 0, n2, (byte)0);
            this.out.write(this.blockBuf, 0, n2);
            this.paddingUsed += (long)n2;
        }
    }

    int estimatePadBetweenBlocks(int n2) {
        if (this.alignBlocks) {
            long l2 = (this.size() + (long)n2) % (long)this.blockSize;
            return l2 > 0L ? this.blockSize - (int)l2 : 0;
        }
        return 0;
    }

    void finishFile() {
        this.out.write(this.blockBuf, 0, this.cur);
        this.cur = 0;
        if (this.deflater != null) {
            this.deflater.end();
        }
    }
}

