/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.reftable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.internal.storage.reftable.MergedReftable;
import org.eclipse.jgit.internal.storage.reftable.RefCursor;
import org.eclipse.jgit.internal.storage.reftable.Reftable;
import org.eclipse.jgit.internal.storage.reftable.ReftableReflogReader;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.ReflogReader;
import org.eclipse.jgit.transport.ReceiveCommand;

public abstract class ReftableDatabase {
    private final ReentrantLock lock = new ReentrantLock(true);
    private Reftable mergedTables;

    protected abstract MergedReftable openMergedReftable();

    public long nextUpdateIndex() {
        this.lock.lock();
        try {
            long l2 = this.reader().maxUpdateIndex() + 1L;
            return l2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public ReflogReader getReflogReader(String string) {
        this.lock.lock();
        try {
            ReftableReflogReader reftableReflogReader = new ReftableReflogReader(this.lock, this.reader(), string);
            return reftableReflogReader;
        }
        finally {
            this.lock.unlock();
        }
    }

    public static ReceiveCommand toCommand(Ref ref, Ref ref2) {
        String string;
        ObjectId objectId = ReftableDatabase.toId(ref);
        ObjectId objectId2 = ReftableDatabase.toId(ref2);
        String string2 = string = ref != null ? ref.getName() : ref2.getName();
        if (ref != null && ref.isSymbolic()) {
            if (ref2 != null) {
                if (ref2.isSymbolic()) {
                    return ReceiveCommand.link(ref.getTarget().getName(), ref2.getTarget().getName(), string);
                }
                return ReceiveCommand.unlink(ref.getTarget().getName(), objectId2, string);
            }
            return ReceiveCommand.unlink(ref.getTarget().getName(), ObjectId.zeroId(), string);
        }
        if (ref2 != null && ref2.isSymbolic()) {
            if (ref != null) {
                if (ref.isSymbolic()) {
                    return ReceiveCommand.link(ref.getTarget().getName(), ref2.getTarget().getName(), string);
                }
                return ReceiveCommand.link(objectId, ref2.getTarget().getName(), string);
            }
            return ReceiveCommand.link(ObjectId.zeroId(), ref2.getTarget().getName(), string);
        }
        return new ReceiveCommand(objectId, objectId2, string);
    }

    private static ObjectId toId(Ref ref) {
        ObjectId objectId;
        if (ref != null && (objectId = ref.getObjectId()) != null) {
            return objectId;
        }
        return ObjectId.zeroId();
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    private Reftable reader() {
        if (!this.lock.isLocked()) {
            throw new IllegalStateException("must hold lock to access merged table");
        }
        if (this.mergedTables == null) {
            this.mergedTables = this.openMergedReftable();
        }
        return this.mergedTables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNameConflicting(String string, TreeSet treeSet, Set set) {
        this.lock.lock();
        try {
            String string2;
            Reftable reftable = this.reader();
            int n2 = string.lastIndexOf(47);
            while (0 < n2) {
                string2 = string.substring(0, n2);
                if (!set.contains(string2) && (reftable.hasRef(string2) || treeSet.contains(string2))) {
                    boolean bl2 = true;
                    return bl2;
                }
                n2 = string.lastIndexOf(47, n2 - 1);
            }
            string2 = string + '/';
            RefCursor refCursor = reftable.seekRefsWithPrefix(string2);
            while (refCursor.next()) {
                if (set.contains(refCursor.getRef().getName())) continue;
                boolean bl3 = true;
                return bl3;
            }
            String string3 = treeSet.ceiling(string + '/');
            if (string3 != null && string3.startsWith(string2)) {
                boolean bl4 = true;
                return bl4;
            }
            boolean bl5 = false;
            return bl5;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Ref exactRef(String string) {
        this.lock.lock();
        try {
            Reftable reftable = this.reader();
            Ref ref = reftable.exactRef(string);
            if (ref != null && ref.isSymbolic()) {
                Ref ref2 = reftable.resolve(ref);
                return ref2;
            }
            Ref ref3 = ref;
            return ref3;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getRefsByPrefix(String string) {
        ArrayList<Ref> arrayList = new ArrayList<Ref>();
        this.lock.lock();
        try {
            Reftable reftable = this.reader();
            try (RefCursor refCursor = "".equals(string) ? reftable.allRefs() : reftable.seekRefsWithPrefix(string);){
                while (refCursor.next()) {
                    Ref ref = reftable.resolve(refCursor.getRef());
                    if (ref == null || ref.getObjectId() == null) continue;
                    arrayList.add(ref);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return Collections.unmodifiableList(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getRefsByPrefixWithExclusions(String string, Set set) {
        if (set.isEmpty()) {
            return this.getRefsByPrefix(string);
        }
        ArrayList<Ref> arrayList = new ArrayList<Ref>();
        this.lock.lock();
        try {
            Reftable reftable = this.reader();
            Iterator iterator = set.stream().sorted().collect(Collectors.toList()).iterator();
            String string2 = iterator.hasNext() ? (String)iterator.next() : null;
            try (RefCursor refCursor = "".equals(string) ? reftable.allRefs() : reftable.seekRefsWithPrefix(string);){
                while (refCursor.next()) {
                    Ref ref = reftable.resolve(refCursor.getRef());
                    if (ref == null || ref.getObjectId() == null) continue;
                    while (iterator.hasNext() && !ref.getName().startsWith(string2) && ref.getName().compareTo(string2) > 0) {
                        string2 = (String)iterator.next();
                    }
                    if (string2 != null && ref.getName().startsWith(string2)) {
                        refCursor.seekPastPrefix(string2);
                        continue;
                    }
                    arrayList.add(ref);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return Collections.unmodifiableList(arrayList);
    }

    public boolean hasFastTipsWithSha1() {
        this.lock.lock();
        try {
            boolean bl2 = this.reader().hasObjectMap();
            return bl2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getTipsWithSha1(ObjectId objectId) {
        this.lock.lock();
        try {
            RefCursor refCursor = this.reader().byObjectId(objectId);
            HashSet<Ref> hashSet = new HashSet<Ref>();
            while (refCursor.next()) {
                hashSet.add(refCursor.getRef());
            }
            HashSet<Ref> hashSet2 = hashSet;
            return hashSet2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clearCache() {
        this.lock.lock();
        try {
            this.mergedTables = null;
        }
        finally {
            this.lock.unlock();
        }
    }
}

