/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.reftable;

import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;

public class ReftableConfig {
    private int refBlockSize = 4096;
    private int logBlockSize;
    private int restartInterval;
    private int maxIndexLevels;
    private boolean alignBlocks = true;
    private boolean indexObjects = true;

    public ReftableConfig() {
    }

    public ReftableConfig(Repository repository) {
        this.fromConfig(repository.getConfig());
    }

    public ReftableConfig(Config config) {
        this.fromConfig(config);
    }

    public ReftableConfig(ReftableConfig reftableConfig) {
        this.refBlockSize = reftableConfig.refBlockSize;
        this.logBlockSize = reftableConfig.logBlockSize;
        this.restartInterval = reftableConfig.restartInterval;
        this.maxIndexLevels = reftableConfig.maxIndexLevels;
        this.alignBlocks = reftableConfig.alignBlocks;
        this.indexObjects = reftableConfig.indexObjects;
    }

    public int getRefBlockSize() {
        return this.refBlockSize;
    }

    public void setRefBlockSize(int n2) {
        if (n2 > 0xFFFFFF) {
            throw new IllegalArgumentException();
        }
        this.refBlockSize = Math.max(0, n2);
    }

    public int getLogBlockSize() {
        return this.logBlockSize;
    }

    public void setLogBlockSize(int n2) {
        if (n2 > 0xFFFFFF) {
            throw new IllegalArgumentException();
        }
        this.logBlockSize = Math.max(0, n2);
    }

    public int getRestartInterval() {
        return this.restartInterval;
    }

    public void setRestartInterval(int n2) {
        this.restartInterval = Math.max(0, n2);
    }

    public int getMaxIndexLevels() {
        return this.maxIndexLevels;
    }

    public void setMaxIndexLevels(int n2) {
        this.maxIndexLevels = Math.max(0, n2);
    }

    public boolean isAlignBlocks() {
        return this.alignBlocks;
    }

    public void setAlignBlocks(boolean bl2) {
        this.alignBlocks = bl2;
    }

    public boolean isIndexObjects() {
        return this.indexObjects;
    }

    public void setIndexObjects(boolean bl2) {
        this.indexObjects = bl2;
    }

    public void fromConfig(Config config) {
        this.refBlockSize = config.getInt("reftable", "blockSize", this.refBlockSize);
        this.logBlockSize = config.getInt("reftable", "logBlockSize", this.logBlockSize);
        this.restartInterval = config.getInt("reftable", "restartInterval", this.restartInterval);
        this.maxIndexLevels = config.getInt("reftable", "indexLevels", this.maxIndexLevels);
        this.alignBlocks = config.getBoolean("reftable", "alignBlocks", this.alignBlocks);
        this.indexObjects = config.getBoolean("reftable", "indexObjects", this.indexObjects);
    }
}

