/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.reftable;

import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.internal.storage.reftable.LogCursor;
import org.eclipse.jgit.internal.storage.reftable.MergedReftable;
import org.eclipse.jgit.internal.storage.reftable.RefCursor;
import org.eclipse.jgit.internal.storage.reftable.ReftableConfig;
import org.eclipse.jgit.internal.storage.reftable.ReftableReader;
import org.eclipse.jgit.internal.storage.reftable.ReftableWriter;
import org.eclipse.jgit.internal.storage.reftable.ReftableWriter$Stats;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ReflogEntry;

public class ReftableCompactor {
    private final ReftableWriter writer;
    private final ArrayDeque tables = new ArrayDeque();
    private boolean includeDeletes;
    private long reflogExpireMinUpdateIndex = 0L;
    private long reflogExpireMaxUpdateIndex = Long.MAX_VALUE;
    private long reflogExpireOldestReflogTimeMillis;
    private ReftableWriter$Stats stats;

    public ReftableCompactor(OutputStream outputStream) {
        this.writer = new ReftableWriter(outputStream);
    }

    public ReftableCompactor setConfig(ReftableConfig reftableConfig) {
        this.writer.setConfig(reftableConfig);
        return this;
    }

    public ReftableCompactor setIncludeDeletes(boolean bl2) {
        this.includeDeletes = bl2;
        return this;
    }

    public ReftableCompactor setReflogExpireMinUpdateIndex(long l2) {
        this.reflogExpireMinUpdateIndex = l2;
        return this;
    }

    public ReftableCompactor setReflogExpireMaxUpdateIndex(long l2) {
        this.reflogExpireMaxUpdateIndex = l2;
        return this;
    }

    public ReftableCompactor setReflogExpireOldestReflogTimeMillis(long l2) {
        this.reflogExpireOldestReflogTimeMillis = l2;
        return this;
    }

    public void addAll(List list) {
        for (ReftableReader reftableReader : list) {
            this.tables.add(reftableReader);
        }
    }

    public void compact() {
        MergedReftable mergedReftable = new MergedReftable(new ArrayList(this.tables));
        mergedReftable.setIncludeDeletes(this.includeDeletes);
        this.writer.setMaxUpdateIndex(mergedReftable.maxUpdateIndex());
        this.writer.setMinUpdateIndex(mergedReftable.minUpdateIndex());
        this.writer.begin();
        this.mergeRefs(mergedReftable);
        this.mergeLogs(mergedReftable);
        this.writer.finish();
        this.stats = this.writer.getStats();
    }

    public ReftableWriter$Stats getStats() {
        return this.stats;
    }

    private void mergeRefs(MergedReftable mergedReftable) {
        try (RefCursor refCursor = mergedReftable.allRefs();){
            while (refCursor.next()) {
                this.writer.writeRef(refCursor.getRef(), refCursor.getRef().getUpdateIndex());
            }
        }
    }

    private void mergeLogs(MergedReftable mergedReftable) {
        if (this.reflogExpireOldestReflogTimeMillis == Long.MAX_VALUE) {
            return;
        }
        try (LogCursor logCursor = mergedReftable.allLogs();){
            while (logCursor.next()) {
                long l2 = logCursor.getUpdateIndex();
                if (l2 > this.reflogExpireMaxUpdateIndex || l2 < this.reflogExpireMinUpdateIndex) continue;
                String string = logCursor.getRefName();
                ReflogEntry reflogEntry = logCursor.getReflogEntry();
                if (reflogEntry == null) {
                    if (!this.includeDeletes) continue;
                    this.writer.deleteLog(string, l2);
                    continue;
                }
                PersonIdent personIdent = reflogEntry.getWho();
                if (personIdent.getWhen().getTime() < this.reflogExpireOldestReflogTimeMillis) continue;
                this.writer.writeLog(string, l2, personIdent, reflogEntry.getOldId(), reflogEntry.getNewId(), reflogEntry.getComment());
            }
        }
    }
}

