/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.reftable;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.reftable.ReftableDatabase;
import org.eclipse.jgit.internal.storage.reftable.ReftableWriter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef$PeeledNonTag;
import org.eclipse.jgit.lib.ObjectIdRef$PeeledTag;
import org.eclipse.jgit.lib.ObjectIdRef$Unpeeled;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Ref$Storage;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.SymbolicRef;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.ReceiveCommand$Result;
import org.eclipse.jgit.transport.ReceiveCommand$Type;

public abstract class ReftableBatchRefUpdate
extends BatchRefUpdate {
    private final Lock lock;
    private final ReftableDatabase refDb;
    private final Repository repository;

    protected ReftableBatchRefUpdate(RefDatabase refDatabase, ReftableDatabase reftableDatabase, Lock lock, Repository repository) {
        super(refDatabase);
        this.refDb = reftableDatabase;
        this.lock = lock;
        this.repository = repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(RevWalk revWalk, ProgressMonitor progressMonitor, List list) {
        List list2 = this.getPending();
        if (list2.isEmpty()) {
            return;
        }
        if (list != null) {
            this.setPushOptions(list);
        }
        try {
            if (!this.checkObjectExistence(revWalk, list2)) {
                return;
            }
            list2 = this.getPending();
            if (!this.checkNonFastForwards(revWalk, list2)) {
                return;
            }
            list2 = this.getPending();
            this.lock.lock();
            try {
                if (!this.checkExpected(list2)) {
                    return;
                }
                list2 = this.getPending();
                if (!this.checkConflicting(list2)) {
                    return;
                }
                list2 = this.getPending();
                if (!this.blockUntilTimestamps(MAX_WAIT)) {
                    return;
                }
                List list3 = ReftableBatchRefUpdate.toNewRefs(revWalk, list2);
                this.applyUpdates(list3, list2);
                for (ReceiveCommand receiveCommand : list2) {
                    if (receiveCommand.getResult() != ReceiveCommand$Result.NOT_ATTEMPTED) continue;
                    receiveCommand.setResult(ReceiveCommand$Result.OK);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (IOException iOException) {
            ((ReceiveCommand)list2.get(0)).setResult(ReceiveCommand$Result.LOCK_FAILURE, "io error");
            ReceiveCommand.abort(list2);
        }
    }

    protected abstract void applyUpdates(List var1, List var2);

    private List getPending() {
        return ReceiveCommand.filter(this.getCommands(), ReceiveCommand$Result.NOT_ATTEMPTED);
    }

    private boolean checkObjectExistence(RevWalk revWalk, List list) {
        for (ReceiveCommand receiveCommand : list) {
            try {
                if (receiveCommand.getNewId().equals(ObjectId.zeroId())) continue;
                revWalk.parseAny(receiveCommand.getNewId());
            }
            catch (MissingObjectException missingObjectException) {
                receiveCommand.setResult(ReceiveCommand$Result.REJECTED_MISSING_OBJECT);
                if (!this.isAtomic()) continue;
                ReceiveCommand.abort(list);
                return false;
            }
        }
        return true;
    }

    private boolean checkNonFastForwards(RevWalk revWalk, List list) {
        if (this.isAllowNonFastForwards()) {
            return true;
        }
        for (ReceiveCommand receiveCommand : list) {
            receiveCommand.updateType(revWalk);
            if (receiveCommand.getType() != ReceiveCommand$Type.UPDATE_NONFASTFORWARD) continue;
            receiveCommand.setResult(ReceiveCommand$Result.REJECTED_NONFASTFORWARD);
            if (!this.isAtomic()) continue;
            ReceiveCommand.abort(list);
            return false;
        }
        return true;
    }

    private boolean checkConflicting(List list) {
        TreeSet<String> treeSet = new TreeSet<String>();
        Set set = list.stream().filter(receiveCommand -> receiveCommand.getType() == ReceiveCommand$Type.DELETE).map(receiveCommand -> receiveCommand.getRefName()).collect(Collectors.toSet());
        boolean bl2 = true;
        for (ReceiveCommand receiveCommand2 : list) {
            if (receiveCommand2.getType() == ReceiveCommand$Type.DELETE) continue;
            String string = receiveCommand2.getRefName();
            if (this.refDb.isNameConflicting(string, treeSet, set)) {
                if (this.isAtomic()) {
                    receiveCommand2.setResult(ReceiveCommand$Result.REJECTED_OTHER_REASON, JGitText.get().transactionAborted);
                } else {
                    receiveCommand2.setResult(ReceiveCommand$Result.LOCK_FAILURE);
                }
                bl2 = false;
            }
            treeSet.add(string);
        }
        if (this.isAtomic()) {
            if (!bl2) {
                list.stream().filter(receiveCommand -> receiveCommand.getResult() == ReceiveCommand$Result.NOT_ATTEMPTED).forEach(receiveCommand -> receiveCommand.setResult(ReceiveCommand$Result.LOCK_FAILURE));
            }
            return bl2;
        }
        for (ReceiveCommand receiveCommand2 : list) {
            if (receiveCommand2.getResult() != ReceiveCommand$Result.NOT_ATTEMPTED) continue;
            return true;
        }
        return false;
    }

    private boolean checkExpected(List list) {
        for (ReceiveCommand receiveCommand : list) {
            if (ReftableBatchRefUpdate.matchOld(receiveCommand, this.refDb.exactRef(receiveCommand.getRefName()))) continue;
            receiveCommand.setResult(ReceiveCommand$Result.LOCK_FAILURE);
            if (!this.isAtomic()) continue;
            ReceiveCommand.abort(list);
            return false;
        }
        return true;
    }

    private static boolean matchOld(ReceiveCommand receiveCommand, @Nullable Ref ref) {
        if (ref == null) {
            return AnyObjectId.isEqual(ObjectId.zeroId(), receiveCommand.getOldId()) && receiveCommand.getOldSymref() == null;
        }
        if (ref.isSymbolic()) {
            return ref.getTarget().getName().equals(receiveCommand.getOldSymref());
        }
        ObjectId objectId = ref.getObjectId();
        if (objectId == null) {
            objectId = ObjectId.zeroId();
        }
        return receiveCommand.getOldId().equals(objectId);
    }

    protected void write(ReftableWriter reftableWriter, List list, List list2) {
        long l2 = this.refDb.nextUpdateIndex();
        reftableWriter.setMinUpdateIndex(l2).setMaxUpdateIndex(l2).begin().sortAndWriteRefs(list);
        if (!this.isRefLogDisabled()) {
            this.writeLog(reftableWriter, l2, list2);
        }
    }

    private void writeLog(ReftableWriter reftableWriter, long l2, List list) {
        HashMap<String, ReceiveCommand> hashMap = new HashMap<String, ReceiveCommand>();
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (Object object : list) {
            hashMap.put(((ReceiveCommand)object).getRefName(), (ReceiveCommand)object);
            arrayList.add(((ReceiveCommand)object).getRefName());
        }
        Collections.sort(arrayList);
        Object object = this.getRefLogIdent();
        if (object == null) {
            object = new PersonIdent(this.repository);
        }
        for (String string : arrayList) {
            String string2;
            ReceiveCommand receiveCommand = (ReceiveCommand)hashMap.get(string);
            if (this.isRefLogDisabled(receiveCommand)) continue;
            String string3 = this.getRefLogMessage(receiveCommand);
            if (this.isRefLogIncludingResult(receiveCommand) && (string2 = this.toResultString(receiveCommand)) != null) {
                string3 = string3.isEmpty() ? string2 : string3 + ": " + string2;
            }
            reftableWriter.writeLog(string, l2, (PersonIdent)object, receiveCommand.getOldId(), receiveCommand.getNewId(), string3);
        }
    }

    private String toResultString(ReceiveCommand receiveCommand) {
        switch (receiveCommand.getType()) {
            case CREATE: {
                return "created";
            }
            case UPDATE: {
                return this.isAllowNonFastForwards() ? "forced-update" : "fast-forward";
            }
            case UPDATE_NONFASTFORWARD: {
                return "forced-update";
            }
        }
        return null;
    }

    private static List toNewRefs(RevWalk revWalk, List list) {
        ArrayList<Ref> arrayList = new ArrayList<Ref>(list.size());
        for (ReceiveCommand receiveCommand : list) {
            if (receiveCommand.getResult() != ReceiveCommand$Result.NOT_ATTEMPTED) continue;
            String string = receiveCommand.getRefName();
            ObjectId objectId = receiveCommand.getNewId();
            String string2 = receiveCommand.getNewSymref();
            if (AnyObjectId.isEqual(ObjectId.zeroId(), objectId) && string2 == null) {
                arrayList.add(new ObjectIdRef$Unpeeled(Ref$Storage.NEW, string, null));
                continue;
            }
            if (string2 != null) {
                arrayList.add(new SymbolicRef(string, new ObjectIdRef$Unpeeled(Ref$Storage.NEW, string2, null)));
                continue;
            }
            RevObject revObject = revWalk.parseAny(objectId);
            RevObject revObject2 = null;
            if (revObject instanceof RevTag) {
                revObject2 = revWalk.peel(revObject);
            }
            if (revObject2 != null) {
                arrayList.add(new ObjectIdRef$PeeledTag(Ref$Storage.PACKED, string, objectId, revObject2.copy()));
                continue;
            }
            arrayList.add(new ObjectIdRef$PeeledNonTag(Ref$Storage.PACKED, string, objectId));
        }
        return arrayList;
    }
}

