/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.reftable;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.internal.storage.io.BlockSource;
import org.eclipse.jgit.internal.storage.reftable.LogCursor;
import org.eclipse.jgit.internal.storage.reftable.RefCursor;
import org.eclipse.jgit.internal.storage.reftable.ReftableConfig;
import org.eclipse.jgit.internal.storage.reftable.ReftableReader;
import org.eclipse.jgit.internal.storage.reftable.ReftableWriter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.SymbolicRef;

public abstract class Reftable {
    protected boolean includeDeletes;

    public static Reftable from(Collection collection) {
        try {
            ReftableConfig reftableConfig = new ReftableConfig();
            reftableConfig.setIndexObjects(false);
            reftableConfig.setAlignBlocks(false);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            new ReftableWriter(byteArrayOutputStream).setConfig(reftableConfig).begin().sortAndWriteRefs(collection).finish();
            return new ReftableReader(BlockSource.from(byteArrayOutputStream.toByteArray()));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void setIncludeDeletes(boolean bl2) {
        this.includeDeletes = bl2;
    }

    public abstract long maxUpdateIndex();

    public abstract long minUpdateIndex();

    public abstract RefCursor allRefs();

    public abstract RefCursor seekRef(String var1);

    public abstract RefCursor seekRefsWithPrefix(String var1);

    public abstract RefCursor byObjectId(AnyObjectId var1);

    public abstract boolean hasObjectMap();

    public abstract LogCursor allLogs();

    public LogCursor seekLog(String string) {
        return this.seekLog(string, Long.MAX_VALUE);
    }

    public abstract LogCursor seekLog(String var1, long var2);

    @Nullable
    public Ref exactRef(String string) {
        try (RefCursor refCursor = this.seekRef(string);){
            Ref ref = refCursor.next() ? refCursor.getRef() : null;
            return ref;
        }
    }

    public boolean hasRef(String string) {
        try (RefCursor refCursor = this.seekRef(string);){
            boolean bl2 = refCursor.next();
            return bl2;
        }
    }

    public boolean hasRefsWithPrefix(String string) {
        try (RefCursor refCursor = this.seekRefsWithPrefix(string);){
            boolean bl2 = refCursor.next();
            return bl2;
        }
    }

    public boolean hasId(AnyObjectId anyObjectId) {
        try (RefCursor refCursor = this.byObjectId(anyObjectId);){
            boolean bl2 = refCursor.next();
            return bl2;
        }
    }

    @Nullable
    public Ref resolve(Ref ref) {
        return this.resolve(ref, 0);
    }

    private Ref resolve(Ref ref, int n2) {
        if (!ref.isSymbolic()) {
            return ref;
        }
        Ref ref2 = ref.getTarget();
        if (5 <= n2) {
            return null;
        }
        if ((ref2 = this.exactRef(ref2.getName())) == null) {
            return ref;
        }
        if ((ref2 = this.resolve(ref2, n2 + 1)) == null) {
            return null;
        }
        return new SymbolicRef(ref.getName(), ref2, ref.getUpdateIndex());
    }
}

