/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.reftable;

import java.util.List;
import org.eclipse.jgit.internal.storage.reftable.LogCursor;
import org.eclipse.jgit.internal.storage.reftable.MergedReftable$FilteringMergedRefCursor;
import org.eclipse.jgit.internal.storage.reftable.MergedReftable$LogQueueEntry;
import org.eclipse.jgit.internal.storage.reftable.MergedReftable$MergedLogCursor;
import org.eclipse.jgit.internal.storage.reftable.MergedReftable$MergedRefCursor;
import org.eclipse.jgit.internal.storage.reftable.MergedReftable$RefQueueEntry;
import org.eclipse.jgit.internal.storage.reftable.RefCursor;
import org.eclipse.jgit.internal.storage.reftable.Reftable;
import org.eclipse.jgit.internal.storage.reftable.ReftableReader;
import org.eclipse.jgit.lib.AnyObjectId;

public class MergedReftable
extends Reftable {
    private final ReftableReader[] tables;

    public MergedReftable(List list) {
        for (ReftableReader reftableReader : this.tables = list.toArray(new ReftableReader[0])) {
            reftableReader.setIncludeDeletes(true);
        }
    }

    @Override
    public long maxUpdateIndex() {
        if (this.tables.length == 0) {
            return 0L;
        }
        long l2 = this.tables[this.tables.length - 1].maxUpdateIndex();
        for (int i2 = this.tables.length - 2; i2 >= 0; --i2) {
            if (l2 >= this.tables[i2].maxUpdateIndex()) continue;
            l2 = this.tables[i2].maxUpdateIndex();
        }
        return l2;
    }

    @Override
    public long minUpdateIndex() {
        if (this.tables.length == 0) {
            return 0L;
        }
        long l2 = this.tables[0].minUpdateIndex();
        for (int i2 = 1; i2 < this.tables.length; ++i2) {
            if (this.tables[i2].minUpdateIndex() >= l2) continue;
            l2 = this.tables[i2].minUpdateIndex();
        }
        return l2;
    }

    @Override
    public boolean hasObjectMap() {
        boolean bl2 = true;
        for (int i2 = 0; bl2 && i2 < this.tables.length; ++i2) {
            bl2 = bl2 && this.tables[i2].hasObjectMap();
        }
        return bl2;
    }

    @Override
    public RefCursor allRefs() {
        MergedReftable$MergedRefCursor mergedReftable$MergedRefCursor = new MergedReftable$MergedRefCursor(this);
        for (int i2 = 0; i2 < this.tables.length; ++i2) {
            mergedReftable$MergedRefCursor.add(new MergedReftable$RefQueueEntry(this.tables[i2].allRefs(), i2));
        }
        return mergedReftable$MergedRefCursor;
    }

    @Override
    public RefCursor seekRef(String string) {
        MergedReftable$MergedRefCursor mergedReftable$MergedRefCursor = new MergedReftable$MergedRefCursor(this);
        for (int i2 = 0; i2 < this.tables.length; ++i2) {
            mergedReftable$MergedRefCursor.add(new MergedReftable$RefQueueEntry(this.tables[i2].seekRef(string), i2));
        }
        return mergedReftable$MergedRefCursor;
    }

    @Override
    public RefCursor seekRefsWithPrefix(String string) {
        MergedReftable$MergedRefCursor mergedReftable$MergedRefCursor = new MergedReftable$MergedRefCursor(this);
        for (int i2 = 0; i2 < this.tables.length; ++i2) {
            mergedReftable$MergedRefCursor.add(new MergedReftable$RefQueueEntry(this.tables[i2].seekRefsWithPrefix(string), i2));
        }
        return mergedReftable$MergedRefCursor;
    }

    @Override
    public RefCursor byObjectId(AnyObjectId anyObjectId) {
        MergedReftable$FilteringMergedRefCursor mergedReftable$FilteringMergedRefCursor = new MergedReftable$FilteringMergedRefCursor(this, anyObjectId);
        for (int i2 = 0; i2 < this.tables.length; ++i2) {
            mergedReftable$FilteringMergedRefCursor.add(new MergedReftable$RefQueueEntry(this.tables[i2].byObjectId(anyObjectId), i2));
        }
        return mergedReftable$FilteringMergedRefCursor;
    }

    @Override
    public LogCursor allLogs() {
        MergedReftable$MergedLogCursor mergedReftable$MergedLogCursor = new MergedReftable$MergedLogCursor(this);
        for (int i2 = 0; i2 < this.tables.length; ++i2) {
            mergedReftable$MergedLogCursor.add(new MergedReftable$LogQueueEntry(this.tables[i2].allLogs(), i2));
        }
        return mergedReftable$MergedLogCursor;
    }

    @Override
    public LogCursor seekLog(String string, long l2) {
        MergedReftable$MergedLogCursor mergedReftable$MergedLogCursor = new MergedReftable$MergedLogCursor(this);
        for (int i2 = 0; i2 < this.tables.length; ++i2) {
            mergedReftable$MergedLogCursor.add(new MergedReftable$LogQueueEntry(this.tables[i2].seekLog(string, l2), i2));
        }
        return mergedReftable$MergedLogCursor;
    }

    int queueSize() {
        return Math.max(1, this.tables.length);
    }
}

