/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.reftable;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.internal.storage.reftable.BlockSizeTooSmallException;
import org.eclipse.jgit.internal.storage.reftable.BlockWriter$Entry;
import org.eclipse.jgit.internal.storage.reftable.BlockWriter$ObjEntry;
import org.eclipse.jgit.internal.storage.reftable.ReftableOutputStream;
import org.eclipse.jgit.util.IntList;

class BlockWriter {
    private final byte blockType;
    private final byte keyType;
    private final List entries;
    private final int blockLimitBytes;
    private final int restartInterval;
    private int entriesSumBytes;
    private int restartCnt;

    BlockWriter(byte by, byte by2, int n2, int n3) {
        this.blockType = by;
        this.keyType = by2;
        this.blockLimitBytes = n2;
        this.restartInterval = n3;
        this.entries = new ArrayList(BlockWriter.estimateEntryCount(by, by2, n2));
    }

    private static int estimateEntryCount(byte by, byte by2, int n2) {
        double d2;
        block0 : switch (by) {
            default: {
                d2 = 35.31;
                break;
            }
            case 111: {
                d2 = 4.19;
                break;
            }
            case 103: {
                d2 = 101.14;
                break;
            }
            case 105: {
                switch (by2) {
                    default: {
                        d2 = 27.44;
                        break block0;
                    }
                    case 111: 
                }
                d2 = 11.57;
            }
        }
        int n3 = (int)Math.ceil((double)n2 / d2);
        return Math.min(n3, 4096);
    }

    byte blockType() {
        return this.blockType;
    }

    boolean padBetweenBlocks() {
        return BlockWriter.padBetweenBlocks(this.blockType) || this.blockType == 105 && BlockWriter.padBetweenBlocks(this.keyType);
    }

    static boolean padBetweenBlocks(byte by) {
        return by == 114 || by == 111;
    }

    byte[] lastKey() {
        return ((BlockWriter$Entry)this.entries.get((int)(this.entries.size() - 1))).key;
    }

    int currentSize() {
        return this.computeBlockBytes(0, false);
    }

    void mustAdd(BlockWriter$Entry blockWriter$Entry) {
        if (!this.tryAdd(blockWriter$Entry, true)) {
            throw this.blockSizeTooSmall(blockWriter$Entry);
        }
    }

    boolean tryAdd(BlockWriter$Entry blockWriter$Entry) {
        if (blockWriter$Entry instanceof BlockWriter$ObjEntry && BlockWriter.computeBlockBytes(blockWriter$Entry.sizeBytes(), 1) > this.blockLimitBytes) {
            ((BlockWriter$ObjEntry)blockWriter$Entry).markScanRequired();
        }
        if (this.tryAdd(blockWriter$Entry, true)) {
            return true;
        }
        if (this.nextShouldBeRestart()) {
            return this.tryAdd(blockWriter$Entry, false);
        }
        return false;
    }

    private boolean tryAdd(BlockWriter$Entry blockWriter$Entry, boolean bl2) {
        boolean bl3;
        byte[] byArray = blockWriter$Entry.key;
        int n2 = 0;
        boolean bl4 = bl3 = bl2 && this.nextShouldBeRestart();
        if (!bl3) {
            BlockWriter$Entry blockWriter$Entry2 = (BlockWriter$Entry)this.entries.get(this.entries.size() - 1);
            byte[] byArray2 = blockWriter$Entry2.key;
            n2 = BlockWriter.commonPrefix(byArray2, byArray2.length, byArray);
            if (n2 <= 5 && this.keyType == 114) {
                bl3 = true;
                n2 = 0;
            } else if (n2 == 0) {
                bl3 = true;
            }
        }
        blockWriter$Entry.restart = bl3;
        blockWriter$Entry.prefixLen = n2;
        int n3 = blockWriter$Entry.sizeBytes();
        if (this.computeBlockBytes(n3, bl3) > this.blockLimitBytes) {
            return false;
        }
        this.entriesSumBytes += n3;
        this.entries.add(blockWriter$Entry);
        if (bl3) {
            ++this.restartCnt;
        }
        return true;
    }

    private boolean nextShouldBeRestart() {
        int n2 = this.entries.size();
        return (n2 == 0 || (n2 + 1) % this.restartInterval == 0) && this.restartCnt < 65535;
    }

    private int computeBlockBytes(int n2, boolean bl2) {
        return BlockWriter.computeBlockBytes(this.entriesSumBytes + n2, this.restartCnt + (bl2 ? 1 : 0));
    }

    private static int computeBlockBytes(int n2, int n3) {
        return 4 + n2 + n3 * 3 + 2;
    }

    void writeTo(ReftableOutputStream reftableOutputStream) {
        reftableOutputStream.beginBlock(this.blockType);
        IntList intList = new IntList(this.restartCnt);
        for (BlockWriter$Entry blockWriter$Entry : this.entries) {
            if (blockWriter$Entry.restart) {
                intList.add(reftableOutputStream.bytesWrittenInBlock());
            }
            blockWriter$Entry.writeKey(reftableOutputStream);
            blockWriter$Entry.writeValue(reftableOutputStream);
        }
        if (intList.size() == 0 || intList.size() > 65535) {
            throw new IllegalStateException();
        }
        for (int i2 = 0; i2 < intList.size(); ++i2) {
            reftableOutputStream.writeInt24(intList.get(i2));
        }
        reftableOutputStream.writeInt16(intList.size());
        reftableOutputStream.flushBlock();
    }

    private BlockSizeTooSmallException blockSizeTooSmall(BlockWriter$Entry blockWriter$Entry) {
        int n2 = 24 + BlockWriter.computeBlockBytes(blockWriter$Entry.sizeBytes(), 1);
        return new BlockSizeTooSmallException(n2);
    }

    static int commonPrefix(byte[] byArray, int n2, byte[] byArray2) {
        int n3 = Math.min(n2, Math.min(byArray.length, byArray2.length));
        for (int i2 = 0; i2 < n3; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return i2;
        }
        return n3;
    }

    static int encodeSuffixAndType(int n2, int n3) {
        return n2 << 3 | n3;
    }

    static int compare(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) {
        int n6 = n2 + n3;
        int n7 = n4 + n5;
        while (n2 < n6 && n4 < n7) {
            int n8;
            if ((n8 = (byArray[n2++] & 0xFF) - (byArray2[n4++] & 0xFF)) == 0) continue;
            return n8;
        }
        return n3 - n5;
    }
}

