/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.reftable;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.reftable.BlockWriter$Entry;
import org.eclipse.jgit.internal.storage.reftable.ReftableOutputStream;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Ref$Storage;

class BlockWriter$RefEntry
extends BlockWriter$Entry {
    final Ref ref;
    final long updateIndexDelta;

    BlockWriter$RefEntry(Ref ref, long l2) {
        super(BlockWriter$RefEntry.nameUtf8(ref));
        this.ref = ref;
        this.updateIndexDelta = l2;
    }

    @Override
    byte blockType() {
        return 114;
    }

    @Override
    int valueType() {
        if (this.ref.isSymbolic()) {
            return 3;
        }
        if (this.ref.getStorage() == Ref$Storage.NEW && this.ref.getObjectId() == null) {
            return 0;
        }
        if (this.ref.getPeeledObjectId() != null) {
            return 2;
        }
        return 1;
    }

    @Override
    int valueSize() {
        int n2 = ReftableOutputStream.computeVarintSize(this.updateIndexDelta);
        switch (this.valueType()) {
            case 0: {
                return n2;
            }
            case 1: {
                return n2 + 20;
            }
            case 2: {
                return n2 + 40;
            }
            case 3: {
                if (!this.ref.isSymbolic()) break;
                int n3 = BlockWriter$RefEntry.nameUtf8(this.ref.getTarget()).length;
                return n2 + ReftableOutputStream.computeVarintSize(n3) + n3;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    void writeValue(ReftableOutputStream reftableOutputStream) {
        reftableOutputStream.writeVarint(this.updateIndexDelta);
        switch (this.valueType()) {
            case 0: {
                return;
            }
            case 1: {
                ObjectId objectId = this.ref.getObjectId();
                if (!this.ref.isPeeled()) {
                    throw new IOException(JGitText.get().peeledRefIsRequired);
                }
                if (objectId == null) {
                    throw new IOException(JGitText.get().invalidId0);
                }
                reftableOutputStream.writeId(objectId);
                return;
            }
            case 2: {
                ObjectId objectId = this.ref.getObjectId();
                ObjectId objectId2 = this.ref.getPeeledObjectId();
                if (!this.ref.isPeeled()) {
                    throw new IOException(JGitText.get().peeledRefIsRequired);
                }
                if (objectId == null || objectId2 == null) {
                    throw new IOException(JGitText.get().invalidId0);
                }
                reftableOutputStream.writeId(objectId);
                reftableOutputStream.writeId(objectId2);
                return;
            }
            case 3: {
                if (!this.ref.isSymbolic()) break;
                reftableOutputStream.writeVarintString(this.ref.getTarget().getName());
                return;
            }
        }
        throw new IllegalStateException();
    }

    private static byte[] nameUtf8(Ref ref) {
        return ref.getName().getBytes(StandardCharsets.UTF_8);
    }
}

