/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.reftable;

import java.util.Arrays;
import org.eclipse.jgit.internal.storage.reftable.BlockWriter$Entry;
import org.eclipse.jgit.internal.storage.reftable.ReftableOutputStream;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.LongList;

class BlockWriter$ObjEntry
extends BlockWriter$Entry {
    final LongList blockPos;

    BlockWriter$ObjEntry(int n2, ObjectId objectId, LongList longList) {
        super(BlockWriter$ObjEntry.key(n2, objectId));
        this.blockPos = longList;
    }

    private static byte[] key(int n2, ObjectId objectId) {
        byte[] byArray = new byte[20];
        objectId.copyRawTo(byArray, 0);
        if (n2 < 20) {
            return Arrays.copyOf(byArray, n2);
        }
        return byArray;
    }

    void markScanRequired() {
        this.blockPos.clear();
    }

    @Override
    byte blockType() {
        return 111;
    }

    @Override
    int valueType() {
        int n2 = this.blockPos.size();
        return n2 != 0 && n2 <= 7 ? n2 : 0;
    }

    @Override
    int valueSize() {
        int n2 = this.blockPos.size();
        if (n2 == 0) {
            return ReftableOutputStream.computeVarintSize(0L);
        }
        int n3 = 0;
        if (n2 > 7) {
            n3 += ReftableOutputStream.computeVarintSize(n2);
        }
        n3 += ReftableOutputStream.computeVarintSize(this.blockPos.get(0));
        for (int i2 = 1; i2 < n2; ++i2) {
            long l2 = this.blockPos.get(i2 - 1);
            long l3 = this.blockPos.get(i2);
            n3 += ReftableOutputStream.computeVarintSize(l3 - l2);
        }
        return n3;
    }

    @Override
    void writeValue(ReftableOutputStream reftableOutputStream) {
        int n2 = this.blockPos.size();
        if (n2 == 0) {
            reftableOutputStream.writeVarint(0L);
            return;
        }
        if (n2 > 7) {
            reftableOutputStream.writeVarint(n2);
        }
        reftableOutputStream.writeVarint(this.blockPos.get(0));
        for (int i2 = 1; i2 < n2; ++i2) {
            long l2 = this.blockPos.get(i2 - 1);
            long l3 = this.blockPos.get(i2);
            reftableOutputStream.writeVarint(l3 - l2);
        }
    }
}

