/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.reftable;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.eclipse.jgit.internal.storage.reftable.BlockWriter$Entry;
import org.eclipse.jgit.internal.storage.reftable.ReftableConstants;
import org.eclipse.jgit.internal.storage.reftable.ReftableOutputStream;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.util.NB;

class BlockWriter$LogEntry
extends BlockWriter$Entry {
    final ObjectId oldId;
    final ObjectId newId;
    final long timeSecs;
    final short tz;
    final byte[] name;
    final byte[] email;
    final byte[] msg;

    BlockWriter$LogEntry(String string, long l2, PersonIdent personIdent, ObjectId objectId, ObjectId objectId2, String string2) {
        super(BlockWriter$LogEntry.key(string, l2));
        this.oldId = objectId;
        this.newId = objectId2;
        this.timeSecs = personIdent.getWhen().getTime() / 1000L;
        this.tz = (short)personIdent.getTimeZoneOffset();
        this.name = personIdent.getName().getBytes(StandardCharsets.UTF_8);
        this.email = personIdent.getEmailAddress().getBytes(StandardCharsets.UTF_8);
        this.msg = string2.getBytes(StandardCharsets.UTF_8);
    }

    static byte[] key(String string, long l2) {
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length + 1 + 8);
        NB.encodeInt64(byArray2, byArray2.length - 8, ReftableConstants.reverseUpdateIndex(l2));
        return byArray2;
    }

    @Override
    byte blockType() {
        return 103;
    }

    @Override
    int valueType() {
        return 1;
    }

    @Override
    int valueSize() {
        return 40 + ReftableOutputStream.computeVarintSize(this.name.length) + this.name.length + ReftableOutputStream.computeVarintSize(this.email.length) + this.email.length + ReftableOutputStream.computeVarintSize(this.timeSecs) + 2 + ReftableOutputStream.computeVarintSize(this.msg.length) + this.msg.length;
    }

    @Override
    void writeValue(ReftableOutputStream reftableOutputStream) {
        reftableOutputStream.writeId(this.oldId);
        reftableOutputStream.writeId(this.newId);
        reftableOutputStream.writeVarintString(this.name);
        reftableOutputStream.writeVarintString(this.email);
        reftableOutputStream.writeVarint(this.timeSecs);
        reftableOutputStream.writeInt16(this.tz);
        reftableOutputStream.writeVarintString(this.msg);
    }
}

