/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.reftable;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.io.BlockSource;
import org.eclipse.jgit.internal.storage.reftable.BlockReader$1;
import org.eclipse.jgit.internal.storage.reftable.BlockWriter;
import org.eclipse.jgit.internal.storage.reftable.ReftableConstants;
import org.eclipse.jgit.lib.InflaterCache;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef$PeeledNonTag;
import org.eclipse.jgit.lib.ObjectIdRef$PeeledTag;
import org.eclipse.jgit.lib.ObjectIdRef$Unpeeled;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Ref$Storage;
import org.eclipse.jgit.lib.ReflogEntry;
import org.eclipse.jgit.lib.SymbolicRef;
import org.eclipse.jgit.util.LongList;
import org.eclipse.jgit.util.NB;
import org.eclipse.jgit.util.RawParseUtils;

class BlockReader {
    private byte blockType;
    private long endPosition;
    private byte[] buf;
    private int bufLen;
    private int ptr;
    private int keysStart;
    private int keysEnd;
    private int restartCnt;
    private int restartTbl;
    private byte[] nameBuf = new byte[256];
    private int nameLen;
    private int valueType;

    BlockReader() {
    }

    byte type() {
        return this.blockType;
    }

    long endPosition() {
        return this.endPosition;
    }

    boolean next() {
        return this.ptr < this.keysEnd;
    }

    void parseKey() {
        int n2 = this.readVarint32();
        this.valueType = this.readVarint32();
        int n3 = this.valueType >>> 3;
        if (n2 + n3 > this.nameBuf.length) {
            int n4 = Math.max(n2 + n3, this.nameBuf.length * 2);
            this.nameBuf = Arrays.copyOf(this.nameBuf, n4);
        }
        System.arraycopy(this.buf, this.ptr, this.nameBuf, n2, n3);
        this.ptr += n3;
        this.nameLen = n2 + n3;
    }

    String name() {
        int n2 = this.nameLen;
        if (this.blockType == 103) {
            n2 -= 9;
        }
        return RawParseUtils.decode(StandardCharsets.UTF_8, this.nameBuf, 0, n2);
    }

    boolean match(byte[] byArray, boolean bl2) {
        int n2 = this.nameLen;
        if (this.blockType == 103) {
            n2 -= 9;
        }
        if (bl2) {
            return n2 >= byArray.length && BlockWriter.compare(byArray, 0, byArray.length, this.nameBuf, 0, byArray.length) == 0;
        }
        return BlockWriter.compare(byArray, 0, byArray.length, this.nameBuf, 0, n2) == 0;
    }

    long readPositionFromIndex() {
        if (this.blockType != 105) {
            throw BlockReader.invalidBlock();
        }
        this.readVarint32();
        int n2 = this.readVarint32() >>> 3;
        this.ptr += n2;
        return this.readVarint64();
    }

    long readUpdateIndexDelta() {
        return this.readVarint64();
    }

    Ref readRef(long l2) {
        long l3 = l2 + this.readUpdateIndexDelta();
        String string = RawParseUtils.decode(StandardCharsets.UTF_8, this.nameBuf, 0, this.nameLen);
        switch (this.valueType & 7) {
            case 0: {
                return BlockReader.newRef(string, l3);
            }
            case 1: {
                return new ObjectIdRef$PeeledNonTag(Ref$Storage.PACKED, string, this.readValueId(), l3);
            }
            case 2: {
                ObjectId objectId = this.readValueId();
                ObjectId objectId2 = this.readValueId();
                return new ObjectIdRef$PeeledTag(Ref$Storage.PACKED, string, objectId, objectId2, l3);
            }
            case 3: {
                String string2 = this.readValueString();
                return new SymbolicRef(string, BlockReader.newRef(string2, l3), l3);
            }
        }
        throw BlockReader.invalidBlock();
    }

    @Nullable
    LongList readBlockPositionList() {
        int n2 = this.valueType & 7;
        if (n2 == 0 && (n2 = this.readVarint32()) == 0) {
            return null;
        }
        LongList longList = new LongList(n2);
        longList.add(this.readVarint64());
        for (int i2 = 1; i2 < n2; ++i2) {
            long l2 = longList.get(i2 - 1);
            longList.add(l2 + this.readVarint64());
        }
        return longList;
    }

    long readLogUpdateIndex() {
        return ReftableConstants.reverseUpdateIndex(NB.decodeUInt64(this.nameBuf, this.nameLen - 8));
    }

    @Nullable
    ReflogEntry readLogEntry() {
        if ((this.valueType & 7) == 0) {
            return null;
        }
        ObjectId objectId = this.readValueId();
        ObjectId objectId2 = this.readValueId();
        PersonIdent personIdent = this.readPersonIdent();
        String string = this.readValueString();
        return new BlockReader$1(this, objectId, objectId2, personIdent, string);
    }

    private ObjectId readValueId() {
        ObjectId objectId = ObjectId.fromRaw(this.buf, this.ptr);
        this.ptr += 20;
        return objectId;
    }

    private String readValueString() {
        int n2 = this.readVarint32();
        int n3 = this.ptr + n2;
        String string = RawParseUtils.decode(StandardCharsets.UTF_8, this.buf, this.ptr, n3);
        this.ptr = n3;
        return string;
    }

    private PersonIdent readPersonIdent() {
        String string = this.readValueString();
        String string2 = this.readValueString();
        long l2 = this.readVarint64() * 1000L;
        short s2 = this.readInt16();
        return new PersonIdent(string, string2, l2, s2);
    }

    void readBlock(BlockSource blockSource, long l2, int n2) {
        this.readBlockIntoBuf(blockSource, l2, n2);
        this.parseBlockStart(blockSource, l2, n2);
    }

    private void readBlockIntoBuf(BlockSource blockSource, long l2, int n2) {
        ByteBuffer byteBuffer = blockSource.read(l2, n2);
        this.bufLen = byteBuffer.position();
        if (this.bufLen <= 0) {
            throw BlockReader.invalidBlock();
        }
        if (byteBuffer.hasArray() && byteBuffer.arrayOffset() == 0) {
            this.buf = byteBuffer.array();
        } else {
            this.buf = new byte[this.bufLen];
            byteBuffer.flip();
            byteBuffer.get(this.buf);
        }
        this.endPosition = l2 + (long)this.bufLen;
    }

    private void parseBlockStart(BlockSource blockSource, long l2, int n2) {
        this.ptr = 0;
        if (l2 == 0L) {
            if (this.bufLen == 24) {
                this.setupEmptyFileBlock();
                return;
            }
            this.ptr += 24;
        }
        int n3 = NB.decodeInt32(this.buf, this.ptr);
        this.ptr += 4;
        this.blockType = (byte)(n3 >>> 24);
        int n4 = BlockReader.decodeBlockLen(n3);
        if (this.blockType == 103) {
            long l3 = this.inflateBuf(blockSource, l2, n4, n2);
            this.endPosition = l2 + 4L + l3;
        } else if (this.bufLen < n4) {
            this.readBlockIntoBuf(blockSource, l2, n4);
        } else if (this.bufLen > n4) {
            this.bufLen = n4;
        }
        if (this.blockType != 82) {
            this.restartCnt = NB.decodeUInt16(this.buf, this.bufLen - 2);
            this.restartTbl = this.bufLen - (this.restartCnt * 3 + 2);
            this.keysStart = this.ptr;
            this.keysEnd = this.restartTbl;
        } else {
            this.keysStart = this.ptr;
            this.keysEnd = this.ptr;
        }
    }

    static int decodeBlockLen(int n2) {
        return n2 & 0xFFFFFF;
    }

    private long inflateBuf(BlockSource blockSource, long l2, int n2, int n3) {
        long l3;
        byte[] byArray;
        block8: {
            byArray = new byte[n2];
            System.arraycopy(this.buf, 0, byArray, 0, 4);
            l3 = 0L;
            Inflater inflater = InflaterCache.get();
            try {
                inflater.setInput(this.buf, this.ptr, this.bufLen - this.ptr);
                int n4 = 4;
                while (true) {
                    int n5 = inflater.inflate(byArray, n4, byArray.length - n4);
                    n4 += n5;
                    if (inflater.finished()) {
                        l3 = inflater.getBytesRead();
                        break block8;
                    }
                    if (n5 <= 0 && inflater.needsInput()) {
                        long l4 = l2 + 4L + inflater.getBytesRead();
                        this.readBlockIntoBuf(blockSource, l4, n3);
                        inflater.setInput(this.buf, 0, this.bufLen);
                        continue;
                    }
                    if (n5 <= 0) break;
                }
                throw BlockReader.invalidBlock();
            }
            catch (DataFormatException dataFormatException) {
                throw BlockReader.invalidBlock(dataFormatException);
            }
            finally {
                InflaterCache.release(inflater);
            }
        }
        this.buf = byArray;
        this.bufLen = byArray.length;
        return l3;
    }

    private void setupEmptyFileBlock() {
        this.blockType = (byte)82;
        this.ptr = 24;
        this.restartCnt = 0;
        this.restartTbl = this.bufLen;
        this.keysStart = this.bufLen;
        this.keysEnd = this.bufLen;
    }

    void verifyIndex() {
        if (this.blockType != 105) {
            throw BlockReader.invalidBlock();
        }
    }

    int seekKey(byte[] byArray) {
        int n2;
        int n3;
        int n4 = 0;
        int n5 = this.restartCnt;
        do {
            int n6 = n4 + n5 >>> 1;
            n3 = NB.decodeUInt24(this.buf, this.restartTbl + n6 * 3);
            this.ptr = n3 + 1;
            int n7 = this.readVarint32() >>> 3;
            n2 = BlockWriter.compare(byArray, 0, byArray.length, this.buf, this.ptr, n7);
            if (n2 < 0) {
                n5 = n6;
                continue;
            }
            if (n2 == 0) {
                this.ptr = n3;
                return 0;
            }
            n4 = n6 + 1;
        } while (n4 < n5);
        return this.scanToKey(byArray, n3, n4, n2);
    }

    private int scanToKey(byte[] byArray, int n2, int n3, int n4) {
        int n5;
        if (n4 < 0) {
            if (n3 == 0) {
                this.ptr = this.keysStart;
                return -1;
            }
            this.ptr = NB.decodeUInt24(this.buf, this.restartTbl + (n3 - 1) * 3);
        } else {
            this.ptr = n2;
        }
        do {
            int n6 = this.ptr;
            this.parseKey();
            n5 = BlockWriter.compare(byArray, 0, byArray.length, this.nameBuf, 0, this.nameLen);
            if (n5 <= 0) {
                this.ptr = n6;
                return n5 < 0 && n6 == this.keysStart ? -1 : 0;
            }
            this.skipValue();
        } while (this.ptr < this.keysEnd);
        return n5;
    }

    void skipValue() {
        switch (this.blockType) {
            case 114: {
                this.readVarint64();
                switch (this.valueType & 7) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        this.ptr += 20;
                        return;
                    }
                    case 2: {
                        this.ptr += 40;
                        return;
                    }
                    case 3: {
                        this.skipString();
                        return;
                    }
                }
                break;
            }
            case 111: {
                int n2 = this.valueType & 7;
                if (n2 == 0) {
                    n2 = this.readVarint32();
                }
                while (n2-- > 0) {
                    this.readVarint32();
                }
                return;
            }
            case 105: {
                this.readVarint32();
                return;
            }
            case 103: {
                if ((this.valueType & 7) == 0) {
                    return;
                }
                if ((this.valueType & 7) != 1) break;
                this.ptr += 40;
                this.skipString();
                this.skipString();
                this.readVarint64();
                this.ptr += 2;
                this.skipString();
                return;
            }
        }
        throw new IllegalStateException();
    }

    private void skipString() {
        int n2 = this.readVarint32();
        this.ptr += n2;
    }

    private short readInt16() {
        short s2 = (short)NB.decodeUInt16(this.buf, this.ptr);
        this.ptr += 2;
        return s2;
    }

    private int readVarint32() {
        byte by = this.buf[this.ptr++];
        int n2 = by & 0x7F;
        while ((by & 0x80) != 0) {
            by = this.buf[this.ptr++];
            ++n2;
            n2 <<= 7;
            n2 |= by & 0x7F;
        }
        return n2;
    }

    private long readVarint64() {
        byte by = this.buf[this.ptr++];
        long l2 = by & 0x7F;
        while ((by & 0x80) != 0) {
            by = this.buf[this.ptr++];
            ++l2;
            l2 <<= 7;
            l2 |= (long)(by & 0x7F);
        }
        return l2;
    }

    private static Ref newRef(String string, long l2) {
        return new ObjectIdRef$Unpeeled(Ref$Storage.NEW, string, null, l2);
    }

    private static IOException invalidBlock() {
        return BlockReader.invalidBlock(null);
    }

    private static IOException invalidBlock(Throwable throwable) {
        return new IOException(JGitText.get().invalidReftableBlock, throwable);
    }
}

