/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.pack;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jgit.internal.storage.file.BitmapIndexImpl;
import org.eclipse.jgit.internal.storage.file.BitmapIndexImpl$CompressedBitmap;
import org.eclipse.jgit.internal.storage.file.BitmapIndexImpl$CompressedBitmapBuilder;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndexBuilder;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndexRemapper;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndexRemapper$Entry;
import org.eclipse.jgit.internal.storage.pack.BitmapCommit;
import org.eclipse.jgit.internal.storage.pack.PackWriterBitmapPreparer$CommitSelectionHelper;
import org.eclipse.jgit.internal.storage.pack.PackWriterBitmapPreparer$NotInBitmapFilter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.revwalk.BitmapWalker;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.util.SystemReader;

class PackWriterBitmapPreparer {
    private static final int DAY_IN_SECONDS = 86400;
    private static final int DISTANCE_THRESHOLD = 2000;
    private static final Comparator ORDER_BY_REVERSE_TIMESTAMP = (revCommit, revCommit2) -> Integer.signum(revCommit2.getCommitTime() - revCommit.getCommitTime());
    private final ObjectReader reader;
    private final ProgressMonitor pm;
    private final Set want;
    private final PackBitmapIndexBuilder writeBitmaps;
    private final BitmapIndexImpl commitBitmapIndex;
    private final PackBitmapIndexRemapper bitmapRemapper;
    private final BitmapIndexImpl bitmapIndex;
    private final int contiguousCommitCount;
    private final int recentCommitCount;
    private final int recentCommitSpan;
    private final int distantCommitSpan;
    private final int excessiveBranchCount;
    private final long inactiveBranchTimestamp;

    PackWriterBitmapPreparer(ObjectReader objectReader, PackBitmapIndexBuilder packBitmapIndexBuilder, ProgressMonitor progressMonitor, Set set, PackConfig packConfig) {
        this.reader = objectReader;
        this.writeBitmaps = packBitmapIndexBuilder;
        this.pm = progressMonitor;
        this.want = set;
        this.commitBitmapIndex = new BitmapIndexImpl(packBitmapIndexBuilder);
        this.bitmapRemapper = PackBitmapIndexRemapper.newPackBitmapIndex(objectReader.getBitmapIndex(), packBitmapIndexBuilder);
        this.bitmapIndex = new BitmapIndexImpl(this.bitmapRemapper);
        this.contiguousCommitCount = packConfig.getBitmapContiguousCommitCount();
        this.recentCommitCount = packConfig.getBitmapRecentCommitCount();
        this.recentCommitSpan = packConfig.getBitmapRecentCommitSpan();
        this.distantCommitSpan = packConfig.getBitmapDistantCommitSpan();
        this.excessiveBranchCount = packConfig.getBitmapExcessiveBranchCount();
        long l2 = SystemReader.getInstance().getCurrentTime();
        long l3 = packConfig.getBitmapInactiveBranchAgeInDays() * 86400;
        this.inactiveBranchTimestamp = l2 / 1000L - l3;
    }

    /*
     * Exception decompiling
     */
    Collection selectCommits(int var1_1, Set var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isRecentCommit(RevCommit revCommit) {
        return (long)revCommit.getCommitTime() > this.inactiveBranchTimestamp;
    }

    private PackWriterBitmapPreparer$CommitSelectionHelper captureOldAndNewCommits(RevWalk revWalk, int n2, Set set) {
        Serializable serializable;
        RevCommit[] revCommitArray;
        Serializable serializable22;
        BitmapIndexImpl$CompressedBitmapBuilder bitmapIndexImpl$CompressedBitmapBuilder = this.commitBitmapIndex.newBitmapBuilder();
        ArrayList<BitmapCommit> arrayList = new ArrayList<BitmapCommit>();
        for (Serializable serializable22 : this.bitmapRemapper) {
            if ((((PackBitmapIndexRemapper$Entry)serializable22).getFlags() & 1) != 1 || !((revCommitArray = revWalk.peel(revWalk.parseAny((AnyObjectId)((Object)serializable22)))) instanceof RevCommit)) continue;
            AnyObjectId anyObjectId = (RevCommit)revCommitArray;
            arrayList.add(new BitmapCommit(anyObjectId, false, ((PackBitmapIndexRemapper$Entry)serializable22).getFlags()));
            if (bitmapIndexImpl$CompressedBitmapBuilder.contains(anyObjectId)) continue;
            serializable = this.bitmapRemapper.ofObjectType(this.bitmapRemapper.getBitmap(anyObjectId), 1);
            bitmapIndexImpl$CompressedBitmapBuilder.or(new BitmapIndexImpl$CompressedBitmap((EWAHCompressedBitmap)serializable, this.commitBitmapIndex));
        }
        ArrayList arrayList2 = new ArrayList(this.want.size());
        serializable22 = new HashSet(this.want.size());
        for (AnyObjectId anyObjectId : this.want) {
            if (set.contains(anyObjectId) || !((serializable = revWalk.peel(revWalk.parseAny(anyObjectId))) instanceof RevCommit) || bitmapIndexImpl$CompressedBitmapBuilder.contains((AnyObjectId)((Object)serializable)) || set.contains(serializable)) continue;
            RevCommit revCommit = (RevCommit)serializable;
            revWalk.markStart(revCommit);
            serializable22.add(revCommit);
            arrayList2.add(revCommit);
        }
        revWalk.setRevFilter(new PackWriterBitmapPreparer$NotInBitmapFilter(bitmapIndexImpl$CompressedBitmapBuilder));
        revCommitArray = new RevCommit[n2];
        int n3 = revCommitArray.length;
        while ((serializable = revWalk.next()) != null && n3 > 0) {
            revCommitArray[--n3] = serializable;
            this.pm.update(1);
        }
        Collections.sort(arrayList2, ORDER_BY_REVERSE_TIMESTAMP);
        return new PackWriterBitmapPreparer$CommitSelectionHelper((Set)((Object)serializable22), revCommitArray, n3, arrayList2, bitmapIndexImpl$CompressedBitmapBuilder, arrayList);
    }

    int nextSpan(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        if (n2 <= this.recentCommitCount) {
            return this.recentCommitSpan;
        }
        int n3 = Math.min(n2 - this.recentCommitCount, this.distantCommitSpan);
        return Math.max(n3, this.recentCommitSpan);
    }

    BitmapWalker newBitmapWalker() {
        return new BitmapWalker(new ObjectWalk(this.reader), this.bitmapIndex, null);
    }
}

