/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.pack;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.SearchForReuseTimeout;
import org.eclipse.jgit.errors.StoredObjectRepresentationNotAvailableException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndexBuilder;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndexWriterV1;
import org.eclipse.jgit.internal.storage.file.PackIndexWriter;
import org.eclipse.jgit.internal.storage.pack.BaseSearch;
import org.eclipse.jgit.internal.storage.pack.BitmapCommit;
import org.eclipse.jgit.internal.storage.pack.CachedPack;
import org.eclipse.jgit.internal.storage.pack.CachedPackUriProvider$PackInfo;
import org.eclipse.jgit.internal.storage.pack.DeltaCache;
import org.eclipse.jgit.internal.storage.pack.DeltaCache$Ref;
import org.eclipse.jgit.internal.storage.pack.DeltaIndex;
import org.eclipse.jgit.internal.storage.pack.DeltaTask;
import org.eclipse.jgit.internal.storage.pack.DeltaTask$Block;
import org.eclipse.jgit.internal.storage.pack.DeltaWindow;
import org.eclipse.jgit.internal.storage.pack.ObjectReuseAsIs;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.internal.storage.pack.PackOutputStream;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.internal.storage.pack.PackWriter$1;
import org.eclipse.jgit.internal.storage.pack.PackWriter$2;
import org.eclipse.jgit.internal.storage.pack.PackWriter$DepthAwareVisitationPolicy;
import org.eclipse.jgit.internal.storage.pack.PackWriter$MutableState;
import org.eclipse.jgit.internal.storage.pack.PackWriter$PackfileUriConfig;
import org.eclipse.jgit.internal.storage.pack.PackWriter$PackingPhase;
import org.eclipse.jgit.internal.storage.pack.PackWriterBitmapPreparer;
import org.eclipse.jgit.internal.storage.pack.StoredObjectRepresentation;
import org.eclipse.jgit.internal.storage.pack.ThreadSafeDeltaCache;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.AsyncObjectSizeQueue;
import org.eclipse.jgit.lib.BatchingProgressMonitor;
import org.eclipse.jgit.lib.BitmapIndex;
import org.eclipse.jgit.lib.BitmapIndex$BitmapBuilder;
import org.eclipse.jgit.lib.BitmapObject;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdOwnerMap;
import org.eclipse.jgit.lib.ObjectIdSet;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.ThreadSafeProgressMonitor;
import org.eclipse.jgit.revwalk.AsyncRevObjectQueue;
import org.eclipse.jgit.revwalk.BitmapWalker;
import org.eclipse.jgit.revwalk.DepthWalk$ObjectWalk;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.storage.pack.PackStatistics;
import org.eclipse.jgit.storage.pack.PackStatistics$Accumulator;
import org.eclipse.jgit.storage.pack.PackStatistics$ObjectType$Accumulator;
import org.eclipse.jgit.transport.FilterSpec;
import org.eclipse.jgit.transport.ObjectCountCallback;
import org.eclipse.jgit.transport.PacketLineOut;
import org.eclipse.jgit.util.BlockList;
import org.eclipse.jgit.util.TemporaryBuffer;
import org.eclipse.jgit.util.TemporaryBuffer$Heap;

public class PackWriter
implements AutoCloseable {
    private static final int PACK_VERSION_GENERATED = 2;
    public static final Set NONE = Collections.emptySet();
    private static final Map instances = new ConcurrentHashMap();
    private static final Iterable instancesIterable = () -> new PackWriter$1();
    BlockList[] objectsLists = new BlockList[5];
    private ObjectIdOwnerMap objectsMap;
    private List edgeObjects;
    private BitmapIndex$BitmapBuilder haveObjects;
    private List cachedPacks;
    private Set tagTargets;
    private Set excludeFromBitmapSelection;
    private ObjectIdSet[] excludeInPacks;
    private ObjectIdSet excludeInPackLast;
    private Deflater myDeflater;
    private final ObjectReader reader;
    private final ObjectReuseAsIs reuseSupport;
    final PackConfig config;
    private final PackStatistics$Accumulator stats;
    private final PackWriter$MutableState state;
    private final WeakReference selfRef;
    private PackStatistics$ObjectType$Accumulator typeStats;
    private List sortedByName;
    private byte[] packcsum;
    private boolean deltaBaseAsOffset;
    private boolean reuseDeltas;
    private boolean reuseDeltaCommits;
    private boolean reuseValidate;
    private boolean thin;
    private boolean useCachedPacks;
    private boolean useBitmaps;
    private boolean createBitmaps;
    private boolean ignoreMissingUninteresting;
    private boolean pruneCurrentObjectList;
    private boolean shallowPack;
    private boolean canBuildBitmaps;
    private boolean indexDisabled;
    private boolean checkSearchForReuseTimeout;
    private final Duration searchForReuseTimeout;
    private long searchForReuseStartTimeEpoc;
    private int depth;
    private Collection unshallowObjects;
    private PackBitmapIndexBuilder writeBitmaps;
    private CRC32 crc32;
    private ObjectCountCallback callback;
    private FilterSpec filterSpec;
    private PackWriter$PackfileUriConfig packfileUriConfig;

    public static Iterable getInstances() {
        return instancesIterable;
    }

    public PackWriter(Repository repository) {
        this(repository, repository.newObjectReader());
    }

    public PackWriter(ObjectReader objectReader) {
        this(new PackConfig(), objectReader);
    }

    public PackWriter(Repository repository, ObjectReader objectReader) {
        this(new PackConfig(repository), objectReader);
    }

    public PackWriter(PackConfig packConfig, ObjectReader objectReader) {
        this(packConfig, objectReader, null);
    }

    public PackWriter(PackConfig packConfig, ObjectReader objectReader, @Nullable PackStatistics$Accumulator packStatistics$Accumulator) {
        this.objectsLists[1] = new BlockList();
        this.objectsLists[2] = new BlockList();
        this.objectsLists[3] = new BlockList();
        this.objectsLists[4] = new BlockList();
        this.objectsMap = new ObjectIdOwnerMap();
        this.edgeObjects = new BlockList();
        this.cachedPacks = new ArrayList(2);
        this.tagTargets = NONE;
        this.excludeFromBitmapSelection = NONE;
        this.createBitmaps = true;
        this.ignoreMissingUninteresting = true;
        this.checkSearchForReuseTimeout = false;
        this.filterSpec = FilterSpec.NO_FILTER;
        this.config = packConfig;
        this.reader = objectReader;
        this.reuseSupport = objectReader instanceof ObjectReuseAsIs ? (ObjectReuseAsIs)((Object)objectReader) : null;
        this.deltaBaseAsOffset = packConfig.isDeltaBaseAsOffset();
        this.reuseDeltas = packConfig.isReuseDeltas();
        this.searchForReuseTimeout = packConfig.getSearchForReuseTimeout();
        this.reuseValidate = true;
        this.stats = packStatistics$Accumulator != null ? packStatistics$Accumulator : new PackStatistics$Accumulator();
        this.state = new PackWriter$MutableState(this);
        this.selfRef = new WeakReference<PackWriter>(this);
        instances.put(this.selfRef, Boolean.TRUE);
    }

    public PackWriter setObjectCountCallback(ObjectCountCallback objectCountCallback) {
        this.callback = objectCountCallback;
        return this;
    }

    public void setClientShallowCommits(Set set) {
        this.stats.clientShallowCommits = Collections.unmodifiableSet(new HashSet(set));
    }

    public boolean isDeltaBaseAsOffset() {
        return this.deltaBaseAsOffset;
    }

    public void checkSearchForReuseTimeout() {
        if (this.checkSearchForReuseTimeout && Duration.ofMillis(System.currentTimeMillis() - this.searchForReuseStartTimeEpoc).compareTo(this.searchForReuseTimeout) > 0) {
            throw new SearchForReuseTimeout(this.searchForReuseTimeout);
        }
    }

    public void setDeltaBaseAsOffset(boolean bl2) {
        this.deltaBaseAsOffset = bl2;
    }

    public void enableSearchForReuseTimeout() {
        this.checkSearchForReuseTimeout = true;
    }

    public boolean isReuseDeltaCommits() {
        return this.reuseDeltaCommits;
    }

    public void setReuseDeltaCommits(boolean bl2) {
        this.reuseDeltaCommits = bl2;
    }

    public boolean isReuseValidatingObjects() {
        return this.reuseValidate;
    }

    public void setReuseValidatingObjects(boolean bl2) {
        this.reuseValidate = bl2;
    }

    public boolean isThin() {
        return this.thin;
    }

    public void setThin(boolean bl2) {
        this.thin = bl2;
    }

    public boolean isUseCachedPacks() {
        return this.useCachedPacks;
    }

    public void setUseCachedPacks(boolean bl2) {
        this.useCachedPacks = bl2;
    }

    public boolean isUseBitmaps() {
        return this.useBitmaps;
    }

    public void setUseBitmaps(boolean bl2) {
        this.useBitmaps = bl2;
    }

    public void setCreateBitmaps(boolean bl2) {
        this.createBitmaps = bl2;
    }

    public boolean isCreateBitmaps() {
        return this.createBitmaps;
    }

    public boolean isIndexDisabled() {
        return this.indexDisabled || !this.cachedPacks.isEmpty();
    }

    public void setIndexDisabled(boolean bl2) {
        this.indexDisabled = bl2;
    }

    public boolean isIgnoreMissingUninteresting() {
        return this.ignoreMissingUninteresting;
    }

    public void setIgnoreMissingUninteresting(boolean bl2) {
        this.ignoreMissingUninteresting = bl2;
    }

    public void setTagTargets(Set set) {
        this.tagTargets = set;
    }

    public void setShallowPack(int n2, Collection collection) {
        this.shallowPack = true;
        this.depth = n2;
        this.unshallowObjects = collection;
    }

    public void setFilterSpec(@NonNull FilterSpec filterSpec) {
        this.filterSpec = Objects.requireNonNull(filterSpec);
    }

    public void setPackfileUriConfig(PackWriter$PackfileUriConfig packfileUriConfig) {
        this.packfileUriConfig = packfileUriConfig;
    }

    public long getObjectCount() {
        if (this.stats.totalObjects == 0L) {
            long l2 = 0L;
            l2 += (long)this.objectsLists[1].size();
            l2 += (long)this.objectsLists[2].size();
            l2 += (long)this.objectsLists[3].size();
            l2 += (long)this.objectsLists[4].size();
            for (CachedPack cachedPack : this.cachedPacks) {
                l2 += cachedPack.getObjectCount();
            }
            return l2;
        }
        return this.stats.totalObjects;
    }

    private long getUnoffloadedObjectCount() {
        long l2 = 0L;
        l2 += (long)this.objectsLists[1].size();
        l2 += (long)this.objectsLists[2].size();
        l2 += (long)this.objectsLists[3].size();
        l2 += (long)this.objectsLists[4].size();
        for (CachedPack cachedPack : this.cachedPacks) {
            CachedPackUriProvider$PackInfo packInfo = PackWriter$PackfileUriConfig.access$100(this.packfileUriConfig).getInfo(cachedPack, PackWriter$PackfileUriConfig.access$000(this.packfileUriConfig));
            if (packInfo != null) continue;
            l2 += cachedPack.getObjectCount();
        }
        return l2;
    }

    public ObjectIdOwnerMap getObjectSet() {
        if (!this.cachedPacks.isEmpty()) {
            throw new IOException(JGitText.get().cachedPacksPreventsListingObjects);
        }
        if (this.writeBitmaps != null) {
            return this.writeBitmaps.getObjectSet();
        }
        ObjectIdOwnerMap objectIdOwnerMap = new ObjectIdOwnerMap();
        for (BlockList blockList : this.objectsLists) {
            if (blockList == null) continue;
            for (ObjectToPack objectToPack : blockList) {
                objectIdOwnerMap.add(new PackWriter$2(this, objectToPack));
            }
        }
        return objectIdOwnerMap;
    }

    public void excludeObjects(ObjectIdSet objectIdSet) {
        if (this.excludeInPacks == null) {
            this.excludeInPacks = new ObjectIdSet[]{objectIdSet};
            this.excludeInPackLast = objectIdSet;
        } else {
            int n2 = this.excludeInPacks.length;
            ObjectIdSet[] objectIdSetArray = new ObjectIdSet[n2 + 1];
            System.arraycopy(this.excludeInPacks, 0, objectIdSetArray, 0, n2);
            objectIdSetArray[n2] = objectIdSet;
            this.excludeInPacks = objectIdSetArray;
        }
    }

    public void preparePack(@NonNull Iterator iterator) {
        while (iterator.hasNext()) {
            this.addObject((RevObject)iterator.next());
        }
    }

    public void preparePack(Collection collection) {
        this.cachedPacks.addAll(collection);
    }

    public void preparePack(ProgressMonitor progressMonitor, @NonNull Set set, @NonNull Set set2) {
        this.preparePack(progressMonitor, set, set2, NONE, NONE);
    }

    public void preparePack(ProgressMonitor progressMonitor, @NonNull Set set, @NonNull Set set2, @NonNull Set set3) {
        this.preparePack(progressMonitor, set, set2, set3, NONE);
    }

    public void preparePack(ProgressMonitor progressMonitor, @NonNull Set set, @NonNull Set set2, @NonNull Set set3, @NonNull Set set4) {
        try (ObjectWalk objectWalk = this.getObjectWalk();){
            objectWalk.assumeShallow(set3);
            this.preparePack(progressMonitor, objectWalk, set, set2, set4);
        }
    }

    private ObjectWalk getObjectWalk() {
        return this.shallowPack ? new DepthWalk$ObjectWalk(this.reader, this.depth - 1) : new ObjectWalk(this.reader);
    }

    public void preparePack(ProgressMonitor progressMonitor, @NonNull ObjectWalk objectWalk, @NonNull Set set, @NonNull Set set2, @NonNull Set set3) {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        if (this.shallowPack && !(objectWalk instanceof DepthWalk$ObjectWalk)) {
            throw new IllegalArgumentException(JGitText.get().shallowPacksRequireDepthWalk);
        }
        if (this.filterSpec.getTreeDepthLimit() >= 0L) {
            objectWalk.setVisitationPolicy(new PackWriter$DepthAwareVisitationPolicy(objectWalk));
        }
        this.findObjectsToPack(progressMonitor, objectWalk, set, set2, set3);
    }

    public boolean willInclude(AnyObjectId anyObjectId) {
        ObjectToPack objectToPack = (ObjectToPack)this.objectsMap.get(anyObjectId);
        return objectToPack != null && !objectToPack.isEdge();
    }

    public ObjectToPack get(AnyObjectId anyObjectId) {
        ObjectToPack objectToPack = (ObjectToPack)this.objectsMap.get(anyObjectId);
        return objectToPack != null && !objectToPack.isEdge() ? objectToPack : null;
    }

    public ObjectId computeName() {
        byte[] byArray = new byte[20];
        MessageDigest messageDigest = Constants.newMessageDigest();
        for (ObjectToPack objectToPack : this.sortByName()) {
            objectToPack.copyRawTo(byArray, 0);
            messageDigest.update(byArray, 0, 20);
        }
        return ObjectId.fromRaw(messageDigest.digest());
    }

    public int getIndexVersion() {
        int n2 = this.config.getIndexVersion();
        if (n2 <= 0) {
            for (BlockList blockList : this.objectsLists) {
                n2 = Math.max(n2, PackIndexWriter.oldestPossibleFormat(blockList));
            }
        }
        return n2;
    }

    public void writeIndex(OutputStream outputStream) {
        if (this.isIndexDisabled()) {
            throw new IOException(JGitText.get().cachedPacksPreventsIndexCreation);
        }
        long l2 = System.currentTimeMillis();
        PackIndexWriter packIndexWriter = PackIndexWriter.createVersion(outputStream, this.getIndexVersion());
        packIndexWriter.write(this.sortByName(), this.packcsum);
        this.stats.timeWriting += System.currentTimeMillis() - l2;
    }

    public void writeBitmapIndex(OutputStream outputStream) {
        if (this.writeBitmaps == null) {
            throw new IOException(JGitText.get().bitmapsMustBePrepared);
        }
        long l2 = System.currentTimeMillis();
        PackBitmapIndexWriterV1 packBitmapIndexWriterV1 = new PackBitmapIndexWriterV1(outputStream);
        packBitmapIndexWriterV1.write(this.writeBitmaps, this.packcsum);
        this.stats.timeWriting += System.currentTimeMillis() - l2;
    }

    private List sortByName() {
        if (this.sortedByName == null) {
            int n2 = 0;
            n2 += this.objectsLists[1].size();
            n2 += this.objectsLists[2].size();
            n2 += this.objectsLists[3].size();
            this.sortedByName = new BlockList(n2 += this.objectsLists[4].size());
            this.sortedByName.addAll(this.objectsLists[1]);
            this.sortedByName.addAll(this.objectsLists[2]);
            this.sortedByName.addAll(this.objectsLists[3]);
            this.sortedByName.addAll(this.objectsLists[4]);
            Collections.sort(this.sortedByName);
        }
        return this.sortedByName;
    }

    private void beginPhase(PackWriter$PackingPhase packWriter$PackingPhase, ProgressMonitor progressMonitor, long l2) {
        String string;
        PackWriter$MutableState.access$202(this.state, packWriter$PackingPhase);
        switch (packWriter$PackingPhase) {
            case COUNTING: {
                string = JGitText.get().countingObjects;
                break;
            }
            case GETTING_SIZES: {
                string = JGitText.get().searchForSizes;
                break;
            }
            case FINDING_SOURCES: {
                string = JGitText.get().searchForReuse;
                break;
            }
            case COMPRESSING: {
                string = JGitText.get().compressingObjects;
                break;
            }
            case WRITING: {
                string = JGitText.get().writingObjects;
                break;
            }
            case BUILDING_BITMAPS: {
                string = JGitText.get().buildingBitmaps;
                break;
            }
            default: {
                throw new IllegalArgumentException(MessageFormat.format(JGitText.get().illegalPackingPhase, new Object[]{packWriter$PackingPhase}));
            }
        }
        progressMonitor.beginTask(string, (int)l2);
    }

    private void endPhase(ProgressMonitor progressMonitor) {
        progressMonitor.endTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void writePack(ProgressMonitor progressMonitor, ProgressMonitor progressMonitor2, OutputStream outputStream) {
        void var12_17;
        PackStatistics$ObjectType$Accumulator[] packStatistics$ObjectType$AccumulatorArray;
        long l2;
        boolean bl2;
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        if (progressMonitor2 == null) {
            progressMonitor2 = NullProgressMonitor.INSTANCE;
        }
        this.excludeInPacks = null;
        this.excludeInPackLast = null;
        boolean bl3 = bl2 = this.reuseSupport != null && (this.reuseDeltas || this.config.isReuseObjects() || !this.cachedPacks.isEmpty());
        if (progressMonitor instanceof BatchingProgressMonitor) {
            long l3 = 1000L;
            if (bl2 && this.config.isDeltaCompress()) {
                l3 = 500L;
            }
            ((BatchingProgressMonitor)progressMonitor).setDelayStart(l3, TimeUnit.MILLISECONDS);
        }
        if (bl2) {
            this.searchForReuse(progressMonitor);
        }
        if (this.config.isDeltaCompress()) {
            this.searchForDeltas(progressMonitor);
        }
        this.crc32 = new CRC32();
        PackOutputStream packOutputStream = new PackOutputStream(progressMonitor2, this.isIndexDisabled() ? outputStream : new CheckedOutputStream(outputStream, this.crc32), this);
        this.stats.totalObjects = l2 = this.packfileUriConfig == null ? this.getObjectCount() : this.getUnoffloadedObjectCount();
        if (this.callback != null) {
            this.callback.setObjectCount(l2);
        }
        this.beginPhase(PackWriter$PackingPhase.WRITING, progressMonitor2, l2);
        long l4 = System.currentTimeMillis();
        try {
            Object packStatistics$ObjectType$AccumulatorArray2;
            if (this.packfileUriConfig != null) {
                packStatistics$ObjectType$AccumulatorArray = new ArrayList();
                packStatistics$ObjectType$AccumulatorArray2 = PackWriter$PackfileUriConfig.access$100(this.packfileUriConfig);
                PacketLineOut object = PackWriter$PackfileUriConfig.access$300(this.packfileUriConfig);
                object.writeString("packfile-uris\n");
                for (CachedPack cachedPack : this.cachedPacks) {
                    CachedPackUriProvider$PackInfo cachedPackUriProvider$PackInfo = packStatistics$ObjectType$AccumulatorArray2.getInfo(cachedPack, PackWriter$PackfileUriConfig.access$000(this.packfileUriConfig));
                    if (cachedPackUriProvider$PackInfo != null) {
                        object.writeString(cachedPackUriProvider$PackInfo.getHash() + ' ' + cachedPackUriProvider$PackInfo.getUri() + '\n');
                        ++this.stats.offloadedPackfiles;
                        this.stats.offloadedPackfileSize += cachedPackUriProvider$PackInfo.getSize();
                        continue;
                    }
                    packStatistics$ObjectType$AccumulatorArray.add(cachedPack);
                }
                PackWriter$PackfileUriConfig.access$300(this.packfileUriConfig).writeDelim();
                PackWriter$PackfileUriConfig.access$300(this.packfileUriConfig).writeString("packfile\n");
            } else {
                packStatistics$ObjectType$AccumulatorArray = this.cachedPacks;
            }
            packOutputStream.writeFileHeader(2, l2);
            packOutputStream.flush();
            this.writeObjects(packOutputStream);
            if (!this.edgeObjects.isEmpty() || !this.cachedPacks.isEmpty()) {
                void var13_20;
                packStatistics$ObjectType$AccumulatorArray2 = this.stats.objectTypes;
                int n2 = ((PackStatistics$ObjectType$Accumulator[])packStatistics$ObjectType$AccumulatorArray2).length;
                boolean bl4 = false;
                while (var13_20 < n2) {
                    Object object = packStatistics$ObjectType$AccumulatorArray2[var13_20];
                    if (object != null) {
                        this.stats.thinPackBytes += ((PackStatistics$ObjectType$Accumulator)object).bytes;
                    }
                    ++var13_20;
                }
            }
            this.stats.reusedPacks = Collections.unmodifiableList(this.cachedPacks);
            for (CachedPack cachedPack : packStatistics$ObjectType$AccumulatorArray) {
                long l3 = cachedPack.getDeltaCount();
                this.stats.reusedObjects += cachedPack.getObjectCount();
                this.stats.reusedDeltas += l3;
                this.stats.totalDeltas += l3;
                this.reuseSupport.copyPackAsIs(packOutputStream, cachedPack);
            }
            this.writeChecksum(packOutputStream);
            packOutputStream.flush();
        }
        catch (Throwable throwable) {
            this.stats.timeWriting = System.currentTimeMillis() - l4;
            this.stats.depth = this.depth;
            for (PackStatistics$ObjectType$Accumulator packStatistics$ObjectType$Accumulator : this.stats.objectTypes) {
                if (packStatistics$ObjectType$Accumulator == null) continue;
                packStatistics$ObjectType$Accumulator.cntDeltas += packStatistics$ObjectType$Accumulator.reusedDeltas;
                this.stats.reusedObjects += packStatistics$ObjectType$Accumulator.reusedObjects;
                this.stats.reusedDeltas += packStatistics$ObjectType$Accumulator.reusedDeltas;
                this.stats.totalDeltas += packStatistics$ObjectType$Accumulator.cntDeltas;
            }
            throw throwable;
        }
        this.stats.timeWriting = System.currentTimeMillis() - l4;
        this.stats.depth = this.depth;
        packStatistics$ObjectType$AccumulatorArray = this.stats.objectTypes;
        int n3 = packStatistics$ObjectType$AccumulatorArray.length;
        boolean bl5 = false;
        while (var12_17 < n3) {
            PackStatistics$ObjectType$Accumulator packStatistics$ObjectType$Accumulator = packStatistics$ObjectType$AccumulatorArray[var12_17];
            if (packStatistics$ObjectType$Accumulator != null) {
                packStatistics$ObjectType$Accumulator.cntDeltas += packStatistics$ObjectType$Accumulator.reusedDeltas;
                this.stats.reusedObjects += packStatistics$ObjectType$Accumulator.reusedObjects;
                this.stats.reusedDeltas += packStatistics$ObjectType$Accumulator.reusedDeltas;
                this.stats.totalDeltas += packStatistics$ObjectType$Accumulator.cntDeltas;
            }
            ++var12_17;
        }
        this.stats.totalBytes = packOutputStream.length();
        this.reader.close();
        this.endPhase(progressMonitor2);
    }

    public PackStatistics getStatistics() {
        return new PackStatistics(this.stats);
    }

    public State getState() {
        return this.state.snapshot();
    }

    @Override
    public void close() {
        this.reader.close();
        if (this.myDeflater != null) {
            this.myDeflater.end();
            this.myDeflater = null;
        }
        instances.remove(this.selfRef);
    }

    private void searchForReuse(ProgressMonitor progressMonitor) {
        long l2;
        long l3 = 0L;
        l3 += (long)this.objectsLists[1].size();
        l3 += (long)this.objectsLists[2].size();
        l3 += (long)this.objectsLists[3].size();
        this.searchForReuseStartTimeEpoc = l2 = System.currentTimeMillis();
        this.beginPhase(PackWriter$PackingPhase.FINDING_SOURCES, progressMonitor, l3 += (long)this.objectsLists[4].size());
        if (l3 <= 4096L) {
            BlockList blockList = new BlockList((int)l3);
            blockList.addAll(this.objectsLists[4]);
            blockList.addAll(this.objectsLists[1]);
            blockList.addAll(this.objectsLists[2]);
            blockList.addAll(this.objectsLists[3]);
            this.searchForReuse(progressMonitor, blockList);
            if (this.pruneCurrentObjectList) {
                PackWriter.pruneEdgesFromObjectList(this.objectsLists[1]);
                PackWriter.pruneEdgesFromObjectList(this.objectsLists[2]);
                PackWriter.pruneEdgesFromObjectList(this.objectsLists[3]);
                PackWriter.pruneEdgesFromObjectList(this.objectsLists[4]);
            }
        } else {
            this.searchForReuse(progressMonitor, this.objectsLists[4]);
            this.searchForReuse(progressMonitor, this.objectsLists[1]);
            this.searchForReuse(progressMonitor, this.objectsLists[2]);
            this.searchForReuse(progressMonitor, this.objectsLists[3]);
        }
        this.endPhase(progressMonitor);
        this.stats.timeSearchingForReuse = System.currentTimeMillis() - l2;
        if (this.config.isReuseDeltas() && this.config.getCutDeltaChains()) {
            this.cutDeltaChains(this.objectsLists[2]);
            this.cutDeltaChains(this.objectsLists[3]);
        }
    }

    private void searchForReuse(ProgressMonitor progressMonitor, List list) {
        this.pruneCurrentObjectList = false;
        this.reuseSupport.selectObjectRepresentation(this, progressMonitor, list);
        if (this.pruneCurrentObjectList) {
            PackWriter.pruneEdgesFromObjectList(list);
        }
    }

    private void cutDeltaChains(BlockList blockList) {
        int n2 = this.config.getMaxDeltaDepth();
        block0: for (int i2 = blockList.size() - 1; i2 >= 0; --i2) {
            int n3 = 0;
            for (ObjectToPack objectToPack = ((ObjectToPack)blockList.get(i2)).getDeltaBase(); objectToPack != null && n3 >= objectToPack.getChainLength(); objectToPack = objectToPack.getDeltaBase()) {
                objectToPack.setChainLength(++n3);
                if (n3 < n2 || !objectToPack.isDeltaRepresentation()) continue;
                this.reselectNonDelta(objectToPack);
                continue block0;
            }
        }
        if (this.config.isDeltaCompress()) {
            for (ObjectToPack objectToPack : blockList) {
                objectToPack.clearChainLength();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchForDeltas(ProgressMonitor progressMonitor) {
        long l2;
        ObjectToPack[] objectToPackArray = new ObjectToPack[this.objectsLists[2].size() + this.objectsLists[3].size() + this.edgeObjects.size()];
        int n2 = 0;
        n2 = this.findObjectsNeedingDelta(objectToPackArray, n2, 2);
        if ((n2 = this.findObjectsNeedingDelta(objectToPackArray, n2, 3)) == 0) {
            return;
        }
        int n3 = n2;
        for (ObjectToPack objectToPack3 : this.edgeObjects) {
            objectToPack3.setWeight(0);
            objectToPackArray[n2++] = objectToPack3;
        }
        long l3 = System.currentTimeMillis();
        this.beginPhase(PackWriter$PackingPhase.GETTING_SIZES, progressMonitor, n2);
        AsyncObjectSizeQueue asyncObjectSizeQueue = this.reader.getObjectSize(Arrays.asList(objectToPackArray).subList(0, n2), false);
        try {
            l2 = Math.min(this.config.getBigFileThreshold(), Integer.MAX_VALUE);
            while (true) {
                long l4;
                block18: {
                    try {
                        if (asyncObjectSizeQueue.next()) break block18;
                        break;
                    }
                    catch (MissingObjectException missingObjectException) {
                        progressMonitor.update(1);
                        if (this.ignoreMissingUninteresting) {
                            ObjectToPack objectToPack4 = (ObjectToPack)asyncObjectSizeQueue.getCurrent();
                            if (objectToPack4 != null && objectToPack4.isEdge()) {
                                objectToPack4.setDoNotDelta();
                                continue;
                            }
                            objectToPack4 = (ObjectToPack)this.objectsMap.get(missingObjectException.getObjectId());
                            if (objectToPack4 != null && objectToPack4.isEdge()) {
                                objectToPack4.setDoNotDelta();
                                continue;
                            }
                        }
                        throw missingObjectException;
                    }
                }
                ObjectToPack objectToPack5 = (ObjectToPack)asyncObjectSizeQueue.getCurrent();
                if (objectToPack5 == null) {
                    objectToPack5 = (ObjectToPack)this.objectsMap.get(asyncObjectSizeQueue.getObjectId());
                }
                if (16L < (l4 = asyncObjectSizeQueue.getSize()) && l4 < l2) {
                    objectToPack5.setWeight((int)l4);
                } else {
                    objectToPack5.setDoNotDelta();
                }
                progressMonitor.update(1);
            }
        }
        finally {
            asyncObjectSizeQueue.release();
        }
        this.endPhase(progressMonitor);
        this.stats.timeSearchingForSizes = System.currentTimeMillis() - l3;
        Arrays.sort(objectToPackArray, 0, n2, (objectToPack, objectToPack2) -> {
            int n2 = (objectToPack.isDoNotDelta() ? 1 : 0) - (objectToPack2.isDoNotDelta() ? 1 : 0);
            if (n2 != 0) {
                return n2;
            }
            n2 = objectToPack.getType() - objectToPack2.getType();
            if (n2 != 0) {
                return n2;
            }
            n2 = (objectToPack.getPathHash() >>> 1) - (objectToPack2.getPathHash() >>> 1);
            if (n2 != 0) {
                return n2;
            }
            n2 = (objectToPack.getPathHash() & 1) - (objectToPack2.getPathHash() & 1);
            if (n2 != 0) {
                return n2;
            }
            n2 = (objectToPack.isEdge() ? 0 : 1) - (objectToPack2.isEdge() ? 0 : 1);
            if (n2 != 0) {
                return n2;
            }
            return objectToPack2.getWeight() - objectToPack.getWeight();
        });
        while (0 < n2 && objectToPackArray[n2 - 1].isDoNotDelta()) {
            if (!objectToPackArray[n2 - 1].isEdge()) {
                --n3;
            }
            --n2;
        }
        if (n2 == 0) {
            return;
        }
        l2 = System.currentTimeMillis();
        this.searchForDeltas(progressMonitor, objectToPackArray, n2);
        this.stats.deltaSearchNonEdgeObjects = n3;
        this.stats.timeCompressing = System.currentTimeMillis() - l2;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (objectToPackArray[i2].isEdge() || !objectToPackArray[i2].isDeltaRepresentation()) continue;
            ++this.stats.deltasFound;
        }
    }

    private int findObjectsNeedingDelta(ObjectToPack[] objectToPackArray, int n2, int n3) {
        for (ObjectToPack objectToPack : this.objectsLists[n3]) {
            if (objectToPack.isDoNotDelta() || objectToPack.isDeltaRepresentation()) continue;
            objectToPack.setWeight(0);
            objectToPackArray[n2++] = objectToPack;
        }
        return n2;
    }

    private void reselectNonDelta(ObjectToPack objectToPack) {
        objectToPack.clearDeltaBase();
        objectToPack.clearReuseAsIs();
        boolean bl2 = this.reuseDeltas;
        this.reuseDeltas = false;
        this.reuseSupport.selectObjectRepresentation(this, NullProgressMonitor.INSTANCE, Collections.singleton(objectToPack));
        this.reuseDeltas = bl2;
    }

    private void searchForDeltas(ProgressMonitor progressMonitor, ObjectToPack[] objectToPackArray, int n2) {
        int n3 = this.config.getThreads();
        if (n3 == 0) {
            n3 = Runtime.getRuntime().availableProcessors();
        }
        if (n3 <= 1 || n2 <= this.config.getDeltaSearchWindowSize()) {
            this.singleThreadDeltaSearch(progressMonitor, objectToPackArray, n2);
        } else {
            this.parallelDeltaSearch(progressMonitor, objectToPackArray, n2, n3);
        }
    }

    private void singleThreadDeltaSearch(ProgressMonitor progressMonitor, ObjectToPack[] objectToPackArray, int n2) {
        long l2 = 0L;
        for (int i2 = 0; i2 < n2; ++i2) {
            ObjectToPack objectToPack = objectToPackArray[i2];
            l2 += (long)DeltaTask.getAdjustedWeight(objectToPack);
        }
        long l3 = 1L;
        while (0x900000L <= l2 / l3) {
            l3 <<= 10;
        }
        int n3 = (int)(l2 / l3);
        if (l2 % l3 != 0L) {
            ++n3;
        }
        this.beginPhase(PackWriter$PackingPhase.COMPRESSING, progressMonitor, n3);
        new DeltaWindow(this.config, new DeltaCache(this.config), this.reader, progressMonitor, l3, objectToPackArray, 0, n2).search();
        this.endPhase(progressMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parallelDeltaSearch(ProgressMonitor progressMonitor, ObjectToPack[] objectToPackArray, int n2, int n3) {
        Object object;
        List list;
        block23: {
            ThreadSafeDeltaCache threadSafeDeltaCache = new ThreadSafeDeltaCache(this.config);
            ThreadSafeProgressMonitor threadSafeProgressMonitor = new ThreadSafeProgressMonitor(progressMonitor);
            DeltaTask$Block deltaTask$Block = new DeltaTask$Block(n3, this.config, this.reader, threadSafeDeltaCache, threadSafeProgressMonitor, objectToPackArray, 0, n2);
            deltaTask$Block.partitionTasks();
            this.beginPhase(PackWriter$PackingPhase.COMPRESSING, progressMonitor, deltaTask$Block.cost());
            threadSafeProgressMonitor.startWorkers(deltaTask$Block.tasks.size());
            Executor executor = this.config.getExecutor();
            list = Collections.synchronizedList(new ArrayList(n3));
            if (executor instanceof ExecutorService) {
                PackWriter.runTasks((ExecutorService)executor, threadSafeProgressMonitor, deltaTask$Block, list);
            } else {
                if (executor == null) {
                    object = Executors.newFixedThreadPool(n3);
                    Exception exception = null;
                    try {
                        PackWriter.runTasks((ExecutorService)object, threadSafeProgressMonitor, deltaTask$Block, list);
                    }
                    catch (Exception exception2) {
                        exception = exception2;
                    }
                    finally {
                        object.shutdown();
                        try {
                            while (!object.awaitTermination(60L, TimeUnit.SECONDS)) {
                            }
                            break block23;
                        }
                        catch (InterruptedException interruptedException) {
                            if (exception != null) {
                                interruptedException.addSuppressed(exception);
                            }
                            throw new IOException(JGitText.get().packingCancelledDuringObjectsWriting, interruptedException);
                        }
                    }
                }
                for (DeltaTask deltaTask : deltaTask$Block.tasks) {
                    executor.execute(() -> {
                        try {
                            deltaTask.call();
                        }
                        catch (Throwable throwable) {
                            list.add(throwable);
                        }
                    });
                }
                try {
                    threadSafeProgressMonitor.waitForCompletion();
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException(JGitText.get().packingCancelledDuringObjectsWriting, interruptedException);
                }
            }
        }
        if (!list.isEmpty()) {
            object = (Throwable)list.get(0);
            if (object instanceof Error) {
                throw (Error)object;
            }
            if (object instanceof RuntimeException) {
                throw (RuntimeException)object;
            }
            if (object instanceof IOException) {
                throw (IOException)object;
            }
            throw new IOException(((Throwable)object).getMessage(), (Throwable)object);
        }
        this.endPhase(progressMonitor);
    }

    private static void runTasks(ExecutorService executorService, ThreadSafeProgressMonitor threadSafeProgressMonitor, DeltaTask$Block deltaTask$Block, List list) {
        ArrayList arrayList = new ArrayList(deltaTask$Block.tasks.size());
        for (DeltaTask object : deltaTask$Block.tasks) {
            arrayList.add(executorService.submit(object));
        }
        try {
            threadSafeProgressMonitor.waitForCompletion();
            for (Future future : arrayList) {
                try {
                    future.get();
                }
                catch (ExecutionException executionException) {
                    list.add(executionException.getCause());
                }
            }
        }
        catch (InterruptedException interruptedException) {
            for (Future future : arrayList) {
                future.cancel(true);
            }
            throw new IOException(JGitText.get().packingCancelledDuringObjectsWriting, interruptedException);
        }
    }

    private void writeObjects(PackOutputStream packOutputStream) {
        this.writeObjects(packOutputStream, this.objectsLists[1]);
        this.writeObjects(packOutputStream, this.objectsLists[4]);
        this.writeObjects(packOutputStream, this.objectsLists[2]);
        this.writeObjects(packOutputStream, this.objectsLists[3]);
    }

    private void writeObjects(PackOutputStream packOutputStream, List list) {
        if (list.isEmpty()) {
            return;
        }
        this.typeStats = this.stats.objectTypes[((ObjectToPack)list.get(0)).getType()];
        long l2 = packOutputStream.length();
        if (this.reuseSupport != null) {
            this.reuseSupport.writeObjects(packOutputStream, list);
        } else {
            for (ObjectToPack objectToPack : list) {
                packOutputStream.writeObject(objectToPack);
            }
        }
        this.typeStats.bytes += packOutputStream.length() - l2;
        this.typeStats.cntObjects = list.size();
    }

    void writeObject(PackOutputStream packOutputStream, ObjectToPack objectToPack) {
        if (!objectToPack.isWritten()) {
            this.writeObjectImpl(packOutputStream, objectToPack);
        }
    }

    private void writeObjectImpl(PackOutputStream packOutputStream, ObjectToPack objectToPack) {
        if (objectToPack.wantWrite()) {
            this.reselectNonDelta(objectToPack);
        }
        objectToPack.markWantWrite();
        while (objectToPack.isReuseAsIs()) {
            this.writeBase(packOutputStream, objectToPack.getDeltaBase());
            if (objectToPack.isWritten()) {
                return;
            }
            this.crc32.reset();
            objectToPack.setOffset(packOutputStream.length());
            try {
                this.reuseSupport.copyObjectAsIs(packOutputStream, objectToPack, this.reuseValidate);
                packOutputStream.endObject();
                objectToPack.setCRC((int)this.crc32.getValue());
                ++this.typeStats.reusedObjects;
                if (objectToPack.isDeltaRepresentation()) {
                    ++this.typeStats.reusedDeltas;
                    this.typeStats.deltaBytes += packOutputStream.length() - objectToPack.getOffset();
                }
                return;
            }
            catch (StoredObjectRepresentationNotAvailableException storedObjectRepresentationNotAvailableException) {
                if (objectToPack.getOffset() == packOutputStream.length()) {
                    objectToPack.setOffset(0L);
                    objectToPack.clearDeltaBase();
                    objectToPack.clearReuseAsIs();
                    this.reuseSupport.selectObjectRepresentation(this, NullProgressMonitor.INSTANCE, Collections.singleton(objectToPack));
                    continue;
                }
                CorruptObjectException corruptObjectException = new CorruptObjectException(objectToPack, "");
                corruptObjectException.initCause(storedObjectRepresentationNotAvailableException);
                throw corruptObjectException;
            }
        }
        if (objectToPack.isDeltaRepresentation()) {
            this.writeDeltaObjectDeflate(packOutputStream, objectToPack);
        } else {
            this.writeWholeObjectDeflate(packOutputStream, objectToPack);
        }
        packOutputStream.endObject();
        objectToPack.setCRC((int)this.crc32.getValue());
    }

    private void writeBase(PackOutputStream packOutputStream, ObjectToPack objectToPack) {
        if (objectToPack != null && !objectToPack.isWritten() && !objectToPack.isEdge()) {
            this.writeObjectImpl(packOutputStream, objectToPack);
        }
    }

    private void writeWholeObjectDeflate(PackOutputStream packOutputStream, ObjectToPack objectToPack) {
        Deflater deflater = this.deflater();
        ObjectLoader objectLoader = this.reader.open(objectToPack, objectToPack.getType());
        this.crc32.reset();
        objectToPack.setOffset(packOutputStream.length());
        packOutputStream.writeHeader(objectToPack, objectLoader.getSize());
        deflater.reset();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)packOutputStream, deflater);
        objectLoader.copyTo(deflaterOutputStream);
        deflaterOutputStream.finish();
    }

    private void writeDeltaObjectDeflate(PackOutputStream packOutputStream, ObjectToPack objectToPack) {
        Object object;
        this.writeBase(packOutputStream, objectToPack.getDeltaBase());
        this.crc32.reset();
        objectToPack.setOffset(packOutputStream.length());
        DeltaCache$Ref deltaCache$Ref = objectToPack.popCachedDelta();
        if (deltaCache$Ref != null && (object = (byte[])deltaCache$Ref.get()) != null) {
            packOutputStream.writeHeader(objectToPack, objectToPack.getCachedSize());
            packOutputStream.write((byte[])object);
            ++this.typeStats.cntDeltas;
            this.typeStats.deltaBytes += packOutputStream.length() - objectToPack.getOffset();
            return;
        }
        object = this.delta(objectToPack);
        Throwable throwable = null;
        try {
            packOutputStream.writeHeader(objectToPack, ((TemporaryBuffer)object).length());
            Deflater deflater = this.deflater();
            deflater.reset();
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)packOutputStream, deflater);
            ((TemporaryBuffer)object).writeTo(deflaterOutputStream, null);
            deflaterOutputStream.finish();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (object != null) {
                if (throwable != null) {
                    try {
                        ((TemporaryBuffer)object).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    ((TemporaryBuffer)object).close();
                }
            }
        }
        ++this.typeStats.cntDeltas;
        this.typeStats.deltaBytes += packOutputStream.length() - objectToPack.getOffset();
    }

    private TemporaryBuffer$Heap delta(ObjectToPack objectToPack) {
        DeltaIndex deltaIndex = new DeltaIndex(this.buffer(objectToPack.getDeltaBaseId()));
        byte[] byArray = this.buffer(objectToPack);
        TemporaryBuffer$Heap temporaryBuffer$Heap = new TemporaryBuffer$Heap(byArray.length);
        deltaIndex.encode(temporaryBuffer$Heap, byArray);
        return temporaryBuffer$Heap;
    }

    private byte[] buffer(AnyObjectId anyObjectId) {
        return PackWriter.buffer(this.config, this.reader, anyObjectId);
    }

    static byte[] buffer(PackConfig packConfig, ObjectReader objectReader, AnyObjectId anyObjectId) {
        return objectReader.open(anyObjectId).getCachedBytes(packConfig.getBigFileThreshold());
    }

    private Deflater deflater() {
        if (this.myDeflater == null) {
            this.myDeflater = new Deflater(this.config.getCompressionLevel());
        }
        return this.myDeflater;
    }

    private void writeChecksum(PackOutputStream packOutputStream) {
        this.packcsum = packOutputStream.getDigest();
        packOutputStream.write(this.packcsum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findObjectsToPack(@NonNull ProgressMonitor progressMonitor, @NonNull ObjectWalk objectWalk, @NonNull Set set, @NonNull Set set2, @NonNull Set set3) {
        int n2;
        Object object;
        RevCommit revCommit;
        Serializable serializable;
        Iterator iterator;
        AsyncRevObjectQueue asyncRevObjectQueue;
        ArrayList<RevTag> arrayList;
        ArrayList<RevObject> arrayList2;
        ArrayList arrayList3;
        RevFlag revFlag;
        RevFlag revFlag2;
        ArrayList<RevObject> arrayList4;
        long l2;
        block44: {
            l2 = System.currentTimeMillis();
            this.beginPhase(PackWriter$PackingPhase.COUNTING, progressMonitor, 0L);
            this.stats.interestingObjects = Collections.unmodifiableSet(new HashSet(set));
            this.stats.uninterestingObjects = Collections.unmodifiableSet(new HashSet(set2));
            this.excludeFromBitmapSelection = set3;
            boolean bl2 = this.canBuildBitmaps = this.config.isBuildBitmaps() && !this.shallowPack && set2.isEmpty() && this.createBitmaps;
            if (!this.shallowPack && this.useBitmaps && (arrayList4 = this.reader.getBitmapIndex()) != null) {
                BitmapWalker bitmapWalker = new BitmapWalker(objectWalk, (BitmapIndex)((Object)arrayList4), progressMonitor);
                this.findObjectsToPackUsingBitmaps(bitmapWalker, set, set2);
                this.endPhase(progressMonitor);
                this.stats.timeCounting = System.currentTimeMillis() - l2;
                this.stats.bitmapIndexMisses = bitmapWalker.getCountOfBitmapIndexMisses();
                return;
            }
            arrayList4 = new ArrayList(set.size() + set2.size());
            arrayList4.addAll(set);
            arrayList4.addAll(set2);
            revFlag2 = objectWalk.newFlag("include");
            revFlag = objectWalk.newFlag("added");
            objectWalk.carry(revFlag2);
            int n3 = set2.size();
            if (set2.isEmpty()) {
                objectWalk.sort(RevSort.COMMIT_TIME_DESC);
            } else {
                objectWalk.sort(RevSort.TOPO);
                if (this.thin) {
                    objectWalk.sort(RevSort.BOUNDARY, true);
                }
            }
            arrayList3 = new ArrayList(set.size());
            arrayList2 = new ArrayList<RevObject>(n3);
            arrayList = new ArrayList<RevTag>(set.size());
            asyncRevObjectQueue = objectWalk.parseAny(arrayList4, true);
            try {
                while (true) {
                    try {
                        while (true) {
                            if ((iterator = asyncRevObjectQueue.next()) == null) {
                                break block44;
                            }
                            if (set2.contains(iterator)) {
                                arrayList2.add((RevObject)((Object)iterator));
                            }
                            if (!set.contains(iterator)) continue;
                            ((RevObject)((Object)iterator)).add(revFlag2);
                            arrayList3.add(iterator);
                            if (!(iterator instanceof RevTag)) continue;
                            arrayList.add((RevTag)((Object)iterator));
                        }
                    }
                    catch (MissingObjectException missingObjectException) {
                        if (this.ignoreMissingUninteresting && set2.contains(missingObjectException.getObjectId())) continue;
                        throw missingObjectException;
                    }
                    break;
                }
            }
            finally {
                asyncRevObjectQueue.release();
            }
        }
        if (!arrayList.isEmpty()) {
            arrayList4 = new ArrayList<RevObject>(arrayList.size());
            for (RevTag object42 : arrayList) {
                arrayList4.add(object42.getObject());
            }
            asyncRevObjectQueue = objectWalk.parseAny(arrayList4, true);
            try {
                while (asyncRevObjectQueue.next() != null) {
                }
            }
            finally {
                asyncRevObjectQueue.release();
            }
        }
        if (objectWalk instanceof DepthWalk$ObjectWalk) {
            iterator = (DepthWalk$ObjectWalk)objectWalk;
            for (RevObject revObject : arrayList3) {
                ((DepthWalk$ObjectWalk)((Object)iterator)).markRoot(revObject);
            }
            for (RevObject revObject : arrayList2) {
                if (!(revObject instanceof RevCommit)) continue;
                serializable = ((RevCommit)revObject).getTree();
                ((ObjectWalk)((Object)iterator)).markUninteresting((RevObject)serializable);
            }
            if (this.unshallowObjects != null) {
                for (ObjectId objectId : this.unshallowObjects) {
                    ((DepthWalk$ObjectWalk)((Object)iterator)).markUnshallow(objectWalk.parseAny(objectId));
                }
            }
        } else {
            for (RevObject revObject : arrayList3) {
                objectWalk.markStart(revObject);
            }
        }
        for (RevObject revObject : arrayList2) {
            objectWalk.markUninteresting(revObject);
        }
        int n4 = this.config.getDeltaSearchWindowSize();
        HashSet<RevTree> hashSet = new HashSet<RevTree>();
        BlockList blockList = new BlockList();
        serializable = new HashSet();
        while ((revCommit = objectWalk.next()) != null) {
            if (this.exclude(revCommit)) continue;
            if (revCommit.has(RevFlag.UNINTERESTING)) {
                if (hashSet.size() > n4) continue;
                hashSet.add(revCommit.getTree());
                continue;
            }
            blockList.add(revCommit);
            if (revCommit.getParentCount() == 0) {
                serializable.add(revCommit.copy());
            }
            progressMonitor.update(1);
        }
        this.stats.rootCommits = Collections.unmodifiableSet(serializable);
        if (this.shallowPack) {
            object = blockList.iterator();
            while (object.hasNext()) {
                RevCommit revCommit2 = (RevCommit)object.next();
                this.addObject(revCommit2, 0);
            }
        } else {
            int n3 = 0;
            boolean bl3 = false;
            for (Object object2 : blockList) {
                if (!((RevObject)object2).has(revFlag)) {
                    ((RevObject)object2).add(revFlag);
                    this.addObject((RevObject)object2, 0);
                    ++n3;
                }
                for (n2 = 0; n2 < ((RevCommit)object2).getParentCount(); ++n2) {
                    ObjectId objectId = ((RevCommit)object2).getParent(n2);
                    if (((RevObject)objectId).has(revFlag) || ((RevObject)objectId).has(RevFlag.UNINTERESTING) || this.exclude(objectId)) continue;
                    ((RevObject)objectId).add(revFlag);
                    this.addObject((RevObject)objectId, 0);
                    ++n3;
                }
                if (bl3 || 4096 >= n3) continue;
                for (ObjectId objectId : this.tagTargets) {
                    RevObject revObject = objectWalk.lookupOrNull(objectId);
                    if (!(revObject instanceof RevCommit) || !revObject.has(revFlag2) || revObject.has(RevFlag.UNINTERESTING) || revObject.has(revFlag)) continue;
                    revObject.add(revFlag);
                    this.addObject(revObject, 0);
                }
                bl3 = true;
            }
        }
        Object var18_38 = null;
        if (this.thin && !hashSet.isEmpty()) {
            RevObject revObject;
            object = new BaseSearch(progressMonitor, hashSet, this.objectsMap, this.edgeObjects, this.reader);
            while ((revObject = objectWalk.nextObject()) != null) {
                Object object2;
                if (revObject.has(RevFlag.UNINTERESTING) || this.exclude(revObject)) continue;
                int n5 = objectWalk.getPathHashCode();
                object2 = objectWalk.getPathBuffer();
                n2 = objectWalk.getPathLength();
                ((BaseSearch)object).addBase(revObject.getType(), (byte[])object2, n2, n5);
                if (!this.depthSkip(revObject, objectWalk)) {
                    this.filterAndAddObject(revObject, revObject.getType(), n5, set);
                }
                progressMonitor.update(1);
            }
        } else {
            while ((object = objectWalk.nextObject()) != null) {
                if (((RevObject)object).has(RevFlag.UNINTERESTING) || this.exclude((AnyObjectId)object)) continue;
                if (!this.depthSkip((RevObject)object, objectWalk)) {
                    this.filterAndAddObject((AnyObjectId)object, ((RevObject)object).getType(), objectWalk.getPathHashCode(), set);
                }
                progressMonitor.update(1);
            }
        }
        for (CachedPack cachedPack : this.cachedPacks) {
            progressMonitor.update((int)cachedPack.getObjectCount());
        }
        this.endPhase(progressMonitor);
        this.stats.timeCounting = System.currentTimeMillis() - l2;
        this.stats.bitmapIndexMisses = -1L;
    }

    private void findObjectsToPackUsingBitmaps(BitmapWalker bitmapWalker, Set set, Set set2) {
        BitmapIndex$BitmapBuilder bitmapIndex$BitmapBuilder = bitmapWalker.findObjects(set2, null, true);
        BitmapIndex$BitmapBuilder bitmapIndex$BitmapBuilder2 = bitmapWalker.findObjects(set, bitmapIndex$BitmapBuilder, false);
        BitmapIndex$BitmapBuilder bitmapIndex$BitmapBuilder3 = bitmapIndex$BitmapBuilder2.andNot(bitmapIndex$BitmapBuilder);
        if (this.useCachedPacks && this.reuseSupport != null && !this.reuseValidate && (this.excludeInPacks == null || this.excludeInPacks.length == 0)) {
            this.cachedPacks.addAll(this.reuseSupport.getCachedPacksAndUpdate(bitmapIndex$BitmapBuilder3));
        }
        for (BitmapObject bitmapObject : bitmapIndex$BitmapBuilder3) {
            ObjectId objectId = bitmapObject.getObjectId();
            if (this.exclude(objectId)) {
                bitmapIndex$BitmapBuilder3.remove(objectId);
                continue;
            }
            this.filterAndAddObject(objectId, bitmapObject.getType(), 0, set);
        }
        if (this.thin) {
            this.haveObjects = bitmapIndex$BitmapBuilder;
        }
    }

    private static void pruneEdgesFromObjectList(List list) {
        int n2 = list.size();
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            ObjectToPack objectToPack = (ObjectToPack)list.get(i2);
            if (objectToPack.isEdge()) continue;
            if (n3 != i2) {
                list.set(n3, objectToPack);
            }
            ++n3;
        }
        while (n3 < list.size()) {
            list.remove(list.size() - 1);
        }
    }

    public void addObject(RevObject revObject) {
        if (!this.exclude(revObject)) {
            this.addObject(revObject, 0);
        }
    }

    private void addObject(RevObject revObject, int n2) {
        this.addObject(revObject, revObject.getType(), n2);
    }

    private void addObject(AnyObjectId anyObjectId, int n2, int n3) {
        ObjectToPack objectToPack = this.reuseSupport != null ? this.reuseSupport.newObjectToPack(anyObjectId, n2) : new ObjectToPack(anyObjectId, n2);
        objectToPack.setPathHash(n3);
        this.objectsLists[n2].add(objectToPack);
        this.objectsMap.add(objectToPack);
    }

    private boolean depthSkip(@NonNull RevObject revObject, ObjectWalk objectWalk) {
        long l2 = objectWalk.getTreeDepth();
        if (revObject.getType() == 3) {
            ++l2;
        } else {
            ++this.stats.treesTraversed;
        }
        if (this.filterSpec.getTreeDepthLimit() < 0L || l2 <= this.filterSpec.getTreeDepthLimit()) {
            return false;
        }
        objectWalk.skipTree();
        return true;
    }

    private void filterAndAddObject(@NonNull AnyObjectId anyObjectId, int n2, int n3, @NonNull Set set) {
        boolean bl2;
        boolean bl3 = bl2 = !this.filterSpec.allowsType(n2) && !set.contains(anyObjectId) || this.filterSpec.getBlobLimit() >= 0L && n2 == 3 && !set.contains(anyObjectId) && this.reader.getObjectSize(anyObjectId, 3) > this.filterSpec.getBlobLimit();
        if (!bl2) {
            this.addObject(anyObjectId, n2, n3);
        }
    }

    private boolean exclude(AnyObjectId anyObjectId) {
        if (this.excludeInPacks == null) {
            return false;
        }
        if (this.excludeInPackLast.contains(anyObjectId)) {
            return true;
        }
        for (ObjectIdSet objectIdSet : this.excludeInPacks) {
            if (!objectIdSet.contains(anyObjectId)) continue;
            this.excludeInPackLast = objectIdSet;
            return true;
        }
        return false;
    }

    public void select(ObjectToPack objectToPack, StoredObjectRepresentation storedObjectRepresentation) {
        int n2 = storedObjectRepresentation.getFormat();
        if (!this.cachedPacks.isEmpty()) {
            if (objectToPack.isEdge()) {
                return;
            }
            if (n2 == 1 || n2 == 0) {
                for (Object object : this.cachedPacks) {
                    if (!((CachedPack)object).hasObject(objectToPack, storedObjectRepresentation)) continue;
                    objectToPack.setEdge();
                    objectToPack.clearDeltaBase();
                    objectToPack.clearReuseAsIs();
                    this.pruneCurrentObjectList = true;
                    return;
                }
            }
        }
        if (n2 == 0 && this.reuseDeltas && this.reuseDeltaFor(objectToPack)) {
            Object object;
            ObjectId objectId = storedObjectRepresentation.getDeltaBase();
            object = (ObjectToPack)this.objectsMap.get(objectId);
            if (object != null && !((ObjectToPack)object).isEdge()) {
                objectToPack.setDeltaBase((ObjectId)object);
                objectToPack.setReuseAsIs();
            } else if (this.thin && this.have((ObjectToPack)object, objectId)) {
                objectToPack.setDeltaBase(objectId);
                objectToPack.setReuseAsIs();
            } else {
                objectToPack.clearDeltaBase();
                objectToPack.clearReuseAsIs();
            }
        } else if (n2 == 1 && this.config.isReuseObjects()) {
            int n3 = storedObjectRepresentation.getWeight();
            if (objectToPack.isReuseAsIs() && !objectToPack.isDeltaRepresentation() && objectToPack.getWeight() <= n3) {
                return;
            }
            objectToPack.clearDeltaBase();
            objectToPack.setReuseAsIs();
            objectToPack.setWeight(n3);
        } else {
            objectToPack.clearDeltaBase();
            objectToPack.clearReuseAsIs();
        }
        objectToPack.setDeltaAttempted(this.reuseDeltas && storedObjectRepresentation.wasDeltaAttempted());
        objectToPack.select(storedObjectRepresentation);
    }

    private final boolean have(ObjectToPack objectToPack, AnyObjectId anyObjectId) {
        return objectToPack != null && objectToPack.isEdge() || this.haveObjects != null && this.haveObjects.contains(anyObjectId);
    }

    public boolean prepareBitmapIndex(ProgressMonitor progressMonitor) {
        if (!this.canBuildBitmaps || this.getObjectCount() > Integer.MAX_VALUE || !this.cachedPacks.isEmpty()) {
            return false;
        }
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        int n2 = this.objectsLists[1].size();
        List list = this.sortByName();
        this.sortedByName = null;
        this.objectsLists = null;
        this.objectsMap = null;
        this.writeBitmaps = new PackBitmapIndexBuilder(list);
        list = null;
        PackWriterBitmapPreparer packWriterBitmapPreparer = new PackWriterBitmapPreparer(this.reader, this.writeBitmaps, progressMonitor, this.stats.interestingObjects, this.config);
        Collection collection = packWriterBitmapPreparer.selectCommits(n2, this.excludeFromBitmapSelection);
        this.beginPhase(PackWriter$PackingPhase.BUILDING_BITMAPS, progressMonitor, collection.size());
        BitmapWalker bitmapWalker = packWriterBitmapPreparer.newBitmapWalker();
        BitmapCommit bitmapCommit = null;
        for (BitmapCommit bitmapCommit2 : collection) {
            if (!bitmapCommit2.isReuseWalker()) {
                bitmapWalker = packWriterBitmapPreparer.newBitmapWalker();
            }
            BitmapIndex$BitmapBuilder bitmapIndex$BitmapBuilder = bitmapWalker.findObjects(Collections.singleton(bitmapCommit2), null, false);
            if (bitmapCommit != null && bitmapCommit2.isReuseWalker() && !bitmapIndex$BitmapBuilder.contains(bitmapCommit)) {
                throw new IllegalStateException(MessageFormat.format(JGitText.get().bitmapMissingObject, bitmapCommit2.name(), bitmapCommit.name()));
            }
            bitmapCommit = BitmapCommit.copyFrom(bitmapCommit2).build();
            this.writeBitmaps.processBitmapForWrite(bitmapCommit2, bitmapIndex$BitmapBuilder.build(), bitmapCommit2.getFlags());
            bitmapWalker.setPrevCommit(bitmapCommit);
            bitmapWalker.setPrevBitmap(bitmapIndex$BitmapBuilder);
            progressMonitor.update(1);
        }
        this.endPhase(progressMonitor);
        return true;
    }

    private boolean reuseDeltaFor(ObjectToPack objectToPack) {
        int n2 = objectToPack.getType();
        if ((n2 & 2) != 0) {
            return true;
        }
        if (n2 == 1) {
            return this.reuseDeltaCommits;
        }
        return n2 != 4;
    }

    static /* synthetic */ Map access$400() {
        return instances;
    }
}

