/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.pack;

import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.util.NB;

public final class PackOutputStream
extends OutputStream {
    private static final int BYTES_TO_WRITE_BEFORE_CANCEL_CHECK = 131072;
    private final ProgressMonitor writeMonitor;
    private final OutputStream out;
    private final PackWriter packWriter;
    private final MessageDigest md = Constants.newMessageDigest();
    private long count;
    private final byte[] headerBuffer = new byte[32];
    private final byte[] copyBuffer = new byte[65536];
    private long checkCancelAt;
    private boolean ofsDelta;

    public PackOutputStream(ProgressMonitor progressMonitor, OutputStream outputStream, PackWriter packWriter) {
        this.writeMonitor = progressMonitor;
        this.out = outputStream;
        this.packWriter = packWriter;
        this.checkCancelAt = 131072L;
    }

    @Override
    public final void write(int n2) {
        ++this.count;
        this.out.write(n2);
        this.md.update((byte)n2);
    }

    @Override
    public final void write(byte[] byArray, int n2, int n3) {
        while (0 < n3) {
            int n4 = Math.min(n3, 131072);
            this.count += (long)n4;
            if (this.checkCancelAt <= this.count) {
                if (this.writeMonitor.isCancelled()) {
                    throw new IOException(JGitText.get().packingCancelledDuringObjectsWriting);
                }
                this.checkCancelAt = this.count + 131072L;
            }
            this.out.write(byArray, n2, n4);
            this.md.update(byArray, n2, n4);
            n2 += n4;
            n3 -= n4;
        }
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    final void writeFileHeader(int n2, long l2) {
        System.arraycopy(Constants.PACK_SIGNATURE, 0, this.headerBuffer, 0, 4);
        NB.encodeInt32(this.headerBuffer, 4, n2);
        NB.encodeInt32(this.headerBuffer, 8, (int)l2);
        this.write(this.headerBuffer, 0, 12);
        this.ofsDelta = this.packWriter.isDeltaBaseAsOffset();
    }

    public final void writeObject(ObjectToPack objectToPack) {
        this.packWriter.writeObject(this, objectToPack);
    }

    public final void writeHeader(ObjectToPack objectToPack, long l2) {
        ObjectToPack objectToPack2 = objectToPack.getDeltaBase();
        if (objectToPack2 != null && objectToPack2.isWritten() & this.ofsDelta) {
            int n2 = PackOutputStream.objectHeader(l2, 6, this.headerBuffer);
            n2 = PackOutputStream.ofsDelta(this.count - objectToPack2.getOffset(), this.headerBuffer, n2);
            this.write(this.headerBuffer, 0, n2);
        } else if (objectToPack.isDeltaRepresentation()) {
            int n3 = PackOutputStream.objectHeader(l2, 7, this.headerBuffer);
            objectToPack.getDeltaBaseId().copyRawTo(this.headerBuffer, n3);
            this.write(this.headerBuffer, 0, n3 + 20);
        } else {
            int n4 = PackOutputStream.objectHeader(l2, objectToPack.getType(), this.headerBuffer);
            this.write(this.headerBuffer, 0, n4);
        }
    }

    private static final int objectHeader(long l2, int n2, byte[] byArray) {
        byte by = (byte)((long)(n2 << 4) | l2 & 0xFL);
        int n3 = 0;
        l2 >>>= 4;
        while (l2 != 0L) {
            byArray[n3++] = (byte)(0x80 | by);
            by = (byte)(l2 & 0x7FL);
            l2 >>>= 7;
        }
        byArray[n3++] = by;
        return n3;
    }

    private static final int ofsDelta(long l2, byte[] byArray, int n2) {
        int n3 = n2 += PackOutputStream.ofsDeltaVarIntLength(l2);
        byArray[--n3] = (byte)(l2 & 0x7FL);
        while ((l2 >>>= 7) != 0L) {
            byArray[--n3] = (byte)(0x80L | --l2 & 0x7FL);
        }
        return n2;
    }

    private static final int ofsDeltaVarIntLength(long l2) {
        int n2 = 1;
        while ((l2 >>>= 7) != 0L) {
            --l2;
            ++n2;
        }
        return n2;
    }

    public final byte[] getCopyBuffer() {
        return this.copyBuffer;
    }

    void endObject() {
        this.writeMonitor.update(1);
    }

    public final long length() {
        return this.count;
    }

    final byte[] getDigest() {
        return this.md.digest();
    }
}

