/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.pack;

import org.eclipse.jgit.internal.storage.pack.DeltaIndex;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;

final class DeltaWindowEntry {
    DeltaWindowEntry prev;
    DeltaWindowEntry next;
    ObjectToPack object;
    byte[] buffer;
    DeltaIndex index;

    DeltaWindowEntry() {
    }

    final void set(ObjectToPack objectToPack) {
        this.object = objectToPack;
        this.index = null;
        this.buffer = null;
    }

    final int depth() {
        return this.object.getDeltaDepth();
    }

    final int type() {
        return this.object.getType();
    }

    final int size() {
        return this.object.getWeight();
    }

    final boolean empty() {
        return this.object == null;
    }

    final void makeNext(DeltaWindowEntry deltaWindowEntry) {
        deltaWindowEntry.prev.next = deltaWindowEntry.next;
        deltaWindowEntry.next.prev = deltaWindowEntry.prev;
        deltaWindowEntry.next = this.next;
        deltaWindowEntry.prev = this;
        this.next.prev = deltaWindowEntry;
        this.next = deltaWindowEntry;
    }

    static DeltaWindowEntry createWindow(int n2) {
        DeltaWindowEntry deltaWindowEntry;
        DeltaWindowEntry deltaWindowEntry2 = deltaWindowEntry = new DeltaWindowEntry();
        for (int i2 = 0; i2 < n2; ++i2) {
            DeltaWindowEntry deltaWindowEntry3 = new DeltaWindowEntry();
            deltaWindowEntry3.prev = deltaWindowEntry2;
            deltaWindowEntry2.next = deltaWindowEntry3;
            deltaWindowEntry2 = deltaWindowEntry3;
        }
        deltaWindowEntry2.next = deltaWindowEntry;
        deltaWindowEntry.prev = deltaWindowEntry2;
        return deltaWindowEntry;
    }
}

