/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.pack;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.LargeObjectException$ExceedsLimit;
import org.eclipse.jgit.errors.LargeObjectException$OutOfMemory;
import org.eclipse.jgit.internal.storage.pack.DeltaCache;
import org.eclipse.jgit.internal.storage.pack.DeltaIndex;
import org.eclipse.jgit.internal.storage.pack.DeltaTask$Slice;
import org.eclipse.jgit.internal.storage.pack.DeltaWindow$ArrayStream;
import org.eclipse.jgit.internal.storage.pack.DeltaWindow$ZipStream;
import org.eclipse.jgit.internal.storage.pack.DeltaWindowEntry;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.util.TemporaryBuffer$Heap;

final class DeltaWindow {
    private static final boolean NEXT_RES = false;
    private static final boolean NEXT_SRC = true;
    private final PackConfig config;
    private final DeltaCache deltaCache;
    private final ObjectReader reader;
    private final ProgressMonitor monitor;
    private final long bytesPerUnit;
    private long bytesProcessed;
    private final long maxMemory;
    private final int maxDepth;
    private final ObjectToPack[] toSearch;
    private int cur;
    private int end;
    private long loaded;
    private DeltaWindowEntry res;
    private DeltaWindowEntry bestBase;
    private int deltaLen;
    private Object deltaBuf;
    private Deflater deflater;

    DeltaWindow(PackConfig packConfig, DeltaCache deltaCache, ObjectReader objectReader, ProgressMonitor progressMonitor, long l2, ObjectToPack[] objectToPackArray, int n2, int n3) {
        this.config = packConfig;
        this.deltaCache = deltaCache;
        this.reader = objectReader;
        this.monitor = progressMonitor;
        this.bytesPerUnit = l2;
        this.toSearch = objectToPackArray;
        this.cur = n2;
        this.end = n3;
        this.maxMemory = Math.max(0L, this.config.getDeltaSearchMemoryLimit());
        this.maxDepth = this.config.getMaxDeltaDepth();
        this.res = DeltaWindowEntry.createWindow(this.config.getDeltaSearchWindowSize());
    }

    synchronized DeltaTask$Slice remaining() {
        int n2;
        int n3 = this.end;
        int n4 = n3 - this.cur >>> 1;
        if (0 == n4) {
            return null;
        }
        int n5 = n3 - n4;
        int n6 = this.toSearch[n5].getPathHash();
        for (n2 = n5 + 1; n2 < n3; ++n2) {
            if (n6 == this.toSearch[n2].getPathHash()) continue;
            return new DeltaTask$Slice(n2, n3);
        }
        if (n6 != this.toSearch[this.cur].getPathHash()) {
            for (n2 = n5 - 1; this.cur < n2; --n2) {
                if (n6 == this.toSearch[n2].getPathHash()) continue;
                return new DeltaTask$Slice(n2 + 1, n3);
            }
        }
        return null;
    }

    synchronized boolean tryStealWork(DeltaTask$Slice deltaTask$Slice) {
        if (deltaTask$Slice.beginIndex <= this.cur || this.end <= deltaTask$Slice.beginIndex) {
            return false;
        }
        this.end = deltaTask$Slice.beginIndex;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void search() {
        try {
            while (true) {
                ObjectToPack objectToPack;
                DeltaWindow deltaWindow = this;
                synchronized (deltaWindow) {
                    if (this.end <= this.cur) {
                        break;
                    }
                    objectToPack = this.toSearch[this.cur++];
                }
                if (this.maxMemory != 0L) {
                    this.clear(this.res);
                    long l2 = DeltaWindow.estimateSize(objectToPack);
                    DeltaWindowEntry deltaWindowEntry = this.res.next;
                    while (this.maxMemory < this.loaded + l2 && deltaWindowEntry != this.res) {
                        this.clear(deltaWindowEntry);
                        deltaWindowEntry = deltaWindowEntry.next;
                    }
                }
                this.res.set(objectToPack);
                this.clearWindowOnTypeSwitch();
                if (this.res.object.isEdge() || this.res.object.doNotAttemptDelta()) {
                    this.keepInWindow();
                    continue;
                }
                if (this.bytesPerUnit <= (this.bytesProcessed += (long)objectToPack.getWeight())) {
                    int n2 = (int)(this.bytesProcessed / this.bytesPerUnit);
                    this.monitor.update(n2);
                    this.bytesProcessed -= (long)n2 * this.bytesPerUnit;
                }
                this.searchInWindow();
            }
        }
        finally {
            if (this.deflater != null) {
                this.deflater.end();
            }
        }
    }

    private static long estimateSize(ObjectToPack objectToPack) {
        return DeltaIndex.estimateIndexSize(objectToPack.getWeight());
    }

    private static long estimateIndexSize(DeltaWindowEntry deltaWindowEntry) {
        if (deltaWindowEntry.buffer == null) {
            return DeltaWindow.estimateSize(deltaWindowEntry.object);
        }
        int n2 = deltaWindowEntry.buffer.length;
        return DeltaIndex.estimateIndexSize(n2) - (long)n2;
    }

    private void clearWindowOnTypeSwitch() {
        DeltaWindowEntry deltaWindowEntry = this.res.prev;
        if (!deltaWindowEntry.empty() && this.res.type() != deltaWindowEntry.type()) {
            while (deltaWindowEntry != this.res) {
                this.clear(deltaWindowEntry);
                deltaWindowEntry = deltaWindowEntry.prev;
            }
        }
    }

    private void clear(DeltaWindowEntry deltaWindowEntry) {
        if (deltaWindowEntry.index != null) {
            this.loaded -= deltaWindowEntry.index.getIndexSize();
        } else if (deltaWindowEntry.buffer != null) {
            this.loaded -= (long)deltaWindowEntry.buffer.length;
        }
        deltaWindowEntry.set(null);
    }

    private void searchInWindow() {
        Object object = this.res.prev;
        while (object != this.res && !((DeltaWindowEntry)object).empty()) {
            if (!this.delta((DeltaWindowEntry)object)) {
                this.bestBase = null;
                this.deltaBuf = null;
                return;
            }
            object = ((DeltaWindowEntry)object).prev;
        }
        if (this.bestBase == null) {
            this.keepInWindow();
            return;
        }
        object = this.bestBase.object;
        ObjectToPack objectToPack = this.res.object;
        if (((ObjectToPack)object).isEdge()) {
            objectToPack.setDeltaBase(((AnyObjectId)object).copy());
        } else {
            objectToPack.setDeltaBase((ObjectId)object);
        }
        int n2 = ((ObjectToPack)object).getDeltaDepth() + 1;
        objectToPack.setDeltaDepth(n2);
        objectToPack.clearReuseAsIs();
        this.cacheDelta((ObjectToPack)object, objectToPack);
        if (n2 < this.maxDepth) {
            this.res.makeNext(this.bestBase);
            this.res = this.bestBase.next;
        }
        this.bestBase = null;
        this.deltaBuf = null;
    }

    private boolean delta(DeltaWindowEntry deltaWindowEntry) {
        byte[] byArray;
        DeltaIndex deltaIndex;
        if (this.res.size() < deltaWindowEntry.size() >>> 4) {
            return true;
        }
        int n2 = this.deltaSizeLimit(deltaWindowEntry);
        if (n2 <= 8) {
            return true;
        }
        if (this.res.size() - deltaWindowEntry.size() > n2) {
            return true;
        }
        try {
            deltaIndex = this.index(deltaWindowEntry);
        }
        catch (LargeObjectException largeObjectException) {
            return true;
        }
        catch (IOException iOException) {
            if (deltaWindowEntry.object.isEdge()) {
                return true;
            }
            throw iOException;
        }
        try {
            byArray = this.buffer(this.res);
        }
        catch (LargeObjectException largeObjectException) {
            return false;
        }
        try {
            OutputStream outputStream;
            OutputStream outputStream2 = outputStream = n2 <= 8192 ? new DeltaWindow$ArrayStream(n2) : new TemporaryBuffer$Heap(n2);
            if (deltaIndex.encode(outputStream, byArray, n2)) {
                this.selectDeltaBase(deltaWindowEntry, outputStream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    private void selectDeltaBase(DeltaWindowEntry deltaWindowEntry, OutputStream outputStream) {
        this.bestBase = deltaWindowEntry;
        if (outputStream instanceof DeltaWindow$ArrayStream) {
            DeltaWindow$ArrayStream deltaWindow$ArrayStream = (DeltaWindow$ArrayStream)outputStream;
            this.deltaBuf = deltaWindow$ArrayStream.buf;
            this.deltaLen = deltaWindow$ArrayStream.cnt;
        } else {
            TemporaryBuffer$Heap temporaryBuffer$Heap = (TemporaryBuffer$Heap)outputStream;
            this.deltaBuf = temporaryBuffer$Heap;
            this.deltaLen = (int)temporaryBuffer$Heap.length();
        }
    }

    private int deltaSizeLimit(DeltaWindowEntry deltaWindowEntry) {
        if (this.bestBase == null) {
            int n2 = this.res.size() >>> 1;
            return n2 * (this.maxDepth - deltaWindowEntry.depth()) / this.maxDepth;
        }
        int n3 = this.bestBase.depth();
        int n4 = this.deltaLen;
        return n4 * (this.maxDepth - deltaWindowEntry.depth()) / (this.maxDepth - n3);
    }

    private void cacheDelta(ObjectToPack objectToPack, ObjectToPack objectToPack2) {
        if (this.deltaCache.canCache(this.deltaLen, objectToPack, objectToPack2)) {
            try {
                byte[] byArray = new byte[DeltaWindow.deflateBound(this.deltaLen)];
                DeltaWindow$ZipStream deltaWindow$ZipStream = new DeltaWindow$ZipStream(this.deflater(), byArray);
                if (this.deltaBuf instanceof byte[]) {
                    deltaWindow$ZipStream.write((byte[])this.deltaBuf, 0, this.deltaLen);
                } else {
                    ((TemporaryBuffer$Heap)this.deltaBuf).writeTo(deltaWindow$ZipStream, null);
                }
                this.deltaBuf = null;
                int n2 = deltaWindow$ZipStream.finish();
                objectToPack2.setCachedDelta(this.deltaCache.cache(byArray, n2, this.deltaLen));
                objectToPack2.setCachedSize(this.deltaLen);
            }
            catch (IOException | OutOfMemoryError throwable) {
                this.deltaCache.credit(this.deltaLen);
            }
        }
    }

    private static int deflateBound(int n2) {
        return n2 + (n2 + 7 >> 3) + (n2 + 63 >> 6) + 11;
    }

    private void keepInWindow() {
        this.res = this.res.next;
    }

    private DeltaIndex index(DeltaWindowEntry deltaWindowEntry) {
        DeltaIndex deltaIndex = deltaWindowEntry.index;
        if (deltaIndex == null) {
            this.checkLoadable(deltaWindowEntry, DeltaWindow.estimateIndexSize(deltaWindowEntry));
            try {
                deltaIndex = new DeltaIndex(this.buffer(deltaWindowEntry));
            }
            catch (OutOfMemoryError outOfMemoryError) {
                LargeObjectException$OutOfMemory largeObjectException$OutOfMemory = new LargeObjectException$OutOfMemory(outOfMemoryError);
                largeObjectException$OutOfMemory.setObjectId(deltaWindowEntry.object);
                throw largeObjectException$OutOfMemory;
            }
            if (this.maxMemory != 0L) {
                this.loaded += deltaIndex.getIndexSize() - deltaIndex.getSourceSize();
            }
            deltaWindowEntry.index = deltaIndex;
        }
        return deltaIndex;
    }

    private byte[] buffer(DeltaWindowEntry deltaWindowEntry) {
        byte[] byArray = deltaWindowEntry.buffer;
        if (byArray == null) {
            this.checkLoadable(deltaWindowEntry, deltaWindowEntry.size());
            byArray = PackWriter.buffer(this.config, this.reader, deltaWindowEntry.object);
            if (this.maxMemory != 0L) {
                this.loaded += (long)byArray.length;
            }
            deltaWindowEntry.buffer = byArray;
        }
        return byArray;
    }

    private void checkLoadable(DeltaWindowEntry deltaWindowEntry, long l2) {
        if (this.maxMemory == 0L) {
            return;
        }
        DeltaWindowEntry deltaWindowEntry2 = this.res.next;
        while (this.maxMemory < this.loaded + l2) {
            this.clear(deltaWindowEntry2);
            if (deltaWindowEntry2 == deltaWindowEntry) {
                throw new LargeObjectException$ExceedsLimit(this.maxMemory, this.loaded + l2);
            }
            deltaWindowEntry2 = deltaWindowEntry2.next;
        }
    }

    private Deflater deflater() {
        if (this.deflater == null) {
            this.deflater = new Deflater(this.config.getCompressionLevel());
        } else {
            this.deflater.reset();
        }
        return this.deflater;
    }
}

