/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.pack;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;

final class DeltaWindow$ZipStream
extends OutputStream {
    private final Deflater deflater;
    private final byte[] zbuf;
    private int outPtr;

    DeltaWindow$ZipStream(Deflater deflater, byte[] byArray) {
        this.deflater = deflater;
        this.zbuf = byArray;
    }

    int finish() {
        this.deflater.finish();
        while (true) {
            if (this.outPtr == this.zbuf.length) {
                throw new EOFException();
            }
            int n2 = this.deflater.deflate(this.zbuf, this.outPtr, this.zbuf.length - this.outPtr);
            if (n2 == 0) {
                if (this.deflater.finished()) {
                    return this.outPtr;
                }
                throw new IOException();
            }
            this.outPtr += n2;
        }
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        this.deflater.setInput(byArray, n2, n3);
        while (true) {
            if (this.outPtr == this.zbuf.length) {
                throw new EOFException();
            }
            int n4 = this.deflater.deflate(this.zbuf, this.outPtr, this.zbuf.length - this.outPtr);
            if (n4 == 0) {
                if (this.deflater.needsInput()) break;
                throw new IOException();
            }
            this.outPtr += n4;
        }
    }

    @Override
    public void write(int n2) {
        throw new UnsupportedOperationException();
    }
}

