/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.pack;

import java.util.LinkedList;
import java.util.concurrent.Callable;
import org.eclipse.jgit.internal.storage.pack.DeltaTask$Block;
import org.eclipse.jgit.internal.storage.pack.DeltaTask$Slice;
import org.eclipse.jgit.internal.storage.pack.DeltaWindow;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.lib.ObjectReader;

final class DeltaTask
implements Callable {
    static final long MAX_METER = 0x900000L;
    private final DeltaTask$Block block;
    final LinkedList slices;
    private ObjectReader or;
    private DeltaWindow dw;

    static int getAdjustedWeight(ObjectToPack objectToPack) {
        if (objectToPack.isEdge() || objectToPack.doNotAttemptDelta()) {
            return 0;
        }
        return objectToPack.getWeight();
    }

    DeltaTask(DeltaTask$Block deltaTask$Block) {
        this.block = deltaTask$Block;
        this.slices = new LinkedList();
    }

    void add(DeltaTask$Slice deltaTask$Slice) {
        if (!this.slices.isEmpty()) {
            DeltaTask$Slice deltaTask$Slice2 = (DeltaTask$Slice)this.slices.getLast();
            if (deltaTask$Slice2.endIndex == deltaTask$Slice.beginIndex) {
                this.slices.removeLast();
                this.slices.add(new DeltaTask$Slice(deltaTask$Slice2.beginIndex, deltaTask$Slice.endIndex));
                return;
            }
        }
        this.slices.add(deltaTask$Slice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call() {
        this.or = this.block.templateReader.newReader();
        try {
            DeltaWindow deltaWindow;
            while (true) {
                DeltaTask deltaTask = this;
                synchronized (deltaTask) {
                    if (this.slices.isEmpty()) {
                        break;
                    }
                    deltaWindow = this.initWindow((DeltaTask$Slice)this.slices.removeFirst());
                }
                this.runWindow(deltaWindow);
            }
            while ((deltaWindow = this.block.stealWork(this)) != null) {
                this.runWindow(deltaWindow);
            }
        }
        finally {
            this.block.pm.endWorker();
            this.or.close();
            this.or = null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DeltaWindow initWindow(DeltaTask$Slice deltaTask$Slice) {
        DeltaWindow deltaWindow = new DeltaWindow(this.block.config, this.block.dc, this.or, this.block.pm, this.block.bytesPerUnit, this.block.list, deltaTask$Slice.beginIndex, deltaTask$Slice.endIndex);
        DeltaTask deltaTask = this;
        synchronized (deltaTask) {
            this.dw = deltaWindow;
        }
        return deltaWindow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWindow(DeltaWindow deltaWindow) {
        try {
            deltaWindow.search();
        }
        finally {
            DeltaTask deltaTask = this;
            synchronized (deltaTask) {
                this.dw = null;
            }
        }
    }

    synchronized DeltaTask$Slice remaining() {
        if (!this.slices.isEmpty()) {
            return (DeltaTask$Slice)this.slices.getLast();
        }
        DeltaWindow deltaWindow = this.dw;
        return deltaWindow != null ? deltaWindow.remaining() : null;
    }

    synchronized boolean tryStealWork(DeltaTask$Slice deltaTask$Slice) {
        if (!this.slices.isEmpty() && ((DeltaTask$Slice)this.slices.getLast()).beginIndex == deltaTask$Slice.beginIndex) {
            this.slices.removeLast();
            return true;
        }
        DeltaWindow deltaWindow = this.dw;
        return deltaWindow != null ? deltaWindow.tryStealWork(deltaTask$Slice) : false;
    }
}

