/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.pack;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jgit.internal.storage.pack.DeltaCache;
import org.eclipse.jgit.internal.storage.pack.DeltaTask;
import org.eclipse.jgit.internal.storage.pack.DeltaTask$Slice;
import org.eclipse.jgit.internal.storage.pack.DeltaTask$WeightedPath;
import org.eclipse.jgit.internal.storage.pack.DeltaWindow;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ThreadSafeProgressMonitor;
import org.eclipse.jgit.storage.pack.PackConfig;

final class DeltaTask$Block {
    private static final int MIN_TOP_PATH = 0x3200000;
    final List tasks;
    final int threads;
    final PackConfig config;
    final ObjectReader templateReader;
    final DeltaCache dc;
    final ThreadSafeProgressMonitor pm;
    final ObjectToPack[] list;
    final int beginIndex;
    final int endIndex;
    private long totalWeight;
    long bytesPerUnit;

    DeltaTask$Block(int n2, PackConfig packConfig, ObjectReader objectReader, DeltaCache deltaCache, ThreadSafeProgressMonitor threadSafeProgressMonitor, ObjectToPack[] objectToPackArray, int n3, int n4) {
        this.tasks = new ArrayList(n2);
        this.threads = n2;
        this.config = packConfig;
        this.templateReader = objectReader;
        this.dc = deltaCache;
        this.pm = threadSafeProgressMonitor;
        this.list = objectToPackArray;
        this.beginIndex = n3;
        this.endIndex = n4;
    }

    int cost() {
        int n2 = (int)(this.totalWeight / this.bytesPerUnit);
        if (this.totalWeight % this.bytesPerUnit != 0L) {
            ++n2;
        }
        return n2;
    }

    synchronized DeltaWindow stealWork(DeltaTask deltaTask) {
        DeltaTask$Slice deltaTask$Slice;
        DeltaTask deltaTask2;
        do {
            deltaTask2 = null;
            deltaTask$Slice = null;
            int n2 = 0;
            for (DeltaTask deltaTask3 : this.tasks) {
                DeltaTask$Slice deltaTask$Slice2 = deltaTask3.remaining();
                if (deltaTask$Slice2 == null || n2 >= deltaTask$Slice2.size()) continue;
                deltaTask2 = deltaTask3;
                deltaTask$Slice = deltaTask$Slice2;
                n2 = deltaTask$Slice2.size();
            }
            if (deltaTask2 != null) continue;
            return null;
        } while (!deltaTask2.tryStealWork(deltaTask$Slice));
        return deltaTask.initWindow(deltaTask$Slice);
    }

    void partitionTasks() {
        DeltaTask deltaTask;
        ArrayList arrayList = this.computeTopPaths();
        Iterator iterator = arrayList.iterator();
        int n2 = 0;
        long l2 = Math.max(this.totalWeight / (long)this.threads, 1L);
        int n3 = this.beginIndex;
        while (n3 < this.endIndex) {
            deltaTask = new DeltaTask(this);
            long l3 = 0L;
            if (iterator.hasNext()) {
                DeltaTask$WeightedPath deltaTask$WeightedPath = (DeltaTask$WeightedPath)iterator.next();
                l3 += deltaTask$WeightedPath.weight;
                deltaTask.add(deltaTask$WeightedPath.slice);
            }
            int n4 = n3;
            while (l3 < l2 && n3 < this.endIndex) {
                if (n2 < arrayList.size() && n3 == ((DeltaTask$WeightedPath)arrayList.get((int)n2)).slice.beginIndex) {
                    if (n4 < n3) {
                        deltaTask.add(new DeltaTask$Slice(n4, n3));
                    }
                    n4 = n3 = ((DeltaTask$WeightedPath)arrayList.get((int)n2++)).slice.endIndex;
                    continue;
                }
                l3 += (long)DeltaTask.getAdjustedWeight(this.list[n3++]);
            }
            if (n4 < n3) {
                int n5 = this.list[n3 - 1].getPathHash();
                while (n3 < this.endIndex && n5 == this.list[n3].getPathHash()) {
                    ++n3;
                }
                deltaTask.add(new DeltaTask$Slice(n4, n3));
            }
            if (deltaTask.slices.isEmpty()) continue;
            this.tasks.add(deltaTask);
        }
        while (iterator.hasNext()) {
            DeltaTask$WeightedPath deltaTask$WeightedPath = (DeltaTask$WeightedPath)iterator.next();
            deltaTask = new DeltaTask(this);
            deltaTask.add(deltaTask$WeightedPath.slice);
            this.tasks.add(deltaTask);
        }
        arrayList = null;
    }

    private ArrayList computeTopPaths() {
        long l2;
        ArrayList<DeltaTask$WeightedPath> arrayList = new ArrayList<DeltaTask$WeightedPath>(this.threads);
        int n2 = this.beginIndex;
        int n3 = this.list[n2].getPathHash();
        this.totalWeight = l2 = (long)DeltaTask.getAdjustedWeight(this.list[n2]);
        for (int i2 = n2 + 1; i2 < this.endIndex; ++i2) {
            ObjectToPack objectToPack = this.list[i2];
            if (n3 != objectToPack.getPathHash()) {
                if (0x3200000L < l2) {
                    if (arrayList.size() < this.threads) {
                        DeltaTask$Slice deltaTask$Slice = new DeltaTask$Slice(n2, i2);
                        arrayList.add(new DeltaTask$WeightedPath(l2, deltaTask$Slice));
                        if (arrayList.size() == this.threads) {
                            Collections.sort(arrayList);
                        }
                    } else if (((DeltaTask$WeightedPath)arrayList.get((int)0)).weight < l2) {
                        DeltaTask$Slice deltaTask$Slice = new DeltaTask$Slice(n2, i2);
                        DeltaTask$WeightedPath deltaTask$WeightedPath3 = new DeltaTask$WeightedPath(l2, deltaTask$Slice);
                        arrayList.set(0, deltaTask$WeightedPath3);
                        if (deltaTask$WeightedPath3.compareTo((DeltaTask$WeightedPath)arrayList.get(1)) > 0) {
                            Collections.sort(arrayList);
                        }
                    }
                }
                n2 = i2;
                n3 = objectToPack.getPathHash();
                l2 = 0L;
            }
            int n4 = DeltaTask.getAdjustedWeight(objectToPack);
            l2 += (long)n4;
            this.totalWeight += (long)n4;
        }
        Collections.sort(arrayList, (deltaTask$WeightedPath, deltaTask$WeightedPath2) -> deltaTask$WeightedPath.slice.beginIndex - deltaTask$WeightedPath2.slice.beginIndex);
        this.bytesPerUnit = 1L;
        while (0x900000L <= this.totalWeight / this.bytesPerUnit) {
            this.bytesPerUnit <<= 10;
        }
        return arrayList;
    }
}

