/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.pack;

import org.eclipse.jgit.internal.storage.pack.DeltaIndex;

class DeltaIndexScanner {
    final int[] table;
    final long[] entries;
    final int[] next;
    final int tableMask;
    private int entryCnt;

    DeltaIndexScanner(byte[] byArray, int n2) {
        n2 -= n2 % 16;
        int n3 = n2 / 16;
        if (n3 < 1) {
            this.table = new int[0];
            this.tableMask = 0;
            this.entries = new long[0];
            this.next = new int[0];
        } else {
            this.table = new int[DeltaIndexScanner.tableSize(n3)];
            this.tableMask = this.table.length - 1;
            this.entries = new long[1 + n3];
            this.next = new int[this.entries.length];
            this.scan(byArray, n2);
        }
    }

    private void scan(byte[] byArray, int n2) {
        int n3 = 0;
        int n4 = n2 - 16;
        do {
            int n5;
            int n6;
            int n7;
            if ((n7 = this.table[n6 = (n5 = DeltaIndex.hashBlock(byArray, n4)) & this.tableMask]) != 0 && n3 == n5) {
                this.entries[n7] = (long)n5 << 32 | (long)n4;
            } else {
                int n8 = ++this.entryCnt;
                this.entries[n8] = (long)n5 << 32 | (long)n4;
                this.next[n8] = n7;
                this.table[n6] = n8;
            }
            n3 = n5;
        } while (0 <= (n4 -= 16));
    }

    private static int tableSize(int n2) {
        int n3 = 32 - Integer.numberOfLeadingZeros(n2);
        int n4 = 1 << n3 - 1;
        if (n4 < n2) {
            n4 <<= 1;
        }
        return n4;
    }
}

