/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.pack;

import java.io.OutputStream;
import org.eclipse.jgit.lib.Constants;

public class DeltaEncoder {
    private static final int MAX_V2_COPY = 65536;
    private static final int MAX_COPY_CMD_SIZE = 8;
    private static final int MAX_INSERT_DATA_SIZE = 127;
    private final OutputStream out;
    private final byte[] buf = new byte[32];
    private final int limit;
    private int size;

    public DeltaEncoder(OutputStream outputStream, long l2, long l3) {
        this(outputStream, l2, l3, 0);
    }

    public DeltaEncoder(OutputStream outputStream, long l2, long l3, int n2) {
        this.out = outputStream;
        this.limit = n2;
        this.writeVarint(l2);
        this.writeVarint(l3);
    }

    private void writeVarint(long l2) {
        int n2 = 0;
        while (l2 >= 128L) {
            this.buf[n2++] = (byte)(0x80 | (int)l2 & 0x7F);
            l2 >>>= 7;
        }
        this.buf[n2++] = (byte)((int)l2 & 0x7F);
        this.size += n2;
        if (this.limit == 0 || this.size < this.limit) {
            this.out.write(this.buf, 0, n2);
        }
    }

    public int getSize() {
        return this.size;
    }

    public boolean insert(String string) {
        return this.insert(Constants.encode(string));
    }

    public boolean insert(byte[] byArray) {
        return this.insert(byArray, 0, byArray.length);
    }

    public boolean insert(byte[] byArray, int n2, int n3) {
        int n4;
        if (n3 <= 0) {
            return true;
        }
        if (this.limit != 0) {
            n4 = n3 / 127;
            if (n3 % 127 != 0) {
                ++n4;
            }
            if (this.limit < this.size + n4 + n3) {
                return false;
            }
        }
        do {
            n4 = Math.min(127, n3);
            this.out.write((byte)n4);
            this.out.write(byArray, n2, n4);
            n2 += n4;
            this.size += 1 + n4;
        } while (0 < (n3 -= n4));
        return true;
    }

    public boolean copy(long l2, int n2) {
        if (n2 == 0) {
            return true;
        }
        int n3 = 0;
        while (65536 < n2) {
            n3 = this.encodeCopy(n3, l2, 65536);
            l2 += 65536L;
            n2 -= 65536;
            if (this.buf.length >= n3 + 8) continue;
            if (this.limit != 0 && this.limit < this.size + n3) {
                return false;
            }
            this.out.write(this.buf, 0, n3);
            this.size += n3;
            n3 = 0;
        }
        n3 = this.encodeCopy(n3, l2, n2);
        if (this.limit != 0 && this.limit < this.size + n3) {
            return false;
        }
        this.out.write(this.buf, 0, n3);
        this.size += n3;
        return true;
    }

    private int encodeCopy(int n2, long l2, int n3) {
        int n4 = 128;
        int n5 = n2++;
        byte by = (byte)(l2 & 0xFFL);
        if (by != 0) {
            n4 |= 1;
            this.buf[n2++] = by;
        }
        if ((by = (byte)(l2 >>> 8 & 0xFFL)) != 0) {
            n4 |= 2;
            this.buf[n2++] = by;
        }
        if ((by = (byte)(l2 >>> 16 & 0xFFL)) != 0) {
            n4 |= 4;
            this.buf[n2++] = by;
        }
        if ((by = (byte)(l2 >>> 24 & 0xFFL)) != 0) {
            n4 |= 8;
            this.buf[n2++] = by;
        }
        if (n3 != 65536) {
            by = (byte)(n3 & 0xFF);
            if (by != 0) {
                n4 |= 0x10;
                this.buf[n2++] = by;
            }
            if ((by = (byte)(n3 >>> 8 & 0xFF)) != 0) {
                n4 |= 0x20;
                this.buf[n2++] = by;
            }
            if ((by = (byte)(n3 >>> 16 & 0xFF)) != 0) {
                n4 |= 0x40;
                this.buf[n2++] = by;
            }
        }
        this.buf[n5] = (byte)n4;
        return n2;
    }
}

