/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.pack;

import java.lang.ref.ReferenceQueue;
import org.eclipse.jgit.internal.storage.pack.DeltaCache$Ref;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.storage.pack.PackConfig;

class DeltaCache {
    private final long size;
    private final int entryLimit;
    private final ReferenceQueue queue;
    private long used;

    DeltaCache(PackConfig packConfig) {
        this.size = packConfig.getDeltaCacheSize();
        this.entryLimit = packConfig.getDeltaCacheLimit();
        this.queue = new ReferenceQueue();
    }

    boolean canCache(int n2, ObjectToPack objectToPack, ObjectToPack objectToPack2) {
        if (0L < this.size && this.size < this.used + (long)n2) {
            this.checkForGarbageCollectedObjects();
            if (0L < this.size && this.size < this.used + (long)n2) {
                return false;
            }
        }
        if (n2 < this.entryLimit) {
            this.used += (long)n2;
            return true;
        }
        if (n2 >> 10 < (objectToPack.getWeight() >> 20) + (objectToPack2.getWeight() >> 21)) {
            this.used += (long)n2;
            return true;
        }
        return false;
    }

    void credit(int n2) {
        this.used -= (long)n2;
    }

    DeltaCache$Ref cache(byte[] byArray, int n2, int n3) {
        if (n3 != (byArray = this.resize(byArray, n2)).length) {
            this.used -= (long)n3;
            this.used += (long)byArray.length;
        }
        return new DeltaCache$Ref(byArray, this.queue);
    }

    byte[] resize(byte[] byArray, int n2) {
        if (byArray.length != n2) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            byArray = byArray2;
        }
        return byArray;
    }

    private void checkForGarbageCollectedObjects() {
        DeltaCache$Ref deltaCache$Ref;
        while ((deltaCache$Ref = (DeltaCache$Ref)this.queue.poll()) != null) {
            this.used -= (long)deltaCache$Ref.cost;
        }
    }
}

