/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.pack;

import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.util.QuotedString;
import org.eclipse.jgit.util.RawParseUtils;

public class BinaryDelta {
    public static long getBaseSize(byte[] byArray) {
        int n2;
        int n3 = 0;
        long l2 = 0L;
        int n4 = 0;
        do {
            n2 = byArray[n3++] & 0xFF;
            l2 |= (long)(n2 & 0x7F) << n4;
            n4 += 7;
        } while ((n2 & 0x80) != 0);
        return l2;
    }

    public static long getResultSize(byte[] byArray) {
        int n2;
        int n3 = 0;
        while (((n2 = byArray[n3++] & 0xFF) & 0x80) != 0) {
        }
        long l2 = 0L;
        int n4 = 0;
        do {
            n2 = byArray[n3++] & 0xFF;
            l2 |= (long)(n2 & 0x7F) << n4;
            n4 += 7;
        } while ((n2 & 0x80) != 0);
        return l2;
    }

    public static final byte[] apply(byte[] byArray, byte[] byArray2) {
        return BinaryDelta.apply(byArray, byArray2, null);
    }

    public static final byte[] apply(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        do {
            n2 = byArray2[n3++] & 0xFF;
            n4 |= (n2 & 0x7F) << n5;
            n5 += 7;
        } while ((n2 & 0x80) != 0);
        if (byArray.length != n4) {
            throw new IllegalArgumentException(JGitText.get().baseLengthIncorrect);
        }
        int n6 = 0;
        n5 = 0;
        do {
            n2 = byArray2[n3++] & 0xFF;
            n6 |= (n2 & 0x7F) << n5;
            n5 += 7;
        } while ((n2 & 0x80) != 0);
        if (byArray3 == null) {
            byArray3 = new byte[n6];
        } else if (byArray3.length != n6) {
            throw new IllegalArgumentException(JGitText.get().resultLengthIncorrect);
        }
        int n7 = 0;
        while (n3 < byArray2.length) {
            int n8;
            if (((n8 = byArray2[n3++] & 0xFF) & 0x80) != 0) {
                int n9 = 0;
                if ((n8 & 1) != 0) {
                    n9 = byArray2[n3++] & 0xFF;
                }
                if ((n8 & 2) != 0) {
                    n9 |= (byArray2[n3++] & 0xFF) << 8;
                }
                if ((n8 & 4) != 0) {
                    n9 |= (byArray2[n3++] & 0xFF) << 16;
                }
                if ((n8 & 8) != 0) {
                    n9 |= (byArray2[n3++] & 0xFF) << 24;
                }
                int n10 = 0;
                if ((n8 & 0x10) != 0) {
                    n10 = byArray2[n3++] & 0xFF;
                }
                if ((n8 & 0x20) != 0) {
                    n10 |= (byArray2[n3++] & 0xFF) << 8;
                }
                if ((n8 & 0x40) != 0) {
                    n10 |= (byArray2[n3++] & 0xFF) << 16;
                }
                if (n10 == 0) {
                    n10 = 65536;
                }
                System.arraycopy(byArray, n9, byArray3, n7, n10);
                n7 += n10;
                continue;
            }
            if (n8 != 0) {
                System.arraycopy(byArray2, n3, byArray3, n7, n8);
                n3 += n8;
                n7 += n8;
                continue;
            }
            throw new IllegalArgumentException(JGitText.get().unsupportedCommand0);
        }
        return byArray3;
    }

    public static String format(byte[] byArray) {
        return BinaryDelta.format(byArray, true);
    }

    public static String format(byte[] byArray, boolean bl2) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        long l2 = 0L;
        int n4 = 0;
        do {
            n2 = byArray[n3++] & 0xFF;
            l2 |= (long)(n2 & 0x7F) << n4;
            n4 += 7;
        } while ((n2 & 0x80) != 0);
        long l3 = 0L;
        n4 = 0;
        do {
            n2 = byArray[n3++] & 0xFF;
            l3 |= (long)(n2 & 0x7F) << n4;
            n4 += 7;
        } while ((n2 & 0x80) != 0);
        if (bl2) {
            stringBuilder.append("DELTA( BASE=");
            stringBuilder.append(l2);
            stringBuilder.append(" RESULT=");
            stringBuilder.append(l3);
            stringBuilder.append(" )\n");
        }
        while (n3 < byArray.length) {
            int n5;
            if (((n5 = byArray[n3++] & 0xFF) & 0x80) != 0) {
                int n6 = 0;
                if ((n5 & 1) != 0) {
                    n6 = byArray[n3++] & 0xFF;
                }
                if ((n5 & 2) != 0) {
                    n6 |= (byArray[n3++] & 0xFF) << 8;
                }
                if ((n5 & 4) != 0) {
                    n6 |= (byArray[n3++] & 0xFF) << 16;
                }
                if ((n5 & 8) != 0) {
                    n6 |= (byArray[n3++] & 0xFF) << 24;
                }
                int n7 = 0;
                if ((n5 & 0x10) != 0) {
                    n7 = byArray[n3++] & 0xFF;
                }
                if ((n5 & 0x20) != 0) {
                    n7 |= (byArray[n3++] & 0xFF) << 8;
                }
                if ((n5 & 0x40) != 0) {
                    n7 |= (byArray[n3++] & 0xFF) << 16;
                }
                if (n7 == 0) {
                    n7 = 65536;
                }
                stringBuilder.append("  COPY  (");
                stringBuilder.append(n6);
                stringBuilder.append(", ");
                stringBuilder.append(n7);
                stringBuilder.append(")\n");
                continue;
            }
            if (n5 != 0) {
                stringBuilder.append("  INSERT(");
                stringBuilder.append(QuotedString.GIT_PATH.quote(RawParseUtils.decode(byArray, n3, n3 + n5)));
                stringBuilder.append(")\n");
                n3 += n5;
                continue;
            }
            throw new IllegalArgumentException(JGitText.get().unsupportedCommand0);
        }
        return stringBuilder.toString();
    }
}

