/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.pack;

import java.util.List;
import java.util.Set;
import org.eclipse.jgit.internal.storage.pack.BaseSearch$TreeWithData;
import org.eclipse.jgit.internal.storage.pack.IntSet;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdOwnerMap;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;

class BaseSearch {
    private static final int M_BLOB = FileMode.REGULAR_FILE.getBits();
    private static final int M_TREE = FileMode.TREE.getBits();
    private final ProgressMonitor progress;
    private final ObjectReader reader;
    private final ObjectId[] baseTrees;
    private final ObjectIdOwnerMap objectsMap;
    private final List edgeObjects;
    private final IntSet alreadyProcessed;
    private final ObjectIdOwnerMap treeCache;
    private final CanonicalTreeParser parser;
    private final MutableObjectId idBuf;

    BaseSearch(ProgressMonitor progressMonitor, Set set, ObjectIdOwnerMap objectIdOwnerMap, List list, ObjectReader objectReader) {
        this.progress = progressMonitor;
        this.reader = objectReader;
        this.baseTrees = set.toArray(new ObjectId[0]);
        this.objectsMap = objectIdOwnerMap;
        this.edgeObjects = list;
        this.alreadyProcessed = new IntSet();
        this.treeCache = new ObjectIdOwnerMap();
        this.parser = new CanonicalTreeParser();
        this.idBuf = new MutableObjectId();
    }

    void addBase(int n2, byte[] byArray, int n3, int n4) {
        int n5 = BaseSearch.modeForType(n2);
        if (n5 == 0) {
            return;
        }
        if (!this.alreadyProcessed.add(n4)) {
            return;
        }
        if (n3 == 0) {
            for (ObjectId objectId : this.baseTrees) {
                this.add(objectId, 2, n4);
            }
            return;
        }
        int n6 = BaseSearch.nextSlash(byArray, 0, n3);
        block1: for (ObjectId objectId : this.baseTrees) {
            int n7 = 0;
            int n8 = n6;
            int n9 = n8 != n3 ? M_TREE : n5;
            this.parser.reset(this.readTree(objectId));
            while (!this.parser.eof()) {
                int n10 = this.parser.pathCompare(byArray, n7, n8, n9);
                if (n10 < 0) {
                    this.parser.next();
                    continue;
                }
                if (n10 > 0) continue block1;
                if (n8 == n3) {
                    if (this.parser.getEntryFileMode().getObjectType() != n2) continue block1;
                    this.idBuf.fromRaw(this.parser.idBuffer(), this.parser.idOffset());
                    this.add(this.idBuf, n2, n4);
                    continue block1;
                }
                if (!FileMode.TREE.equals(this.parser.getEntryRawMode())) continue block1;
                n7 = n8 + 1;
                n9 = (n8 = BaseSearch.nextSlash(byArray, n7, n3)) != n3 ? M_TREE : n5;
                this.idBuf.fromRaw(this.parser.idBuffer(), this.parser.idOffset());
                this.parser.reset(this.readTree(this.idBuf));
            }
        }
    }

    private static int modeForType(int n2) {
        switch (n2) {
            case 2: {
                return M_TREE;
            }
            case 3: {
                return M_BLOB;
            }
        }
        return 0;
    }

    private static int nextSlash(byte[] byArray, int n2, int n3) {
        while (n2 < n3 && byArray[n2] != 47) {
            ++n2;
        }
        return n2;
    }

    private void add(AnyObjectId anyObjectId, int n2, int n3) {
        ObjectToPack objectToPack = new ObjectToPack(anyObjectId, n2);
        objectToPack.setEdge();
        objectToPack.setPathHash(n3);
        if (this.objectsMap.addIfAbsent(objectToPack) == objectToPack) {
            this.edgeObjects.add(objectToPack);
            this.progress.update(1);
        }
    }

    private byte[] readTree(AnyObjectId anyObjectId) {
        BaseSearch$TreeWithData baseSearch$TreeWithData = (BaseSearch$TreeWithData)this.treeCache.get(anyObjectId);
        if (baseSearch$TreeWithData != null) {
            return baseSearch$TreeWithData.buf;
        }
        ObjectLoader objectLoader = this.reader.open(anyObjectId, 2);
        byte[] byArray = objectLoader.getCachedBytes(Integer.MAX_VALUE);
        this.treeCache.add(new BaseSearch$TreeWithData(anyObjectId, byArray));
        return byArray;
    }
}

