/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.BitmapIndexImpl;
import org.eclipse.jgit.internal.storage.file.ByteArrayWindow;
import org.eclipse.jgit.internal.storage.file.ByteWindow;
import org.eclipse.jgit.internal.storage.file.DeltaBaseCache;
import org.eclipse.jgit.internal.storage.file.FileObjectDatabase;
import org.eclipse.jgit.internal.storage.file.LocalCachedPack;
import org.eclipse.jgit.internal.storage.file.LocalObjectToPack;
import org.eclipse.jgit.internal.storage.file.ObjectDirectoryInserter;
import org.eclipse.jgit.internal.storage.file.Pack;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndex;
import org.eclipse.jgit.internal.storage.file.WindowCache;
import org.eclipse.jgit.internal.storage.pack.CachedPack;
import org.eclipse.jgit.internal.storage.pack.ObjectReuseAsIs;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.internal.storage.pack.PackOutputStream;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BitmapIndex;
import org.eclipse.jgit.lib.BitmapIndex$BitmapBuilder;
import org.eclipse.jgit.lib.InflaterCache;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;

final class WindowCursor
extends ObjectReader
implements ObjectReuseAsIs {
    final byte[] tempId = new byte[20];
    private Inflater inf;
    private ByteWindow window;
    private DeltaBaseCache baseCache;
    @Nullable
    private final ObjectInserter createdFromInserter;
    final FileObjectDatabase db;

    WindowCursor(FileObjectDatabase fileObjectDatabase) {
        this.db = fileObjectDatabase;
        this.createdFromInserter = null;
        this.streamFileThreshold = WindowCache.getStreamFileThreshold();
    }

    WindowCursor(FileObjectDatabase fileObjectDatabase, @Nullable ObjectDirectoryInserter objectDirectoryInserter) {
        this.db = fileObjectDatabase;
        this.createdFromInserter = objectDirectoryInserter;
        this.streamFileThreshold = WindowCache.getStreamFileThreshold();
    }

    DeltaBaseCache getDeltaBaseCache() {
        if (this.baseCache == null) {
            this.baseCache = new DeltaBaseCache();
        }
        return this.baseCache;
    }

    @Override
    public ObjectReader newReader() {
        return new WindowCursor(this.db);
    }

    @Override
    public BitmapIndex getBitmapIndex() {
        for (Pack pack : this.db.getPacks()) {
            PackBitmapIndex packBitmapIndex = pack.getBitmapIndex();
            if (packBitmapIndex == null) continue;
            return new BitmapIndexImpl(packBitmapIndex);
        }
        return null;
    }

    @Override
    public Collection getCachedPacksAndUpdate(BitmapIndex$BitmapBuilder bitmapIndex$BitmapBuilder) {
        for (Pack pack : this.db.getPacks()) {
            PackBitmapIndex packBitmapIndex = pack.getBitmapIndex();
            if (!bitmapIndex$BitmapBuilder.removeAllOrNone(packBitmapIndex)) continue;
            return Collections.singletonList(new LocalCachedPack(Collections.singletonList(pack)));
        }
        return Collections.emptyList();
    }

    @Override
    public Collection resolve(AbbreviatedObjectId abbreviatedObjectId) {
        if (abbreviatedObjectId.isComplete()) {
            return Collections.singleton(abbreviatedObjectId.toObjectId());
        }
        HashSet hashSet = new HashSet(4);
        this.db.resolve(hashSet, abbreviatedObjectId);
        return hashSet;
    }

    @Override
    public boolean has(AnyObjectId anyObjectId) {
        return this.db.has(anyObjectId);
    }

    @Override
    public ObjectLoader open(AnyObjectId anyObjectId, int n2) {
        ObjectLoader objectLoader = this.db.openObject(this, anyObjectId);
        if (objectLoader == null) {
            if (n2 == -1) {
                throw new MissingObjectException(anyObjectId.copy(), JGitText.get().unknownObjectType2);
            }
            throw new MissingObjectException(anyObjectId.copy(), n2);
        }
        if (n2 != -1 && objectLoader.getType() != n2) {
            throw new IncorrectObjectTypeException(anyObjectId.copy(), n2);
        }
        return objectLoader;
    }

    @Override
    public Set getShallowCommits() {
        return this.db.getShallowCommits();
    }

    @Override
    public long getObjectSize(AnyObjectId anyObjectId, int n2) {
        long l2 = this.db.getObjectSize(this, anyObjectId);
        if (l2 < 0L) {
            if (n2 == -1) {
                throw new MissingObjectException(anyObjectId.copy(), JGitText.get().unknownObjectType2);
            }
            throw new MissingObjectException(anyObjectId.copy(), n2);
        }
        return l2;
    }

    @Override
    public LocalObjectToPack newObjectToPack(AnyObjectId anyObjectId, int n2) {
        return new LocalObjectToPack(anyObjectId, n2);
    }

    @Override
    public void selectObjectRepresentation(PackWriter packWriter, ProgressMonitor progressMonitor, Iterable iterable) {
        for (ObjectToPack objectToPack : iterable) {
            this.db.selectObjectRepresentation(packWriter, objectToPack, this);
            progressMonitor.update(1);
        }
    }

    @Override
    public void copyObjectAsIs(PackOutputStream packOutputStream, ObjectToPack objectToPack, boolean bl2) {
        LocalObjectToPack localObjectToPack = (LocalObjectToPack)objectToPack;
        localObjectToPack.pack.copyAsIs(packOutputStream, localObjectToPack, bl2, this);
    }

    @Override
    public void writeObjects(PackOutputStream packOutputStream, List list) {
        for (ObjectToPack objectToPack : list) {
            packOutputStream.writeObject(objectToPack);
        }
    }

    int copy(Pack pack, long l2, byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        long l3 = pack.length;
        for (n4 = n3; n4 > 0 && l2 < l3; n4 -= n5) {
            this.pin(pack, l2);
            n5 = this.window.copy(l2, byArray, n2, n4);
            l2 += (long)n5;
            n2 += n5;
        }
        return n3 - n4;
    }

    @Override
    public void copyPackAsIs(PackOutputStream packOutputStream, CachedPack cachedPack) {
        ((LocalCachedPack)cachedPack).copyAsIs(packOutputStream, this);
    }

    void copyPackAsIs(Pack pack, long l2, PackOutputStream packOutputStream) {
        int n2;
        long l3 = 12L;
        for (long i2 = l2 - 32L; 0L < i2; i2 -= (long)n2) {
            this.pin(pack, l3);
            int n3 = (int)(l3 - this.window.start);
            n2 = (int)Math.min((long)(this.window.size() - n3), i2);
            this.window.write(packOutputStream, l3, n2);
            l3 += (long)n2;
        }
    }

    int inflate(Pack pack, long l2, byte[] byArray, boolean bl2) {
        this.prepareInflater();
        this.pin(pack, l2);
        l2 += (long)this.window.setInput(l2, this.inf);
        int n2 = 0;
        while (true) {
            int n3 = this.inf.inflate(byArray, n2, byArray.length - n2);
            if (this.inf.finished() || bl2 && (n2 += n3) == byArray.length) {
                return n2;
            }
            if (this.inf.needsInput()) {
                this.pin(pack, l2);
                l2 += (long)this.window.setInput(l2, this.inf);
                continue;
            }
            if (n3 == 0) break;
        }
        throw new DataFormatException();
    }

    ByteArrayWindow quickCopy(Pack pack, long l2, long l3) {
        this.pin(pack, l2);
        if (this.window instanceof ByteArrayWindow && this.window.contains(pack, l2 + (l3 - 1L))) {
            return (ByteArrayWindow)this.window;
        }
        return null;
    }

    Inflater inflater() {
        this.prepareInflater();
        return this.inf;
    }

    private void prepareInflater() {
        if (this.inf == null) {
            this.inf = InflaterCache.get();
        } else {
            this.inf.reset();
        }
    }

    void pin(Pack pack, long l2) {
        ByteWindow byteWindow = this.window;
        if (byteWindow == null || !byteWindow.contains(pack, l2)) {
            this.window = null;
            this.window = WindowCache.get(pack, l2);
        }
    }

    @Override
    @Nullable
    public ObjectInserter getCreatedFromInserter() {
        return this.createdFromInserter;
    }

    @Override
    public void close() {
        this.window = null;
        this.baseCache = null;
        try {
            InflaterCache.release(this.inf);
        }
        finally {
            this.inf = null;
        }
    }
}

