/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.IOException;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.ByteArrayWindow;
import org.eclipse.jgit.internal.storage.file.ByteWindow;
import org.eclipse.jgit.internal.storage.file.DeltaBaseCache;
import org.eclipse.jgit.internal.storage.file.Pack;
import org.eclipse.jgit.internal.storage.file.WindowCache$CleanupQueue;
import org.eclipse.jgit.internal.storage.file.WindowCache$Entry;
import org.eclipse.jgit.internal.storage.file.WindowCache$Lock;
import org.eclipse.jgit.internal.storage.file.WindowCache$PageRef;
import org.eclipse.jgit.internal.storage.file.WindowCache$SoftCleanupQueue;
import org.eclipse.jgit.internal.storage.file.WindowCache$SoftRef;
import org.eclipse.jgit.internal.storage.file.WindowCache$StatsRecorder;
import org.eclipse.jgit.internal.storage.file.WindowCache$StatsRecorderImpl;
import org.eclipse.jgit.internal.storage.file.WindowCache$StrongCleanupQueue;
import org.eclipse.jgit.internal.storage.file.WindowCache$StrongRef;
import org.eclipse.jgit.storage.file.WindowCacheConfig;
import org.eclipse.jgit.storage.file.WindowCacheStats;
import org.eclipse.jgit.util.Monitoring;

public class WindowCache {
    private static final Random rng = new Random();
    private static volatile WindowCache cache;
    private static volatile int streamFileThreshold;
    private final WindowCache$CleanupQueue queue;
    private final int tableSize;
    private final AtomicLong clock;
    private final AtomicReferenceArray table;
    private final WindowCache$Lock[] locks;
    private final ReentrantLock evictLock;
    private final int evictBatch;
    private final int maxFiles;
    private final long maxBytes;
    private final boolean mmap;
    private final int windowSizeShift;
    private final int windowSize;
    private final WindowCache$StatsRecorder statsRecorder;
    private final WindowCache$StatsRecorderImpl mbean;
    private final AtomicBoolean publishMBean = new AtomicBoolean();
    private boolean useStrongRefs;

    private static final int bits(int n2) {
        if (n2 < 4096) {
            throw new IllegalArgumentException(JGitText.get().invalidWindowSize);
        }
        if (Integer.bitCount(n2) != 1) {
            throw new IllegalArgumentException(JGitText.get().windowSizeMustBePowerOf2);
        }
        return Integer.numberOfTrailingZeros(n2);
    }

    @Deprecated
    public static void reconfigure(WindowCacheConfig windowCacheConfig) {
        WindowCache windowCache = new WindowCache(windowCacheConfig);
        WindowCache windowCache2 = cache;
        if (windowCache2 != null) {
            windowCache2.removeAll();
        }
        cache = windowCache;
        streamFileThreshold = windowCacheConfig.getStreamFileThreshold();
        DeltaBaseCache.reconfigure(windowCacheConfig);
    }

    static int getStreamFileThreshold() {
        return streamFileThreshold;
    }

    public static WindowCache getInstance() {
        return cache.publishMBeanIfNeeded();
    }

    static final ByteWindow get(Pack pack, long l2) {
        WindowCache windowCache = cache;
        ByteWindow byteWindow = windowCache.getOrLoad(pack, windowCache.toStart(l2));
        if (windowCache != cache.publishMBeanIfNeeded()) {
            windowCache.removeAll();
        }
        return byteWindow;
    }

    static final void purge(Pack pack) {
        cache.removeAll(pack);
    }

    private WindowCache(WindowCacheConfig windowCacheConfig) {
        int n2;
        this.tableSize = WindowCache.tableSize(windowCacheConfig);
        int n3 = WindowCache.lockCount(windowCacheConfig);
        if (this.tableSize < 1) {
            throw new IllegalArgumentException(JGitText.get().tSizeMustBeGreaterOrEqual1);
        }
        if (n3 < 1) {
            throw new IllegalArgumentException(JGitText.get().lockCountMustBeGreaterOrEqual1);
        }
        this.clock = new AtomicLong(1L);
        this.table = new AtomicReferenceArray(this.tableSize);
        this.locks = new WindowCache$Lock[n3];
        for (n2 = 0; n2 < this.locks.length; ++n2) {
            this.locks[n2] = new WindowCache$Lock(null);
        }
        this.evictLock = new ReentrantLock();
        n2 = (int)((double)this.tableSize * 0.1);
        if (64 < n2) {
            n2 = 64;
        } else if (n2 < 4) {
            n2 = 4;
        }
        if (this.tableSize < n2) {
            n2 = this.tableSize;
        }
        this.evictBatch = n2;
        this.maxFiles = windowCacheConfig.getPackedGitOpenFiles();
        this.maxBytes = windowCacheConfig.getPackedGitLimit();
        this.mmap = windowCacheConfig.isPackedGitMMAP();
        this.windowSizeShift = WindowCache.bits(windowCacheConfig.getPackedGitWindowSize());
        this.windowSize = 1 << this.windowSizeShift;
        this.useStrongRefs = windowCacheConfig.isPackedGitUseStrongRefs();
        this.queue = this.useStrongRefs ? new WindowCache$StrongCleanupQueue(this) : new WindowCache$SoftCleanupQueue(this);
        this.mbean = new WindowCache$StatsRecorderImpl();
        this.statsRecorder = this.mbean;
        this.publishMBean.set(windowCacheConfig.getExposeStatsViaJmx());
        if (this.maxFiles < 1) {
            throw new IllegalArgumentException(JGitText.get().openFilesMustBeAtLeast1);
        }
        if (this.maxBytes < (long)this.windowSize) {
            throw new IllegalArgumentException(JGitText.get().windowSizeMustBeLesserThanLimit);
        }
    }

    private WindowCache publishMBeanIfNeeded() {
        if (this.publishMBean.getAndSet(false)) {
            Monitoring.registerMBean(this.mbean, "block_cache");
        }
        return this;
    }

    public WindowCacheStats getStats() {
        return this.statsRecorder.getStats();
    }

    public void resetStats() {
        this.mbean.resetCounters();
    }

    private int hash(int n2, long l2) {
        return n2 + (int)(l2 >>> this.windowSizeShift);
    }

    private ByteWindow load(Pack pack, long l2) {
        long l3 = System.nanoTime();
        if (pack.beginWindowCache()) {
            this.statsRecorder.recordOpenFiles(1);
        }
        try {
            if (this.mmap) {
                ByteWindow byteWindow = pack.mmap(l2, this.windowSize);
                return byteWindow;
            }
            ByteArrayWindow byteArrayWindow = pack.read(l2, this.windowSize);
            this.statsRecorder.recordLoadSuccess(System.nanoTime() - l3);
            ByteArrayWindow byteArrayWindow2 = byteArrayWindow;
            return byteArrayWindow2;
        }
        catch (IOException | Error | RuntimeException throwable) {
            this.close(pack);
            this.statsRecorder.recordLoadFailure(System.nanoTime() - l3);
            throw throwable;
        }
        finally {
            this.statsRecorder.recordMisses(1);
        }
    }

    private WindowCache$PageRef createRef(Pack pack, long l2, ByteWindow byteWindow) {
        WindowCache$PageRef windowCache$PageRef = this.useStrongRefs ? new WindowCache$StrongRef(pack, l2, byteWindow, this.queue) : new WindowCache$SoftRef(pack, l2, byteWindow, (WindowCache$SoftCleanupQueue)this.queue);
        this.statsRecorder.recordOpenBytes(windowCache$PageRef.getPack(), windowCache$PageRef.getSize());
        return windowCache$PageRef;
    }

    private void clear(WindowCache$PageRef windowCache$PageRef) {
        this.statsRecorder.recordOpenBytes(windowCache$PageRef.getPack(), -windowCache$PageRef.getSize());
        this.statsRecorder.recordEvictions(1);
        this.close(windowCache$PageRef.getPack());
    }

    private void close(Pack pack) {
        if (pack.endWindowCache()) {
            this.statsRecorder.recordOpenFiles(-1);
        }
    }

    private boolean isFull() {
        return (long)this.maxFiles < this.mbean.getOpenFileCount() || this.maxBytes < this.mbean.getOpenByteCount();
    }

    private long toStart(long l2) {
        return l2 >>> this.windowSizeShift << this.windowSizeShift;
    }

    private static int tableSize(WindowCacheConfig windowCacheConfig) {
        int n2 = windowCacheConfig.getPackedGitWindowSize();
        long l2 = windowCacheConfig.getPackedGitLimit();
        if (n2 <= 0) {
            throw new IllegalArgumentException(JGitText.get().invalidWindowSize);
        }
        if (l2 < (long)n2) {
            throw new IllegalArgumentException(JGitText.get().windowSizeMustBeLesserThanLimit);
        }
        return (int)Math.min(5L * (l2 / (long)n2) / 2L, 2000000000L);
    }

    private static int lockCount(WindowCacheConfig windowCacheConfig) {
        return Math.max(windowCacheConfig.getPackedGitOpenFiles(), 32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteWindow getOrLoad(Pack pack, long l2) {
        int n2 = this.slot(pack, l2);
        WindowCache$Entry windowCache$Entry = (WindowCache$Entry)this.table.get(n2);
        ByteWindow byteWindow = this.scan(windowCache$Entry, pack, l2);
        if (byteWindow != null) {
            this.statsRecorder.recordHits(1);
            return byteWindow;
        }
        WindowCache$Lock windowCache$Lock = this.lock(pack, l2);
        synchronized (windowCache$Lock) {
            WindowCache$Entry windowCache$Entry2;
            WindowCache$Entry windowCache$Entry3 = (WindowCache$Entry)this.table.get(n2);
            if (windowCache$Entry3 != windowCache$Entry && (byteWindow = this.scan(windowCache$Entry3, pack, l2)) != null) {
                this.statsRecorder.recordHits(1);
                return byteWindow;
            }
            byteWindow = this.load(pack, l2);
            WindowCache$PageRef windowCache$PageRef = this.createRef(pack, l2, byteWindow);
            this.hit(windowCache$PageRef);
            while (!this.table.compareAndSet(n2, windowCache$Entry3, windowCache$Entry2 = new WindowCache$Entry(WindowCache.clean(windowCache$Entry3), windowCache$PageRef))) {
                windowCache$Entry3 = (WindowCache$Entry)this.table.get(n2);
            }
        }
        if (this.evictLock.tryLock()) {
            try {
                this.gc();
                this.evict();
            }
            finally {
                this.evictLock.unlock();
            }
        }
        return byteWindow;
    }

    private ByteWindow scan(WindowCache$Entry windowCache$Entry, Pack pack, long l2) {
        while (windowCache$Entry != null) {
            WindowCache$PageRef windowCache$PageRef = windowCache$Entry.ref;
            if (windowCache$PageRef.getPack() == pack && windowCache$PageRef.getPosition() == l2) {
                ByteWindow byteWindow = (ByteWindow)windowCache$PageRef.get();
                if (byteWindow != null) {
                    this.hit(windowCache$PageRef);
                    return byteWindow;
                }
                windowCache$Entry.kill();
                break;
            }
            windowCache$Entry = windowCache$Entry.next;
        }
        return null;
    }

    private void hit(WindowCache$PageRef windowCache$PageRef) {
        long l2 = this.clock.get();
        this.clock.compareAndSet(l2, l2 + 1L);
        windowCache$PageRef.setLastAccess(l2);
    }

    private void evict() {
        while (this.isFull()) {
            int n2 = rng.nextInt(this.tableSize);
            WindowCache$Entry windowCache$Entry = null;
            int n3 = 0;
            int n4 = this.evictBatch - 1;
            while (n4 >= 0) {
                if (this.tableSize <= n2) {
                    n2 = 0;
                }
                WindowCache$Entry windowCache$Entry2 = (WindowCache$Entry)this.table.get(n2);
                while (windowCache$Entry2 != null) {
                    if (!(windowCache$Entry2.dead || windowCache$Entry != null && windowCache$Entry2.ref.getLastAccess() >= windowCache$Entry.ref.getLastAccess())) {
                        windowCache$Entry = windowCache$Entry2;
                        n3 = n2;
                    }
                    windowCache$Entry2 = windowCache$Entry2.next;
                }
                --n4;
                ++n2;
            }
            if (windowCache$Entry == null) continue;
            windowCache$Entry.kill();
            this.gc();
            WindowCache$Entry windowCache$Entry3 = (WindowCache$Entry)this.table.get(n3);
            this.table.compareAndSet(n3, windowCache$Entry3, WindowCache.clean(windowCache$Entry3));
        }
    }

    private void removeAll() {
        for (int i2 = 0; i2 < this.tableSize; ++i2) {
            WindowCache$Entry windowCache$Entry;
            do {
                WindowCache$Entry windowCache$Entry2 = windowCache$Entry = (WindowCache$Entry)this.table.get(i2);
                while (windowCache$Entry2 != null) {
                    windowCache$Entry2.kill();
                    windowCache$Entry2 = windowCache$Entry2.next;
                }
            } while (!this.table.compareAndSet(i2, windowCache$Entry, null));
        }
        this.gc();
    }

    private void removeAll(Pack pack) {
        for (int i2 = 0; i2 < this.tableSize; ++i2) {
            WindowCache$Entry windowCache$Entry = (WindowCache$Entry)this.table.get(i2);
            boolean bl2 = false;
            WindowCache$Entry windowCache$Entry2 = windowCache$Entry;
            while (windowCache$Entry2 != null) {
                if (windowCache$Entry2.ref.getPack() == pack) {
                    windowCache$Entry2.kill();
                    bl2 = true;
                } else if (windowCache$Entry2.dead) {
                    bl2 = true;
                }
                windowCache$Entry2 = windowCache$Entry2.next;
            }
            if (!bl2) continue;
            this.table.compareAndSet(i2, windowCache$Entry, WindowCache.clean(windowCache$Entry));
        }
        this.gc();
    }

    private void gc() {
        this.queue.gc();
    }

    private int slot(Pack pack, long l2) {
        return (this.hash(pack.hash, l2) >>> 1) % this.tableSize;
    }

    private WindowCache$Lock lock(Pack pack, long l2) {
        return this.locks[(this.hash(pack.hash, l2) >>> 1) % this.locks.length];
    }

    private static WindowCache$Entry clean(WindowCache$Entry windowCache$Entry) {
        while (windowCache$Entry != null && windowCache$Entry.dead) {
            windowCache$Entry.ref.kill();
            windowCache$Entry = windowCache$Entry.next;
        }
        if (windowCache$Entry == null) {
            return null;
        }
        WindowCache$Entry windowCache$Entry2 = WindowCache.clean(windowCache$Entry.next);
        return windowCache$Entry2 == windowCache$Entry.next ? windowCache$Entry : new WindowCache$Entry(windowCache$Entry2, windowCache$Entry.ref);
    }

    static /* synthetic */ void access$100(WindowCache windowCache, WindowCache$PageRef windowCache$PageRef) {
        windowCache.clear(windowCache$PageRef);
    }

    static /* synthetic */ int access$200(WindowCache windowCache, Pack pack, long l2) {
        return windowCache.slot(pack, l2);
    }

    static /* synthetic */ AtomicReferenceArray access$300(WindowCache windowCache) {
        return windowCache.table;
    }

    static /* synthetic */ WindowCache$Entry access$400(WindowCache$Entry windowCache$Entry) {
        return WindowCache.clean(windowCache$Entry);
    }

    static {
        WindowCache.reconfigure(new WindowCacheConfig());
    }
}

