/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import org.eclipse.jgit.internal.storage.file.Pack;
import org.eclipse.jgit.internal.storage.file.WindowCache$StatsRecorder;
import org.eclipse.jgit.storage.file.WindowCacheStats;

class WindowCache$StatsRecorderImpl
implements WindowCache$StatsRecorder,
WindowCacheStats {
    private final LongAdder hitCount = new LongAdder();
    private final LongAdder missCount = new LongAdder();
    private final LongAdder loadSuccessCount = new LongAdder();
    private final LongAdder loadFailureCount = new LongAdder();
    private final LongAdder totalLoadTime = new LongAdder();
    private final LongAdder evictionCount = new LongAdder();
    private final LongAdder openFileCount = new LongAdder();
    private final LongAdder openByteCount = new LongAdder();
    private final Map openByteCountPerRepository = new ConcurrentHashMap();

    @Override
    public void recordHits(int n2) {
        this.hitCount.add(n2);
    }

    @Override
    public void recordMisses(int n2) {
        this.missCount.add(n2);
    }

    @Override
    public void recordLoadSuccess(long l2) {
        this.loadSuccessCount.increment();
        this.totalLoadTime.add(l2);
    }

    @Override
    public void recordLoadFailure(long l2) {
        this.loadFailureCount.increment();
        this.totalLoadTime.add(l2);
    }

    @Override
    public void recordEvictions(int n2) {
        this.evictionCount.add(n2);
    }

    @Override
    public void recordOpenFiles(int n2) {
        this.openFileCount.add(n2);
    }

    @Override
    public void recordOpenBytes(Pack pack, int n2) {
        this.openByteCount.add(n2);
        String string2 = WindowCache$StatsRecorderImpl.repositoryId(pack);
        LongAdder longAdder2 = this.openByteCountPerRepository.computeIfAbsent(string2, string -> new LongAdder());
        longAdder2.add(n2);
        if (n2 < 0) {
            this.openByteCountPerRepository.computeIfPresent(string2, (string, longAdder) -> longAdder.longValue() == 0L ? null : longAdder);
        }
    }

    private static String repositoryId(Pack pack) {
        return pack.getPackFile().getParentFile().getParentFile().getParent();
    }

    @Override
    public WindowCacheStats getStats() {
        return this;
    }

    @Override
    public long getHitCount() {
        return this.hitCount.sum();
    }

    @Override
    public long getMissCount() {
        return this.missCount.sum();
    }

    @Override
    public long getLoadSuccessCount() {
        return this.loadSuccessCount.sum();
    }

    @Override
    public long getLoadFailureCount() {
        return this.loadFailureCount.sum();
    }

    @Override
    public long getEvictionCount() {
        return this.evictionCount.sum();
    }

    @Override
    public long getTotalLoadTime() {
        return this.totalLoadTime.sum();
    }

    @Override
    public long getOpenFileCount() {
        return this.openFileCount.sum();
    }

    @Override
    public long getOpenByteCount() {
        return this.openByteCount.sum();
    }

    @Override
    public void resetCounters() {
        this.hitCount.reset();
        this.missCount.reset();
        this.loadSuccessCount.reset();
        this.loadFailureCount.reset();
        this.totalLoadTime.reset();
        this.evictionCount.reset();
    }

    @Override
    public Map getOpenByteCountPerRepository() {
        return Collections.unmodifiableMap(this.openByteCountPerRepository.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((LongAdder)entry.getValue()).sum(), (l2, l3) -> l3)));
    }
}

