/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.util.concurrent.atomic.AtomicReferenceArray;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;

class UnpackedObjectCache$Table {
    private static final int MAX_CHAIN = 8;
    private final AtomicReferenceArray ids;
    private final int shift;
    final int bits;

    UnpackedObjectCache$Table(int n2) {
        this.ids = new AtomicReferenceArray(1 << n2);
        this.shift = 32 - n2;
        this.bits = n2;
    }

    boolean contains(AnyObjectId anyObjectId) {
        ObjectId objectId;
        int n2 = this.index(anyObjectId);
        for (int i2 = 0; i2 < 8 && (objectId = (ObjectId)this.ids.get(n2)) != null; ++i2) {
            if (AnyObjectId.isEqual(objectId, anyObjectId)) {
                return true;
            }
            if (++n2 != this.ids.length()) continue;
            n2 = 0;
        }
        return false;
    }

    boolean add(AnyObjectId anyObjectId) {
        int n2 = this.index(anyObjectId);
        int n3 = 0;
        while (n3 < 8) {
            ObjectId objectId = (ObjectId)this.ids.get(n2);
            if (objectId == null) {
                if (!this.ids.compareAndSet(n2, null, anyObjectId.copy())) continue;
                return true;
            }
            if (AnyObjectId.isEqual(objectId, anyObjectId)) {
                return true;
            }
            if (++n2 == this.ids.length()) {
                n2 = 0;
            }
            ++n3;
        }
        return false;
    }

    private int index(AnyObjectId anyObjectId) {
        return anyObjectId.hashCode() >>> this.shift;
    }
}

